% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_cases}
\alias{simulate_cases}
\title{Simulate Cases by Date of Infection, Onset and Report}
\usage{
simulate_cases(
  rts,
  initial_cases,
  initial_date,
  generation_interval,
  rdist = rpois,
  delay_defs,
  reporting_effect,
  reporting_model,
  truncate_future = TRUE,
  type = "sample"
)
}
\arguments{
\item{rts}{A dataframe of containing two variables \code{rt} and  \code{date} with
\code{rt} being numeric and \code{date} being a date.}

\item{initial_cases}{Integer, initial number of cases.}

\item{initial_date}{Date, (i.e \code{as.Date("2020-02-01")}). Starting date of the simulation.}

\item{generation_interval}{Numeric vector describing the generation interval probability density}

\item{rdist}{A function to be used to sample the number of cases. Must take two
arguments with the first specifying the number of samples and the second the mean. Defaults
to \code{rpois} if not supplied}

\item{delay_defs}{A list of single row data.tables that each  defines a delay distribution (model, parameters and maximum delay for each model).
See \code{lognorm_dist_def} for an example of the structure.}

\item{reporting_effect}{A numeric vector of length 7 that allows the scaling of reported cases
by the day on which they report (1 = Monday, 7 = Sunday). By default no scaling occurs.}

\item{reporting_model}{A function that takes a single numeric vector as an argument and returns a
single numeric vector. Can be used to apply stochastic reporting effects. See the examples for details.}

\item{truncate_future}{Logical, should cases be truncated if they occur after the first date reported in the data.
Defaults to \code{TRUE}.}

\item{type}{Character string indicating the method to use to transform counts. Supports either "sample"
which approximates sampling or "median" would shift by the median of the distribution.}
}
\value{
A dataframe containing three variables: \code{date}, \code{cases} and \code{reference}.
}
\description{
\@description \ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#questioning'><img src='figures/lifecycle-questioning.svg' alt='Questioning lifecycle'></a>}}{\strong{Questioning}}
Simulate cases from a single Rt trace, an initial number of cases, and a reporting model
This functionality has largely been superseded by \code{simulate_infections} and will likely to replaced
or updated to depend on \code{stan} code.
}
\seealso{
simulate_infections
}
