% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create_shifted_cases}
\alias{create_shifted_cases}
\title{Create Delay Shifted Cases}
\usage{
create_shifted_cases(reported_cases, shift, smoothing_window, horizon)
}
\arguments{
\item{reported_cases}{A data frame of confirmed cases (confirm) by date
(date). confirm must be integer and date must be in date format.}

\item{shift}{Numeric, mean delay shift to apply.}

\item{smoothing_window}{Numeric, the rolling average smoothing window
to apply. Must be odd in order to be defined as a centred average.}

\item{horizon}{Numeric, defaults to 7. Number of days into the future to
forecast.}
}
\value{
A data frame for shifted reported cases
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This functions creates a data frame of reported cases that has been smoothed
using a centred partial rolling average (with a period set by
\code{smoothing_window}) and shifted back in time by some delay. It is used by
\code{estimate_infections} to generate the mean shifted prior on which the back
calculation method (see \code{backcalc_opts()}) is based.
}
\examples{
create_shifted_cases(example_confirmed, 7, 14, 7)
}
\author{
Sam Abbott
}
