// Generated by rstantools.  Do not edit by hand.

/*
    EpiNow2 is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    EpiNow2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with EpiNow2.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_simulate_secondary_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'simulate_secondary', line 438, column 2 to column 48)",
                                                      " (in 'simulate_secondary', line 440, column 11 to column 12)",
                                                      " (in 'simulate_secondary', line 440, column 4 to column 24)",
                                                      " (in 'simulate_secondary', line 441, column 11 to column 35)",
                                                      " (in 'simulate_secondary', line 441, column 4 to line 446, column 6)",
                                                      " (in 'simulate_secondary', line 448, column 4 to line 453, column 8)",
                                                      " (in 'simulate_secondary', line 456, column 6 to column 96)",
                                                      " (in 'simulate_secondary', line 455, column 25 to line 457, column 5)",
                                                      " (in 'simulate_secondary', line 455, column 4 to line 457, column 5)",
                                                      " (in 'simulate_secondary', line 459, column 4 to line 461, column 6)",
                                                      " (in 'simulate_secondary', line 439, column 17 to line 462, column 3)",
                                                      " (in 'simulate_secondary', line 439, column 2 to line 462, column 3)",
                                                      " (in 'simulate_secondary', line 386, column 2 to column 8)",
                                                      " (in 'simulate_secondary', line 387, column 2 to column 8)",
                                                      " (in 'simulate_secondary', line 388, column 2 to column 8)",
                                                      " (in 'simulate_secondary', line 389, column 2 to column 16)",
                                                      " (in 'simulate_secondary', line 391, column 8 to column 13)",
                                                      " (in 'simulate_secondary', line 391, column 2 to column 34)",
                                                      " (in 'simulate_secondary', line 392, column 9 to column 10)",
                                                      " (in 'simulate_secondary', line 392, column 12 to column 13)",
                                                      " (in 'simulate_secondary', line 392, column 2 to column 23)",
                                                      " (in 'simulate_secondary', line 394, column 2 to column 19)",
                                                      " (in 'simulate_secondary', line 395, column 2 to column 17)",
                                                      " (in 'simulate_secondary', line 396, column 2 to column 15)",
                                                      " (in 'simulate_secondary', line 397, column 2 to column 28)",
                                                      " (in 'simulate_secondary', line 398, column 2 to column 14)",
                                                      " (in 'simulate_secondary', line 399, column 2 to column 31)",
                                                      " (in 'simulate_secondary', line 402, column 2 to column 25)",
                                                      " (in 'simulate_secondary', line 403, column 2 to column 27)",
                                                      " (in 'simulate_secondary', line 404, column 2 to column 28)",
                                                      " (in 'simulate_secondary', line 405, column 8 to column 9)",
                                                      " (in 'simulate_secondary', line 405, column 11 to column 20)",
                                                      " (in 'simulate_secondary', line 405, column 2 to column 38)",
                                                      " (in 'simulate_secondary', line 406, column 8 to column 9)",
                                                      " (in 'simulate_secondary', line 406, column 11 to column 20)",
                                                      " (in 'simulate_secondary', line 406, column 2 to column 47)",
                                                      " (in 'simulate_secondary', line 407, column 8 to column 17)",
                                                      " (in 'simulate_secondary', line 407, column 2 to column 44)",
                                                      " (in 'simulate_secondary', line 408, column 8 to column 17)",
                                                      " (in 'simulate_secondary', line 408, column 2 to column 45)",
                                                      " (in 'simulate_secondary', line 409, column 2 to column 34)",
                                                      " (in 'simulate_secondary', line 410, column 31 to column 47)",
                                                      " (in 'simulate_secondary', line 410, column 2 to column 62)",
                                                      " (in 'simulate_secondary', line 411, column 8 to column 22)",
                                                      " (in 'simulate_secondary', line 411, column 2 to column 59)",
                                                      " (in 'simulate_secondary', line 412, column 8 to column 17)",
                                                      " (in 'simulate_secondary', line 412, column 2 to column 36)",
                                                      " (in 'simulate_secondary', line 414, column 2 to column 29)",
                                                      " (in 'simulate_secondary', line 415, column 8 to column 15)",
                                                      " (in 'simulate_secondary', line 415, column 2 to column 46)",
                                                      " (in 'simulate_secondary', line 416, column 8 to column 15)",
                                                      " (in 'simulate_secondary', line 416, column 2 to column 47)",
                                                      " (in 'simulate_secondary', line 417, column 8 to column 23)",
                                                      " (in 'simulate_secondary', line 417, column 2 to column 59)",
                                                      " (in 'simulate_secondary', line 419, column 2 to column 26)",
                                                      " (in 'simulate_secondary', line 422, column 8 to column 24)",
                                                      " (in 'simulate_secondary', line 422, column 2 to column 42)",
                                                      " (in 'simulate_secondary', line 423, column 2 to column 18)",
                                                      " (in 'simulate_secondary', line 424, column 8 to column 9)",
                                                      " (in 'simulate_secondary', line 424, column 11 to column 22)",
                                                      " (in 'simulate_secondary', line 424, column 2 to column 60)",
                                                      " (in 'simulate_secondary', line 425, column 2 to column 16)",
                                                      " (in 'simulate_secondary', line 426, column 8 to column 9)",
                                                      " (in 'simulate_secondary', line 426, column 11 to column 20)",
                                                      " (in 'simulate_secondary', line 426, column 2 to column 58)",
                                                      " (in 'simulate_secondary', line 427, column 2 to column 17)",
                                                      " (in 'simulate_secondary', line 428, column 8 to column 9)",
                                                      " (in 'simulate_secondary', line 428, column 11 to column 21)",
                                                      " (in 'simulate_secondary', line 428, column 2 to column 47)",
                                                      " (in 'simulate_secondary', line 429, column 2 to column 26)",
                                                      " (in 'simulate_secondary', line 432, column 8 to column 19)",
                                                      " (in 'simulate_secondary', line 432, column 2 to line 435, column 4)",
                                                      " (in 'simulate_secondary', line 438, column 8 to column 9)",
                                                      " (in 'simulate_secondary', line 438, column 11 to column 28)",
                                                      " (in 'simulate_secondary', line 7, column 4 to column 31)",
                                                      " (in 'simulate_secondary', line 8, column 4 to column 31)",
                                                      " (in 'simulate_secondary', line 9, column 11 to column 14)",
                                                      " (in 'simulate_secondary', line 9, column 4 to column 18)",
                                                      " (in 'simulate_secondary', line 11, column 6 to column 75)",
                                                      " (in 'simulate_secondary', line 10, column 28 to line 12, column 5)",
                                                      " (in 'simulate_secondary', line 10, column 4 to line 12, column 5)",
                                                      " (in 'simulate_secondary', line 14, column 6 to line 17, column 8)",
                                                      " (in 'simulate_secondary', line 13, column 21 to line 18, column 5)",
                                                      " (in 'simulate_secondary', line 13, column 4 to line 18, column 5)",
                                                      " (in 'simulate_secondary', line 19, column 3 to column 13)",
                                                      " (in 'simulate_secondary', line 6, column 58 to line 20, column 3)",
                                                      " (in 'simulate_secondary', line 27, column 2 to column 35)",
                                                      " (in 'simulate_secondary', line 28, column 9 to column 25)",
                                                      " (in 'simulate_secondary', line 28, column 2 to column 35)",
                                                      " (in 'simulate_secondary', line 29, column 9 to column 10)",
                                                      " (in 'simulate_secondary', line 29, column 2 to column 39)",
                                                      " (in 'simulate_secondary', line 30, column 2 to column 43)",
                                                      " (in 'simulate_secondary', line 35, column 4 to column 47)",
                                                      " (in 'simulate_secondary', line 34, column 9 to line 36, column 3)",
                                                      " (in 'simulate_secondary', line 32, column 4 to column 75)",
                                                      " (in 'simulate_secondary', line 33, column 4 to column 50)",
                                                      " (in 'simulate_secondary', line 31, column 14 to line 34, column 3)",
                                                      " (in 'simulate_secondary', line 31, column 2 to line 36, column 3)",
                                                      " (in 'simulate_secondary', line 37, column 2 to column 18)",
                                                      " (in 'simulate_secondary', line 26, column 44 to line 38, column 1)",
                                                      " (in 'simulate_secondary', line 47, column 9 to column 10)",
                                                      " (in 'simulate_secondary', line 47, column 2 to column 17)",
                                                      " (in 'simulate_secondary', line 70, column 4 to column 46)",
                                                      " (in 'simulate_secondary', line 71, column 4 to column 16)",
                                                      " (in 'simulate_secondary', line 68, column 9 to line 72, column 3)",
                                                      " (in 'simulate_secondary', line 49, column 11 to column 12)",
                                                      " (in 'simulate_secondary', line 49, column 4 to column 25)",
                                                      " (in 'simulate_secondary', line 61, column 6 to column 56)",
                                                      " (in 'simulate_secondary', line 60, column 11 to line 62, column 5)",
                                                      " (in 'simulate_secondary', line 55, column 6 to column 34)",
                                                      " (in 'simulate_secondary', line 56, column 6 to column 31)",
                                                      " (in 'simulate_secondary', line 58, column 8 to column 52)",
                                                      " (in 'simulate_secondary', line 57, column 21 to line 59, column 7)",
                                                      " (in 'simulate_secondary', line 57, column 6 to line 59, column 7)",
                                                      " (in 'simulate_secondary', line 54, column 26 to line 60, column 5)",
                                                      " (in 'simulate_secondary', line 54, column 11 to line 62, column 5)",
                                                      " (in 'simulate_secondary', line 52, column 8 to column 54)",
                                                      " (in 'simulate_secondary', line 51, column 21 to line 53, column 7)",
                                                      " (in 'simulate_secondary', line 51, column 6 to line 53, column 7)",
                                                      " (in 'simulate_secondary', line 50, column 19 to line 54, column 5)",
                                                      " (in 'simulate_secondary', line 50, column 4 to line 62, column 5)",
                                                      " (in 'simulate_secondary', line 64, column 4 to column 28)",
                                                      " (in 'simulate_secondary', line 65, column 4 to column 67)",
                                                      " (in 'simulate_secondary', line 67, column 4 to column 32)",
                                                      " (in 'simulate_secondary', line 48, column 17 to line 68, column 3)",
                                                      " (in 'simulate_secondary', line 48, column 2 to line 72, column 3)",
                                                      " (in 'simulate_secondary', line 73, column 2 to column 20)",
                                                      " (in 'simulate_secondary', line 46, column 61 to line 74, column 1)",
                                                      " (in 'simulate_secondary', line 78, column 2 to column 34)",
                                                      " (in 'simulate_secondary', line 79, column 9 to column 16)",
                                                      " (in 'simulate_secondary', line 79, column 2 to column 26)",
                                                      " (in 'simulate_secondary', line 81, column 4 to column 38)",
                                                      " (in 'simulate_secondary', line 80, column 23 to line 82, column 3)",
                                                      " (in 'simulate_secondary', line 80, column 2 to line 82, column 3)",
                                                      " (in 'simulate_secondary', line 83, column 2 to column 17)",
                                                      " (in 'simulate_secondary', line 77, column 30 to line 84, column 1)",
                                                      " (in 'simulate_secondary', line 87, column 9 to column 12)",
                                                      " (in 'simulate_secondary', line 87, column 2 to column 18)",
                                                      " (in 'simulate_secondary', line 89, column 4 to column 28)",
                                                      " (in 'simulate_secondary', line 88, column 19 to line 90, column 3)",
                                                      " (in 'simulate_secondary', line 88, column 2 to line 90, column 3)",
                                                      " (in 'simulate_secondary', line 91, column 2 to column 14)",
                                                      " (in 'simulate_secondary', line 86, column 34 to line 92, column 1)",
                                                      " (in 'simulate_secondary', line 95, column 2 to column 34)",
                                                      " (in 'simulate_secondary', line 96, column 9 to column 12)",
                                                      " (in 'simulate_secondary', line 96, column 2 to column 47)",
                                                      " (in 'simulate_secondary', line 97, column 2 to column 44)",
                                                      " (in 'simulate_secondary', line 94, column 44 to line 98, column 1)",
                                                      " (in 'simulate_secondary', line 101, column 2 to column 34)",
                                                      " (in 'simulate_secondary', line 102, column 9 to column 12)",
                                                      " (in 'simulate_secondary', line 102, column 2 to column 47)",
                                                      " (in 'simulate_secondary', line 104, column 4 to column 44)",
                                                      " (in 'simulate_secondary', line 103, column 19 to line 105, column 3)",
                                                      " (in 'simulate_secondary', line 103, column 2 to line 105, column 3)",
                                                      " (in 'simulate_secondary', line 106, column 2 to column 59)",
                                                      " (in 'simulate_secondary', line 100, column 54 to line 107, column 1)",
                                                      " (in 'simulate_secondary', line 113, column 8 to column 19)",
                                                      " (in 'simulate_secondary', line 113, column 2 to column 29)",
                                                      " (in 'simulate_secondary', line 115, column 4 to column 15)",
                                                      " (in 'simulate_secondary', line 120, column 8 to line 121, column 53)",
                                                      " (in 'simulate_secondary', line 119, column 13 to line 122, column 7)",
                                                      " (in 'simulate_secondary', line 118, column 8 to column 51)",
                                                      " (in 'simulate_secondary', line 117, column 28 to line 119, column 7)",
                                                      " (in 'simulate_secondary', line 117, column 6 to line 122, column 7)",
                                                      " (in 'simulate_secondary', line 116, column 69 to line 123, column 5)",
                                                      " (in 'simulate_secondary', line 116, column 4 to line 123, column 5)",
                                                      " (in 'simulate_secondary', line 114, column 27 to line 124, column 3)",
                                                      " (in 'simulate_secondary', line 114, column 2 to line 124, column 3)",
                                                      " (in 'simulate_secondary', line 125, column 2 to column 13)",
                                                      " (in 'simulate_secondary', line 112, column 2 to line 126, column 1)",
                                                      " (in 'simulate_secondary', line 136, column 9 to column 12)",
                                                      " (in 'simulate_secondary', line 136, column 2 to column 39)",
                                                      " (in 'simulate_secondary', line 137, column 2 to column 22)",
                                                      " (in 'simulate_secondary', line 138, column 2 to column 14)",
                                                      " (in 'simulate_secondary', line 157, column 6 to column 57)",
                                                      " (in 'simulate_secondary', line 158, column 6 to column 63)",
                                                      " (in 'simulate_secondary', line 159, column 6 to column 42)",
                                                      " (in 'simulate_secondary', line 163, column 8 to line 165, column 10)",
                                                      " (in 'simulate_secondary', line 162, column 13 to line 166, column 7)",
                                                      " (in 'simulate_secondary', line 161, column 8 to column 49)",
                                                      " (in 'simulate_secondary', line 160, column 28 to line 162, column 7)",
                                                      " (in 'simulate_secondary', line 160, column 6 to line 166, column 7)",
                                                      " (in 'simulate_secondary', line 156, column 11 to line 167, column 5)",
                                                      " (in 'simulate_secondary', line 141, column 13 to column 41)",
                                                      " (in 'simulate_secondary', line 141, column 6 to line 147, column 8)",
                                                      " (in 'simulate_secondary', line 148, column 6 to column 63)",
                                                      " (in 'simulate_secondary', line 152, column 8 to line 154, column 10)",
                                                      " (in 'simulate_secondary', line 151, column 13 to line 155, column 7)",
                                                      " (in 'simulate_secondary', line 150, column 8 to column 42)",
                                                      " (in 'simulate_secondary', line 149, column 28 to line 151, column 7)",
                                                      " (in 'simulate_secondary', line 149, column 6 to line 155, column 7)",
                                                      " (in 'simulate_secondary', line 140, column 26 to line 156, column 5)",
                                                      " (in 'simulate_secondary', line 140, column 4 to line 167, column 5)",
                                                      " (in 'simulate_secondary', line 168, column 4 to column 26)",
                                                      " (in 'simulate_secondary', line 139, column 81 to line 169, column 3)",
                                                      " (in 'simulate_secondary', line 139, column 2 to line 169, column 3)",
                                                      " (in 'simulate_secondary', line 171, column 4 to line 174, column 6)",
                                                      " (in 'simulate_secondary', line 170, column 21 to line 175, column 3)",
                                                      " (in 'simulate_secondary', line 170, column 2 to line 175, column 3)",
                                                      " (in 'simulate_secondary', line 177, column 4 to column 30)",
                                                      " (in 'simulate_secondary', line 176, column 18 to line 178, column 3)",
                                                      " (in 'simulate_secondary', line 176, column 2 to line 178, column 3)",
                                                      " (in 'simulate_secondary', line 180, column 4 to column 26)",
                                                      " (in 'simulate_secondary', line 179, column 19 to line 181, column 3)",
                                                      " (in 'simulate_secondary', line 179, column 2 to line 181, column 3)",
                                                      " (in 'simulate_secondary', line 182, column 2 to column 13)",
                                                      " (in 'simulate_secondary', line 134, column 2 to line 183, column 1)",
                                                      " (in 'simulate_secondary', line 189, column 4 to column 47)",
                                                      " (in 'simulate_secondary', line 190, column 4 to column 43)",
                                                      " (in 'simulate_secondary', line 195, column 10 to column 98)",
                                                      " (in 'simulate_secondary', line 198, column 12 to column 90)",
                                                      " (in 'simulate_secondary', line 197, column 29 to line 199, column 11)",
                                                      " (in 'simulate_secondary', line 197, column 10 to line 199, column 11)",
                                                      " (in 'simulate_secondary', line 193, column 34 to line 200, column 9)",
                                                      " (in 'simulate_secondary', line 193, column 8 to line 200, column 9)",
                                                      " (in 'simulate_secondary', line 192, column 31 to line 201, column 7)",
                                                      " (in 'simulate_secondary', line 192, column 6 to line 201, column 7)",
                                                      " (in 'simulate_secondary', line 191, column 21 to line 202, column 5)",
                                                      " (in 'simulate_secondary', line 191, column 4 to line 202, column 5)",
                                                      " (in 'simulate_secondary', line 207, column 10 to column 92)",
                                                      " (in 'simulate_secondary', line 208, column 10 to column 84)",
                                                      " (in 'simulate_secondary', line 205, column 32 to line 209, column 9)",
                                                      " (in 'simulate_secondary', line 205, column 8 to line 209, column 9)",
                                                      " (in 'simulate_secondary', line 204, column 29 to line 210, column 6)",
                                                      " (in 'simulate_secondary', line 204, column 6 to line 210, column 6)",
                                                      " (in 'simulate_secondary', line 203, column 19 to line 211, column 3)",
                                                      " (in 'simulate_secondary', line 203, column 4 to line 211, column 3)",
                                                      " (in 'simulate_secondary', line 188, column 59 to line 212, column 1)",
                                                      " (in 'simulate_secondary', line 216, column 2 to column 32)",
                                                      " (in 'simulate_secondary', line 217, column 2 to column 32)",
                                                      " (in 'simulate_secondary', line 219, column 9 to column 11)",
                                                      " (in 'simulate_secondary', line 219, column 2 to column 41)",
                                                      " (in 'simulate_secondary', line 220, column 9 to column 10)",
                                                      " (in 'simulate_secondary', line 220, column 2 to column 27)",
                                                      " (in 'simulate_secondary', line 223, column 4 to column 67)",
                                                      " (in 'simulate_secondary', line 221, column 17 to line 224, column 4)",
                                                      " (in 'simulate_secondary', line 221, column 2 to line 224, column 4)",
                                                      " (in 'simulate_secondary', line 225, column 2 to column 25)",
                                                      " (in 'simulate_secondary', line 215, column 82 to line 226, column 1)",
                                                      " (in 'simulate_secondary', line 230, column 2 to column 32)",
                                                      " (in 'simulate_secondary', line 231, column 9 to column 10)",
                                                      " (in 'simulate_secondary', line 231, column 2 to column 27)",
                                                      " (in 'simulate_secondary', line 232, column 2 to column 38)",
                                                      " (in 'simulate_secondary', line 233, column 2 to column 25)",
                                                      " (in 'simulate_secondary', line 229, column 48 to line 234, column 1)",
                                                      " (in 'simulate_secondary', line 237, column 2 to column 32)",
                                                      " (in 'simulate_secondary', line 238, column 9 to column 10)",
                                                      " (in 'simulate_secondary', line 238, column 2 to column 36)",
                                                      " (in 'simulate_secondary', line 240, column 2 to column 54)",
                                                      " (in 'simulate_secondary', line 241, column 2 to column 34)",
                                                      " (in 'simulate_secondary', line 246, column 4 to column 60)",
                                                      " (in 'simulate_secondary', line 245, column 9 to line 247, column 3)",
                                                      " (in 'simulate_secondary', line 244, column 4 to column 60)",
                                                      " (in 'simulate_secondary', line 243, column 19 to line 245, column 3)",
                                                      " (in 'simulate_secondary', line 243, column 2 to line 247, column 3)",
                                                      " (in 'simulate_secondary', line 248, column 2 to column 24)",
                                                      " (in 'simulate_secondary', line 236, column 71 to line 249, column 1)",
                                                      " (in 'simulate_secondary', line 254, column 2 to column 49)",
                                                      " (in 'simulate_secondary', line 258, column 6 to column 63)",
                                                      " (in 'simulate_secondary', line 256, column 30 to line 259, column 5)",
                                                      " (in 'simulate_secondary', line 256, column 4 to line 259, column 5)",
                                                      " (in 'simulate_secondary', line 262, column 6 to column 57)",
                                                      " (in 'simulate_secondary', line 260, column 28 to line 263, column 5)",
                                                      " (in 'simulate_secondary', line 260, column 4 to line 263, column 5)",
                                                      " (in 'simulate_secondary', line 255, column 18 to line 264, column 3)",
                                                      " (in 'simulate_secondary', line 255, column 2 to line 264, column 3)",
                                                      " (in 'simulate_secondary', line 253, column 73 to line 265, column 1)",
                                                      " (in 'simulate_secondary', line 283, column 6 to column 55)",
                                                      " (in 'simulate_secondary', line 282, column 11 to line 284, column 5)",
                                                      " (in 'simulate_secondary', line 281, column 6 to column 31)",
                                                      " (in 'simulate_secondary', line 280, column 21 to line 282, column 5)",
                                                      " (in 'simulate_secondary', line 280, column 4 to line 284, column 5)",
                                                      " (in 'simulate_secondary', line 279, column 9 to line 285, column 3)",
                                                      " (in 'simulate_secondary', line 271, column 4 to column 18)",
                                                      " (in 'simulate_secondary', line 272, column 53 to column 54)",
                                                      " (in 'simulate_secondary', line 272, column 4 to column 57)",
                                                      " (in 'simulate_secondary', line 273, column 4 to column 45)",
                                                      " (in 'simulate_secondary', line 277, column 6 to column 72)",
                                                      " (in 'simulate_secondary', line 276, column 11 to line 278, column 5)",
                                                      " (in 'simulate_secondary', line 275, column 6 to column 48)",
                                                      " (in 'simulate_secondary', line 274, column 21 to line 276, column 5)",
                                                      " (in 'simulate_secondary', line 274, column 4 to line 278, column 5)",
                                                      " (in 'simulate_secondary', line 270, column 18 to line 279, column 3)",
                                                      " (in 'simulate_secondary', line 270, column 2 to line 285, column 3)",
                                                      " (in 'simulate_secondary', line 269, column 44 to line 286, column 1)",
                                                      " (in 'simulate_secondary', line 290, column 2 to column 32)",
                                                      " (in 'simulate_secondary', line 291, column 9 to column 10)",
                                                      " (in 'simulate_secondary', line 291, column 2 to column 20)",
                                                      " (in 'simulate_secondary', line 299, column 4 to column 50)",
                                                      " (in 'simulate_secondary', line 301, column 6 to column 81)",
                                                      " (in 'simulate_secondary', line 300, column 19 to line 302, column 5)",
                                                      " (in 'simulate_secondary', line 300, column 4 to line 302, column 5)",
                                                      " (in 'simulate_secondary', line 298, column 9 to line 303, column 3)",
                                                      " (in 'simulate_secondary', line 296, column 6 to column 64)",
                                                      " (in 'simulate_secondary', line 295, column 19 to line 297, column 5)",
                                                      " (in 'simulate_secondary', line 295, column 4 to line 297, column 5)",
                                                      " (in 'simulate_secondary', line 294, column 23 to line 298, column 3)",
                                                      " (in 'simulate_secondary', line 294, column 2 to line 303, column 3)",
                                                      " (in 'simulate_secondary', line 304, column 2 to column 18)",
                                                      " (in 'simulate_secondary', line 289, column 73 to line 305, column 1)",
                                                      " (in 'simulate_secondary', line 308, column 2 to column 32)",
                                                      " (in 'simulate_secondary', line 309, column 8 to column 9)",
                                                      " (in 'simulate_secondary', line 309, column 2 to column 31)",
                                                      " (in 'simulate_secondary', line 310, column 2 to column 22)",
                                                      " (in 'simulate_secondary', line 312, column 4 to column 45)",
                                                      " (in 'simulate_secondary', line 311, column 18 to line 313, column 3)",
                                                      " (in 'simulate_secondary', line 311, column 2 to line 313, column 3)",
                                                      " (in 'simulate_secondary', line 323, column 8 to column 95)",
                                                      " (in 'simulate_secondary', line 322, column 13 to line 324, column 7)",
                                                      " (in 'simulate_secondary', line 321, column 8 to column 78)",
                                                      " (in 'simulate_secondary', line 320, column 26 to line 322, column 7)",
                                                      " (in 'simulate_secondary', line 320, column 6 to line 324, column 7)",
                                                      " (in 'simulate_secondary', line 318, column 11 to line 325, column 5)",
                                                      " (in 'simulate_secondary', line 317, column 6 to column 29)",
                                                      " (in 'simulate_secondary', line 316, column 27 to line 318, column 5)",
                                                      " (in 'simulate_secondary', line 316, column 4 to line 325, column 5)",
                                                      " (in 'simulate_secondary', line 315, column 17 to line 326, column 3)",
                                                      " (in 'simulate_secondary', line 315, column 2 to line 326, column 3)",
                                                      " (in 'simulate_secondary', line 327, column 2 to column 26)",
                                                      " (in 'simulate_secondary', line 307, column 77 to line 328, column 1)",
                                                      " (in 'simulate_secondary', line 335, column 2 to column 32)",
                                                      " (in 'simulate_secondary', line 336, column 2 to column 41)",
                                                      " (in 'simulate_secondary', line 337, column 9 to column 10)",
                                                      " (in 'simulate_secondary', line 337, column 2 to column 27)",
                                                      " (in 'simulate_secondary', line 338, column 9 to column 10)",
                                                      " (in 'simulate_secondary', line 338, column 2 to column 47)",
                                                      " (in 'simulate_secondary', line 339, column 9 to column 10)",
                                                      " (in 'simulate_secondary', line 339, column 2 to column 51)",
                                                      " (in 'simulate_secondary', line 344, column 4 to column 29)",
                                                      " (in 'simulate_secondary', line 343, column 7 to line 345, column 3)",
                                                      " (in 'simulate_secondary', line 342, column 4 to column 53)",
                                                      " (in 'simulate_secondary', line 341, column 17 to line 343, column 3)",
                                                      " (in 'simulate_secondary', line 341, column 2 to line 345, column 3)",
                                                      " (in 'simulate_secondary', line 347, column 2 to line 348, column 57)",
                                                      " (in 'simulate_secondary', line 357, column 8 to column 42)",
                                                      " (in 'simulate_secondary', line 356, column 11 to line 358, column 7)",
                                                      " (in 'simulate_secondary', line 355, column 8 to column 56)",
                                                      " (in 'simulate_secondary', line 354, column 23 to line 356, column 7)",
                                                      " (in 'simulate_secondary', line 354, column 6 to line 358, column 7)",
                                                      " (in 'simulate_secondary', line 353, column 29 to line 359, column 5)",
                                                      " (in 'simulate_secondary', line 353, column 4 to line 359, column 5)",
                                                      " (in 'simulate_secondary', line 366, column 10 to column 49)",
                                                      " (in 'simulate_secondary', line 365, column 52 to line 367, column 9)",
                                                      " (in 'simulate_secondary', line 365, column 8 to line 367, column 9)",
                                                      " (in 'simulate_secondary', line 368, column 8 to column 48)",
                                                      " (in 'simulate_secondary', line 364, column 11 to line 369, column 7)",
                                                      " (in 'simulate_secondary', line 363, column 8 to column 48)",
                                                      " (in 'simulate_secondary', line 362, column 33 to line 364, column 7)",
                                                      " (in 'simulate_secondary', line 362, column 6 to line 369, column 7)",
                                                      " (in 'simulate_secondary', line 361, column 18 to line 370, column 5)",
                                                      " (in 'simulate_secondary', line 361, column 4 to line 370, column 5)",
                                                      " (in 'simulate_secondary', line 376, column 8 to column 50)",
                                                      " (in 'simulate_secondary', line 375, column 11 to line 377, column 7)",
                                                      " (in 'simulate_secondary', line 374, column 8 to column 50)",
                                                      " (in 'simulate_secondary', line 373, column 36 to line 375, column 7)",
                                                      " (in 'simulate_secondary', line 373, column 6 to line 377, column 7)",
                                                      " (in 'simulate_secondary', line 372, column 17 to line 378, column 5)",
                                                      " (in 'simulate_secondary', line 372, column 4 to line 378, column 5)",
                                                      " (in 'simulate_secondary', line 379, column 4 to column 55)",
                                                      " (in 'simulate_secondary', line 351, column 17 to line 380, column 3)",
                                                      " (in 'simulate_secondary', line 351, column 2 to line 380, column 3)",
                                                      " (in 'simulate_secondary', line 381, column 2 to column 28)",
                                                      " (in 'simulate_secondary', line 334, column 70 to line 382, column 1)"};
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T1__>>, -1, 1>
convolve_with_rev_pmf(const T0__& x_arg__, const T1__& y_arg__,
                      const int& len, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T1__>>;
  const auto& x = to_ref(x_arg__);
  const auto& y = to_ref(y_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int xlen;
    xlen = std::numeric_limits<int>::min();
    
    current_statement__ = 75;
    xlen = num_elements(x);
    int ylen;
    ylen = std::numeric_limits<int>::min();
    
    current_statement__ = 76;
    ylen = num_elements(y);
    current_statement__ = 77;
    validate_non_negative_index("z", "len", len);
    Eigen::Matrix<local_scalar_t__, -1, 1> z;
    z = Eigen::Matrix<local_scalar_t__, -1, 1>(len);
    stan::math::fill(z, DUMMY_VAR__);
    
    current_statement__ = 81;
    if (logical_lte((xlen + ylen), len)) {
      current_statement__ = 79;
      std::stringstream errmsg_stream__;
      errmsg_stream__ << "convolve_with_rev_pmf: len is longer then x and y combined";
      throw std::domain_error(errmsg_stream__.str());
    } 
    current_statement__ = 84;
    for (int s = 1; s <= len; ++s) {
      current_statement__ = 82;
      assign(z, cons_list(index_uni(s), nil_index_list()),
        dot_product(
          rvalue(x,
            cons_list(
              index_min_max(std::max(1, ((s - ylen) + 1)), std::min(s, xlen)),
              nil_index_list()), "x"),
          rvalue(y,
            cons_list(
              index_min_max(std::max(1, ((ylen - s) + 1)), std::min(ylen,
                                                             ((ylen + xlen) -
                                                               s))),
              nil_index_list()), "y")), "assigning variable z");}
    current_statement__ = 85;
    return z;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct convolve_with_rev_pmf_functor__ {
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T1__>>, -1, 1>
operator()(const T0__& x, const T1__& y, const int& len,
           std::ostream* pstream__)  const 
{
return convolve_with_rev_pmf(x, y, len, pstream__);
}
};
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T1__>>, -1, 1>
convolve_to_report(const T0__& infections_arg__,
                   const T1__& delay_rev_pmf_arg__, const int& seeding_time,
                   std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T1__>>;
  const auto& infections = to_ref(infections_arg__);
  const auto& delay_rev_pmf = to_ref(delay_rev_pmf_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int t;
    t = std::numeric_limits<int>::min();
    
    current_statement__ = 87;
    t = num_elements(infections);
    current_statement__ = 88;
    validate_non_negative_index("reports", "t - seeding_time",
                                (t - seeding_time));
    Eigen::Matrix<local_scalar_t__, -1, 1> reports;
    reports = Eigen::Matrix<local_scalar_t__, -1, 1>((t - seeding_time));
    stan::math::fill(reports, DUMMY_VAR__);
    
    current_statement__ = 90;
    validate_non_negative_index("unobs_reports", "t", t);
    Eigen::Matrix<local_scalar_t__, -1, 1> unobs_reports;
    unobs_reports = Eigen::Matrix<local_scalar_t__, -1, 1>(t);
    stan::math::fill(unobs_reports, DUMMY_VAR__);
    
    current_statement__ = 91;
    assign(unobs_reports, nil_index_list(), infections,
      "assigning variable unobs_reports");
    int delays;
    delays = std::numeric_limits<int>::min();
    
    current_statement__ = 92;
    delays = num_elements(delay_rev_pmf);
    current_statement__ = 98;
    if (delays) {
      current_statement__ = 95;
      assign(unobs_reports, nil_index_list(),
        convolve_with_rev_pmf(stan::model::deep_copy(unobs_reports),
          delay_rev_pmf, t, pstream__), "assigning variable unobs_reports");
      current_statement__ = 96;
      assign(reports, nil_index_list(),
        rvalue(unobs_reports,
          cons_list(index_min_max((seeding_time + 1), t), nil_index_list()),
          "unobs_reports"), "assigning variable reports");
    } else {
      current_statement__ = 93;
      assign(reports, nil_index_list(),
        rvalue(infections,
          cons_list(index_min_max((seeding_time + 1), t), nil_index_list()),
          "infections"), "assigning variable reports");
    }
    current_statement__ = 99;
    return reports;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct convolve_to_report_functor__ {
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T1__>>, -1, 1>
operator()(const T0__& infections, const T1__& delay_rev_pmf,
           const int& seeding_time, std::ostream* pstream__)  const 
{
return convolve_to_report(infections, delay_rev_pmf, seeding_time, pstream__);
}
};
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<T0__,
T1__>, -1, 1>
discretised_pmf(const T0__& mu, const T1__& sigma, const int& n,
                const int& dist, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 101;
    validate_non_negative_index("lpmf", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, 1> lpmf;
    lpmf = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
    stan::math::fill(lpmf, DUMMY_VAR__);
    
    current_statement__ = 126;
    if (logical_gt(sigma, 0)) {
      current_statement__ = 106;
      validate_non_negative_index("upper_lcdf", "n", n);
      Eigen::Matrix<local_scalar_t__, -1, 1> upper_lcdf;
      upper_lcdf = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
      stan::math::fill(upper_lcdf, DUMMY_VAR__);
      
      current_statement__ = 121;
      if (logical_eq(dist, 0)) {
        current_statement__ = 119;
        for (int i = 1; i <= n; ++i) {
          current_statement__ = 117;
          assign(upper_lcdf, cons_list(index_uni(i), nil_index_list()),
            lognormal_lcdf(i, mu, sigma), "assigning variable upper_lcdf");}
      } else {
        current_statement__ = 116;
        if (logical_eq(dist, 1)) {
          local_scalar_t__ alpha;
          alpha = DUMMY_VAR__;
          
          current_statement__ = 110;
          alpha = (pow(mu, 2) / pow(sigma, 2));
          local_scalar_t__ beta;
          beta = DUMMY_VAR__;
          
          current_statement__ = 111;
          beta = (mu / pow(sigma, 2));
          current_statement__ = 114;
          for (int i = 1; i <= n; ++i) {
            current_statement__ = 112;
            assign(upper_lcdf, cons_list(index_uni(i), nil_index_list()),
              gamma_lcdf(i, alpha, beta), "assigning variable upper_lcdf");}
        } else {
          current_statement__ = 108;
          std::stringstream errmsg_stream__;
          errmsg_stream__ << "Unknown distribution function provided.";
          throw std::domain_error(errmsg_stream__.str());
        }
      }
      current_statement__ = 122;
      assign(lpmf, cons_list(index_uni(1), nil_index_list()),
        upper_lcdf[(1 - 1)], "assigning variable lpmf");
      current_statement__ = 123;
      assign(lpmf, cons_list(index_min_max(2, n), nil_index_list()),
        log_diff_exp(
          rvalue(upper_lcdf,
            cons_list(index_min_max(2, n), nil_index_list()), "upper_lcdf"),
          rvalue(upper_lcdf,
            cons_list(index_min_max(1, (n - 1)), nil_index_list()),
            "upper_lcdf")), "assigning variable lpmf");
      current_statement__ = 124;
      assign(lpmf, nil_index_list(),
        subtract(stan::model::deep_copy(lpmf), upper_lcdf[(n - 1)]),
        "assigning variable lpmf");
    } else {
      current_statement__ = 103;
      assign(lpmf, nil_index_list(),
        rep_vector(stan::math::negative_infinity(), n),
        "assigning variable lpmf");
      current_statement__ = 104;
      assign(lpmf, cons_list(index_uni(n), nil_index_list()), 0,
        "assigning variable lpmf");
    }
    current_statement__ = 127;
    return stan::math::exp(lpmf);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct discretised_pmf_functor__ {
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<T0__,
T1__>, -1, 1>
operator()(const T0__& mu, const T1__& sigma, const int& n, const int& dist,
           std::ostream* pstream__)  const 
{
return discretised_pmf(mu, sigma, n, dist, pstream__);
}
};
template <typename T0__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>>, -1, 1>
reverse_mf(const T0__& pmf_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>>;
  const auto& pmf = to_ref(pmf_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int max_pmf;
    max_pmf = std::numeric_limits<int>::min();
    
    current_statement__ = 129;
    max_pmf = num_elements(pmf);
    current_statement__ = 130;
    validate_non_negative_index("rev_pmf", "max_pmf", max_pmf);
    Eigen::Matrix<local_scalar_t__, -1, 1> rev_pmf;
    rev_pmf = Eigen::Matrix<local_scalar_t__, -1, 1>(max_pmf);
    stan::math::fill(rev_pmf, DUMMY_VAR__);
    
    current_statement__ = 134;
    for (int d = 1; d <= max_pmf; ++d) {
      current_statement__ = 132;
      assign(rev_pmf, cons_list(index_uni(d), nil_index_list()),
        pmf[(((max_pmf - d) + 1) - 1)], "assigning variable rev_pmf");}
    current_statement__ = 135;
    return rev_pmf;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct reverse_mf_functor__ {
template <typename T0__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>>, -1, 1>
operator()(const T0__& pmf, std::ostream* pstream__)  const 
{
return reverse_mf(pmf, pstream__);
}
};
Eigen::Matrix<double, -1, 1>
rev_seq(const int& base, const int& len, std::ostream* pstream__) {
  using local_scalar_t__ = double;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 137;
    validate_non_negative_index("seq", "len", len);
    Eigen::Matrix<local_scalar_t__, -1, 1> seq;
    seq = Eigen::Matrix<local_scalar_t__, -1, 1>(len);
    stan::math::fill(seq, DUMMY_VAR__);
    
    current_statement__ = 141;
    for (int i = 1; i <= len; ++i) {
      current_statement__ = 139;
      assign(seq, cons_list(index_uni(i), nil_index_list()),
        ((len + base) - i), "assigning variable seq");}
    current_statement__ = 142;
    return seq;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct rev_seq_functor__ {
Eigen::Matrix<double, -1, 1>
operator()(const int& base, const int& len, std::ostream* pstream__)  const 
{
return rev_seq(base, len, pstream__);
}
};
template <typename T0__>
stan::promote_args_t<stan::value_type_t<T0__>>
rev_pmf_mean(const T0__& rev_pmf_arg__, const int& base,
             std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>>;
  const auto& rev_pmf = to_ref(rev_pmf_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int len;
    len = std::numeric_limits<int>::min();
    
    current_statement__ = 144;
    len = num_elements(rev_pmf);
    current_statement__ = 145;
    validate_non_negative_index("rev_pmf_seq", "len", len);
    Eigen::Matrix<local_scalar_t__, -1, 1> rev_pmf_seq;
    rev_pmf_seq = Eigen::Matrix<local_scalar_t__, -1, 1>(len);
    stan::math::fill(rev_pmf_seq, DUMMY_VAR__);
    
    current_statement__ = 146;
    assign(rev_pmf_seq, nil_index_list(), rev_seq(base, len, pstream__),
      "assigning variable rev_pmf_seq");
    current_statement__ = 147;
    return dot_product(rev_pmf_seq, rev_pmf);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct rev_pmf_mean_functor__ {
template <typename T0__>
stan::promote_args_t<stan::value_type_t<T0__>>
operator()(const T0__& rev_pmf, const int& base, std::ostream* pstream__)  const 
{
return rev_pmf_mean(rev_pmf, base, pstream__);
}
};
template <typename T0__, typename T2__>
stan::promote_args_t<stan::value_type_t<T0__>,
T2__>
rev_pmf_var(const T0__& rev_pmf_arg__, const int& base, const T2__& mean,
            std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          T2__>;
  const auto& rev_pmf = to_ref(rev_pmf_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int len;
    len = std::numeric_limits<int>::min();
    
    current_statement__ = 149;
    len = num_elements(rev_pmf);
    current_statement__ = 150;
    validate_non_negative_index("rev_pmf_seq", "len", len);
    Eigen::Matrix<local_scalar_t__, -1, 1> rev_pmf_seq;
    rev_pmf_seq = Eigen::Matrix<local_scalar_t__, -1, 1>(len);
    stan::math::fill(rev_pmf_seq, DUMMY_VAR__);
    
    current_statement__ = 151;
    assign(rev_pmf_seq, nil_index_list(), rev_seq(base, len, pstream__),
      "assigning variable rev_pmf_seq");
    current_statement__ = 154;
    for (int i = 1; i <= len; ++i) {
      current_statement__ = 152;
      assign(rev_pmf_seq, cons_list(index_uni(i), nil_index_list()),
        pow(rev_pmf_seq[(i - 1)], 2), "assigning variable rev_pmf_seq");}
    current_statement__ = 155;
    return (dot_product(rev_pmf_seq, rev_pmf) - pow(mean, 2));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct rev_pmf_var_functor__ {
template <typename T0__, typename T2__>
stan::promote_args_t<stan::value_type_t<T0__>,
T2__>
operator()(const T0__& rev_pmf, const int& base, const T2__& mean,
           std::ostream* pstream__)  const 
{
return rev_pmf_var(rev_pmf, base, mean, pstream__);
}
};
std::vector<int>
get_delay_type_max(const int& delay_types,
                   const std::vector<int>& delay_types_p,
                   const std::vector<int>& delay_types_id,
                   const std::vector<int>& delay_types_groups,
                   const std::vector<int>& delay_max,
                   const std::vector<int>& delay_np_pmf_groups,
                   std::ostream* pstream__) {
  using local_scalar_t__ = double;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 157;
    validate_non_negative_index("ret", "delay_types", delay_types);
    std::vector<int> ret;
    ret = std::vector<int>(delay_types, std::numeric_limits<int>::min());
    
    current_statement__ = 168;
    for (int i = 1; i <= delay_types; ++i) {
      current_statement__ = 159;
      assign(ret, cons_list(index_uni(i), nil_index_list()), 1,
        "assigning variable ret");
      current_statement__ = 166;
      for (int j = delay_types_groups[(i - 1)];
           j <= (delay_types_groups[((i + 1) - 1)] - 1); ++j) {
        current_statement__ = 164;
        if (delay_types_p[(j - 1)]) {
          current_statement__ = 162;
          assign(ret, cons_list(index_uni(i), nil_index_list()),
            (ret[(i - 1)] + (delay_max[(delay_types_id[(j - 1)] - 1)] - 1)),
            "assigning variable ret");
        } else {
          current_statement__ = 160;
          assign(ret, cons_list(index_uni(i), nil_index_list()),
            (ret[(i - 1)] +
              ((delay_np_pmf_groups[((delay_types_id[(j - 1)] + 1) - 1)] -
                 delay_np_pmf_groups[(delay_types_id[(j - 1)] - 1)]) - 1)),
            "assigning variable ret");
        }}}
    current_statement__ = 169;
    return ret;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct get_delay_type_max_functor__ {
std::vector<int>
operator()(const int& delay_types, const std::vector<int>& delay_types_p,
           const std::vector<int>& delay_types_id,
           const std::vector<int>& delay_types_groups,
           const std::vector<int>& delay_max,
           const std::vector<int>& delay_np_pmf_groups,
           std::ostream* pstream__)  const 
{
return get_delay_type_max(delay_types, delay_types_p, delay_types_id,
         delay_types_groups, delay_max, delay_np_pmf_groups, pstream__);
}
};
template <typename T6__, typename T8__, typename T9__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T6__>, T8__,
T9__>, -1, 1>
get_delay_rev_pmf(const int& delay_id, const int& len,
                  const std::vector<int>& delay_types_p,
                  const std::vector<int>& delay_types_id,
                  const std::vector<int>& delay_types_groups,
                  const std::vector<int>& delay_max,
                  const T6__& delay_np_pmf_arg__,
                  const std::vector<int>& delay_np_pmf_groups,
                  const std::vector<T8__>& delay_mean,
                  const std::vector<T9__>& delay_sigma,
                  const std::vector<int>& delay_dist,
                  const int& left_truncate, const int& reverse_pmf,
                  const int& cumulative, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T6__>,
          T8__,
          T9__>;
  const auto& delay_np_pmf = to_ref(delay_np_pmf_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 171;
    validate_non_negative_index("pmf", "len", len);
    Eigen::Matrix<local_scalar_t__, -1, 1> pmf;
    pmf = Eigen::Matrix<local_scalar_t__, -1, 1>(len);
    stan::math::fill(pmf, DUMMY_VAR__);
    
    current_statement__ = 172;
    assign(pmf, nil_index_list(), rep_vector(0, len),
      "assigning variable pmf");
    int current_len;
    current_len = std::numeric_limits<int>::min();
    
    current_statement__ = 173;
    current_len = 1;
    int new_len;
    new_len = std::numeric_limits<int>::min();
    
    current_statement__ = 196;
    for (int i = delay_types_groups[(delay_id - 1)];
         i <= (delay_types_groups[((delay_id + 1) - 1)] - 1); ++i) {
      current_statement__ = 193;
      if (delay_types_p[(i - 1)]) {
        current_statement__ = 184;
        validate_non_negative_index("new_variable_pmf",
                                    "delay_max[delay_types_id[i]]",
                                    delay_max[(delay_types_id[(i - 1)] - 1)]);
        Eigen::Matrix<local_scalar_t__, -1, 1> new_variable_pmf;
        new_variable_pmf = Eigen::Matrix<local_scalar_t__, -1, 1>(delay_max[
          (delay_types_id[(i - 1)] - 1)]);
        stan::math::fill(new_variable_pmf, DUMMY_VAR__);
        
        current_statement__ = 185;
        assign(new_variable_pmf, nil_index_list(),
          discretised_pmf(delay_mean[(delay_types_id[(i - 1)] - 1)],
            delay_sigma[(delay_types_id[(i - 1)] - 1)],
            delay_max[(delay_types_id[(i - 1)] - 1)],
            delay_dist[(delay_types_id[(i - 1)] - 1)], pstream__),
          "assigning variable new_variable_pmf");
        current_statement__ = 186;
        new_len = ((current_len + delay_max[(delay_types_id[(i - 1)] - 1)]) -
                    1);
        current_statement__ = 191;
        if (logical_eq(current_len, 1)) {
          current_statement__ = 189;
          assign(pmf, cons_list(index_min_max(1, new_len), nil_index_list()),
            new_variable_pmf, "assigning variable pmf");
        } else {
          current_statement__ = 187;
          assign(pmf, cons_list(index_min_max(1, new_len), nil_index_list()),
            convolve_with_rev_pmf(
              stan::model::deep_copy(
                rvalue(pmf,
                  cons_list(index_min_max(1, current_len), nil_index_list()),
                  "pmf")), reverse_mf(new_variable_pmf, pstream__),
              new_len, pstream__), "assigning variable pmf");
        }
      } else {
        int start;
        start = std::numeric_limits<int>::min();
        
        current_statement__ = 175;
        start = delay_np_pmf_groups[(delay_types_id[(i - 1)] - 1)];
        int end;
        end = std::numeric_limits<int>::min();
        
        current_statement__ = 176;
        end = (delay_np_pmf_groups[((delay_types_id[(i - 1)] + 1) - 1)] - 1);
        current_statement__ = 177;
        new_len = ((current_len + end) - start);
        current_statement__ = 182;
        if (logical_eq(current_len, 1)) {
          current_statement__ = 180;
          assign(pmf, cons_list(index_min_max(1, new_len), nil_index_list()),
            rvalue(delay_np_pmf,
              cons_list(index_min_max(start, end), nil_index_list()),
              "delay_np_pmf"), "assigning variable pmf");
        } else {
          current_statement__ = 178;
          assign(pmf, cons_list(index_min_max(1, new_len), nil_index_list()),
            convolve_with_rev_pmf(
              stan::model::deep_copy(
                rvalue(pmf,
                  cons_list(index_min_max(1, current_len), nil_index_list()),
                  "pmf")),
              reverse_mf(
                rvalue(delay_np_pmf,
                  cons_list(index_min_max(start, end), nil_index_list()),
                  "delay_np_pmf"), pstream__), new_len, pstream__),
            "assigning variable pmf");
        }
      }
      current_statement__ = 194;
      current_len = new_len;}
    current_statement__ = 199;
    if (left_truncate) {
      current_statement__ = 197;
      assign(pmf, nil_index_list(),
        append_row(rep_vector(0, left_truncate),
          divide(
            stan::model::deep_copy(
              rvalue(pmf,
                cons_list(index_min_max((left_truncate + 1), len),
                  nil_index_list()), "pmf")),
            sum(
              rvalue(pmf,
                cons_list(index_min_max((left_truncate + 1), len),
                  nil_index_list()), "pmf")))), "assigning variable pmf");
    } 
    current_statement__ = 202;
    if (cumulative) {
      current_statement__ = 200;
      assign(pmf, nil_index_list(),
        cumulative_sum(stan::model::deep_copy(pmf)), "assigning variable pmf");
    } 
    current_statement__ = 205;
    if (reverse_pmf) {
      current_statement__ = 203;
      assign(pmf, nil_index_list(),
        reverse_mf(stan::model::deep_copy(pmf), pstream__),
        "assigning variable pmf");
    } 
    current_statement__ = 206;
    return pmf;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct get_delay_rev_pmf_functor__ {
template <typename T6__, typename T8__, typename T9__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T6__>, T8__,
T9__>, -1, 1>
operator()(const int& delay_id, const int& len,
           const std::vector<int>& delay_types_p,
           const std::vector<int>& delay_types_id,
           const std::vector<int>& delay_types_groups,
           const std::vector<int>& delay_max, const T6__& delay_np_pmf,
           const std::vector<int>& delay_np_pmf_groups,
           const std::vector<T8__>& delay_mean,
           const std::vector<T9__>& delay_sigma,
           const std::vector<int>& delay_dist, const int& left_truncate,
           const int& reverse_pmf, const int& cumulative,
           std::ostream* pstream__)  const 
{
return get_delay_rev_pmf(delay_id, len, delay_types_p, delay_types_id,
         delay_types_groups, delay_max, delay_np_pmf, delay_np_pmf_groups,
         delay_mean, delay_sigma, delay_dist, left_truncate, reverse_pmf,
         cumulative, pstream__);
}
};
template <bool propto__, typename T0__, typename T1__, typename T2__,
typename T3__, typename T4__, typename T5__, typename T_lp__,
typename T_lp_accum__>
void
delays_lp(const std::vector<T0__>& delay_mean,
          const std::vector<T1__>& delay_mean_mean,
          const std::vector<T2__>& delay_mean_sd,
          const std::vector<T3__>& delay_sd,
          const std::vector<T4__>& delay_sd_mean,
          const std::vector<T5__>& delay_sd_sd,
          const std::vector<int>& delay_dist, const std::vector<int>& weight,
          T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__,
          T1__,
          T2__,
          T3__,
          T4__, stan::promote_args_t<T5__>>;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int mean_delays;
    mean_delays = std::numeric_limits<int>::min();
    
    current_statement__ = 208;
    mean_delays = num_elements(delay_mean);
    int sd_delays;
    sd_delays = std::numeric_limits<int>::min();
    
    current_statement__ = 209;
    sd_delays = num_elements(delay_sd);
    current_statement__ = 219;
    if (mean_delays) {
      current_statement__ = 217;
      for (int s = 1; s <= mean_delays; ++s) {
        current_statement__ = 215;
        if (logical_gt(delay_mean_sd[(s - 1)], 0)) {
          current_statement__ = 210;
          lp_accum__.add(
            (normal_lpdf<false>(delay_mean[(s - 1)],
               delay_mean_mean[(s - 1)], delay_mean_sd[(s - 1)]) *
              weight[(s - 1)]));
          current_statement__ = 213;
          if (delay_dist[(s - 1)]) {
            current_statement__ = 211;
            lp_accum__.add(
              (-normal_lccdf(0, delay_mean_mean[(s - 1)],
                  delay_mean_sd[(s - 1)]) * weight[(s - 1)]));
          } 
        } }
    } 
    current_statement__ = 227;
    if (sd_delays) {
      current_statement__ = 225;
      for (int s = 1; s <= sd_delays; ++s) {
        current_statement__ = 223;
        if (logical_gt(delay_sd_sd[(s - 1)], 0)) {
          current_statement__ = 220;
          lp_accum__.add(
            (normal_lpdf<false>(delay_sd[(s - 1)], delay_sd_mean[(s - 1)],
               delay_sd_sd[(s - 1)]) * weight[(s - 1)]));
          current_statement__ = 221;
          lp_accum__.add(
            (-normal_lccdf(0, delay_sd_mean[(s - 1)], delay_sd_sd[(s - 1)]) *
              weight[(s - 1)]));
        } }
    } 
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct delays_lp_functor__ {
template <bool propto__, typename T0__, typename T1__, typename T2__,
typename T3__, typename T4__, typename T5__, typename T_lp__,
typename T_lp_accum__>
void
operator()(const std::vector<T0__>& delay_mean,
           const std::vector<T1__>& delay_mean_mean,
           const std::vector<T2__>& delay_mean_sd,
           const std::vector<T3__>& delay_sd,
           const std::vector<T4__>& delay_sd_mean,
           const std::vector<T5__>& delay_sd_sd,
           const std::vector<int>& delay_dist,
           const std::vector<int>& weight, T_lp__& lp__,
           T_lp_accum__& lp_accum__, std::ostream* pstream__)  const 
{
return delays_lp<propto__>(delay_mean, delay_mean_mean, delay_mean_sd,
         delay_sd, delay_sd_mean, delay_sd_sd, delay_dist, weight, lp__,
         lp_accum__, pstream__);
}
};
template <typename T0__, typename T2__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T2__>>, -1, 1>
day_of_week_effect(const T0__& reports_arg__,
                   const std::vector<int>& day_of_week,
                   const T2__& effect_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T2__>>;
  const auto& reports = to_ref(reports_arg__);
  const auto& effect = to_ref(effect_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int t;
    t = std::numeric_limits<int>::min();
    
    current_statement__ = 229;
    t = num_elements(reports);
    int wl;
    wl = std::numeric_limits<int>::min();
    
    current_statement__ = 230;
    wl = num_elements(effect);
    current_statement__ = 231;
    validate_non_negative_index("scaled_effect", "wl", wl);
    Eigen::Matrix<local_scalar_t__, -1, 1> scaled_effect;
    scaled_effect = Eigen::Matrix<local_scalar_t__, -1, 1>(wl);
    stan::math::fill(scaled_effect, DUMMY_VAR__);
    
    current_statement__ = 232;
    assign(scaled_effect, nil_index_list(), multiply(wl, effect),
      "assigning variable scaled_effect");
    current_statement__ = 233;
    validate_non_negative_index("scaled_reports", "t", t);
    Eigen::Matrix<local_scalar_t__, -1, 1> scaled_reports;
    scaled_reports = Eigen::Matrix<local_scalar_t__, -1, 1>(t);
    stan::math::fill(scaled_reports, DUMMY_VAR__);
    
    current_statement__ = 237;
    for (int s = 1; s <= t; ++s) {
      current_statement__ = 235;
      assign(scaled_reports, cons_list(index_uni(s), nil_index_list()),
        (reports[(s - 1)] * scaled_effect[(day_of_week[(s - 1)] - 1)]),
        "assigning variable scaled_reports");}
    current_statement__ = 238;
    return scaled_reports;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct day_of_week_effect_functor__ {
template <typename T0__, typename T2__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T2__>>, -1, 1>
operator()(const T0__& reports, const std::vector<int>& day_of_week,
           const T2__& effect, std::ostream* pstream__)  const 
{
return day_of_week_effect(reports, day_of_week, effect, pstream__);
}
};
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
T1__>, -1, 1>
scale_obs(const T0__& reports_arg__, const T1__& frac_obs,
          std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          T1__>;
  const auto& reports = to_ref(reports_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int t;
    t = std::numeric_limits<int>::min();
    
    current_statement__ = 240;
    t = num_elements(reports);
    current_statement__ = 241;
    validate_non_negative_index("scaled_reports", "t", t);
    Eigen::Matrix<local_scalar_t__, -1, 1> scaled_reports;
    scaled_reports = Eigen::Matrix<local_scalar_t__, -1, 1>(t);
    stan::math::fill(scaled_reports, DUMMY_VAR__);
    
    current_statement__ = 243;
    assign(scaled_reports, nil_index_list(), multiply(reports, frac_obs),
      "assigning variable scaled_reports");
    current_statement__ = 244;
    return scaled_reports;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct scale_obs_functor__ {
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
T1__>, -1, 1>
operator()(const T0__& reports, const T1__& frac_obs, std::ostream* pstream__)  const 
{
return scale_obs(reports, frac_obs, pstream__);
}
};
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T1__>>, -1, 1>
truncate(const T0__& reports_arg__, const T1__& trunc_rev_cmf_arg__,
         const int& reconstruct, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T1__>>;
  const auto& reports = to_ref(reports_arg__);
  const auto& trunc_rev_cmf = to_ref(trunc_rev_cmf_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int t;
    t = std::numeric_limits<int>::min();
    
    current_statement__ = 246;
    t = num_elements(reports);
    current_statement__ = 247;
    validate_non_negative_index("trunc_reports", "t", t);
    Eigen::Matrix<local_scalar_t__, -1, 1> trunc_reports;
    trunc_reports = Eigen::Matrix<local_scalar_t__, -1, 1>(t);
    stan::math::fill(trunc_reports, DUMMY_VAR__);
    
    current_statement__ = 248;
    assign(trunc_reports, nil_index_list(), reports,
      "assigning variable trunc_reports");
    int trunc_max;
    trunc_max = std::numeric_limits<int>::min();
    
    current_statement__ = 249;
    trunc_max = std::min(t, num_elements(trunc_rev_cmf));
    int first_t;
    first_t = std::numeric_limits<int>::min();
    
    current_statement__ = 250;
    first_t = ((t - trunc_max) + 1);
    current_statement__ = 255;
    if (reconstruct) {
      current_statement__ = 253;
      assign(trunc_reports,
        cons_list(index_min_max(first_t, t), nil_index_list()),
        elt_divide(
          stan::model::deep_copy(
            rvalue(trunc_reports,
              cons_list(index_min_max(first_t, t), nil_index_list()),
              "trunc_reports")),
          rvalue(trunc_rev_cmf,
            cons_list(index_min_max(1, trunc_max), nil_index_list()),
            "trunc_rev_cmf")), "assigning variable trunc_reports");
    } else {
      current_statement__ = 251;
      assign(trunc_reports,
        cons_list(index_min_max(first_t, t), nil_index_list()),
        elt_multiply(
          stan::model::deep_copy(
            rvalue(trunc_reports,
              cons_list(index_min_max(first_t, t), nil_index_list()),
              "trunc_reports")),
          rvalue(trunc_rev_cmf,
            cons_list(index_min_max(1, trunc_max), nil_index_list()),
            "trunc_rev_cmf")), "assigning variable trunc_reports");
    }
    current_statement__ = 256;
    return trunc_reports;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct truncate_functor__ {
template <typename T0__, typename T1__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T1__>>, -1, 1>
operator()(const T0__& reports, const T1__& trunc_rev_cmf,
           const int& reconstruct, std::ostream* pstream__)  const 
{
return truncate(reports, trunc_rev_cmf, reconstruct, pstream__);
}
};
template <bool propto__, typename T0__, typename T1__, typename T2__,
typename T3__, typename T4__, typename T5__, typename T_lp__,
typename T_lp_accum__>
void
truncation_lp(const std::vector<T0__>& truncation_mean,
              const std::vector<T1__>& truncation_sd,
              const std::vector<T2__>& trunc_mean_mean,
              const std::vector<T3__>& trunc_mean_sd,
              const std::vector<T4__>& trunc_sd_mean,
              const std::vector<T5__>& trunc_sd_sd, T_lp__& lp__,
              T_lp_accum__& lp_accum__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__,
          T1__,
          T2__,
          T3__,
          T4__, stan::promote_args_t<T5__>>;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int truncation;
    truncation = std::numeric_limits<int>::min();
    
    current_statement__ = 258;
    truncation = num_elements(truncation_mean);
    current_statement__ = 266;
    if (truncation) {
      current_statement__ = 261;
      if (logical_gt(trunc_mean_sd[(1 - 1)], 0)) {
        current_statement__ = 259;
        lp_accum__.add(
          normal_lpdf<propto__>(truncation_mean, trunc_mean_mean,
            trunc_mean_sd));
      } 
      current_statement__ = 264;
      if (logical_gt(trunc_sd_sd[(1 - 1)], 0)) {
        current_statement__ = 262;
        lp_accum__.add(
          normal_lpdf<propto__>(truncation_sd, trunc_sd_mean, trunc_sd_sd));
      } 
    } 
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct truncation_lp_functor__ {
template <bool propto__, typename T0__, typename T1__, typename T2__,
typename T3__, typename T4__, typename T5__, typename T_lp__,
typename T_lp_accum__>
void
operator()(const std::vector<T0__>& truncation_mean,
           const std::vector<T1__>& truncation_sd,
           const std::vector<T2__>& trunc_mean_mean,
           const std::vector<T3__>& trunc_mean_sd,
           const std::vector<T4__>& trunc_sd_mean,
           const std::vector<T5__>& trunc_sd_sd, T_lp__& lp__,
           T_lp_accum__& lp_accum__, std::ostream* pstream__)  const 
{
return truncation_lp<propto__>(truncation_mean, truncation_sd,
         trunc_mean_mean, trunc_mean_sd, trunc_sd_mean, trunc_sd_sd, lp__,
         lp_accum__, pstream__);
}
};
template <bool propto__, typename T1__, typename T2__, typename T3__,
typename T4__, typename T6__, typename T_lp__, typename T_lp_accum__>
void
report_lp(const std::vector<int>& cases, const T1__& reports_arg__,
          const std::vector<T2__>& rep_phi, const T3__& phi_mean,
          const T4__& phi_sd, const int& model_type, const T6__& weight,
          T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T1__>,
          T2__,
          T3__,
          T4__,
          T6__>;
  const auto& reports = to_ref(reports_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 284;
    if (model_type) {
      local_scalar_t__ sqrt_phi;
      sqrt_phi = DUMMY_VAR__;
      
      current_statement__ = 275;
      if (logical_lt(rep_phi[(model_type - 1)], 0)) {
        current_statement__ = 275;
        lp_accum__.add(stan::math::negative_infinity());
      } else {
        current_statement__ = 275;
        lp_accum__.add(-normal_ccdf_log(0, phi_mean, phi_sd));
      }
      current_statement__ = 276;
      lp_accum__.add(
        normal_lpdf<propto__>(rep_phi[(model_type - 1)], phi_mean, phi_sd));
      current_statement__ = 277;
      sqrt_phi = (1 / stan::math::sqrt(rep_phi[(model_type - 1)]));
      current_statement__ = 282;
      if (logical_eq(weight, 1)) {
        current_statement__ = 280;
        lp_accum__.add(
          neg_binomial_2_lpmf<propto__>(cases, reports, sqrt_phi));
      } else {
        current_statement__ = 278;
        lp_accum__.add(
          (neg_binomial_2_lpmf<false>(cases, reports, sqrt_phi) * weight));
      }
    } else {
      current_statement__ = 272;
      if (logical_eq(weight, 1)) {
        current_statement__ = 270;
        lp_accum__.add(poisson_lpmf<propto__>(cases, reports));
      } else {
        current_statement__ = 268;
        lp_accum__.add((poisson_lpmf<false>(cases, reports) * weight));
      }
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct report_lp_functor__ {
template <bool propto__, typename T1__, typename T2__, typename T3__,
typename T4__, typename T6__, typename T_lp__, typename T_lp_accum__>
void
operator()(const std::vector<int>& cases, const T1__& reports,
           const std::vector<T2__>& rep_phi, const T3__& phi_mean,
           const T4__& phi_sd, const int& model_type, const T6__& weight,
           T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__)  const 
{
return report_lp<propto__>(cases, reports, rep_phi, phi_mean, phi_sd,
         model_type, weight, lp__, lp_accum__, pstream__);
}
};
template <typename T1__, typename T2__, typename T4__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T1__>, T2__,
T4__>, -1, 1>
report_log_lik(const std::vector<int>& cases, const T1__& reports_arg__,
               const std::vector<T2__>& rep_phi, const int& model_type,
               const T4__& weight, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T1__>,
          T2__,
          T4__>;
  const auto& reports = to_ref(reports_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int t;
    t = std::numeric_limits<int>::min();
    
    current_statement__ = 286;
    t = num_elements(reports);
    current_statement__ = 287;
    validate_non_negative_index("log_lik", "t", t);
    Eigen::Matrix<local_scalar_t__, -1, 1> log_lik;
    log_lik = Eigen::Matrix<local_scalar_t__, -1, 1>(t);
    stan::math::fill(log_lik, DUMMY_VAR__);
    
    current_statement__ = 298;
    if (logical_eq(model_type, 0)) {
      current_statement__ = 296;
      for (int i = 1; i <= t; ++i) {
        current_statement__ = 294;
        assign(log_lik, cons_list(index_uni(i), nil_index_list()),
          (poisson_lpmf<false>(cases[(i - 1)], reports[(i - 1)]) * weight),
          "assigning variable log_lik");}
    } else {
      local_scalar_t__ sqrt_phi;
      sqrt_phi = DUMMY_VAR__;
      
      current_statement__ = 289;
      sqrt_phi = (1 / stan::math::sqrt(rep_phi[(model_type - 1)]));
      current_statement__ = 292;
      for (int i = 1; i <= t; ++i) {
        current_statement__ = 290;
        assign(log_lik, cons_list(index_uni(i), nil_index_list()),
          (neg_binomial_2_lpmf<false>(cases[(i - 1)], reports[(i - 1)],
             sqrt_phi) * weight), "assigning variable log_lik");}
    }
    current_statement__ = 299;
    return log_lik;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct report_log_lik_functor__ {
template <typename T1__, typename T2__, typename T4__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T1__>, T2__,
T4__>, -1, 1>
operator()(const std::vector<int>& cases, const T1__& reports,
           const std::vector<T2__>& rep_phi, const int& model_type,
           const T4__& weight, std::ostream* pstream__)  const 
{
return report_log_lik(cases, reports, rep_phi, model_type, weight, pstream__);
}
};
template <typename T0__, typename T1__, typename RNG>
std::vector<int>
report_rng(const T0__& reports_arg__, const std::vector<T1__>& rep_phi,
           const int& model_type, RNG& base_rng__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          T1__>;
  const auto& reports = to_ref(reports_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int t;
    t = std::numeric_limits<int>::min();
    
    current_statement__ = 301;
    t = num_elements(reports);
    current_statement__ = 302;
    validate_non_negative_index("sampled_reports", "t", t);
    std::vector<int> sampled_reports;
    sampled_reports = std::vector<int>(t, std::numeric_limits<int>::min());
    
    local_scalar_t__ sqrt_phi;
    sqrt_phi = DUMMY_VAR__;
    
    current_statement__ = 304;
    sqrt_phi = 1e5;
    current_statement__ = 307;
    if (model_type) {
      current_statement__ = 305;
      sqrt_phi = (1 / stan::math::sqrt(rep_phi[(model_type - 1)]));
    } 
    current_statement__ = 318;
    for (int s = 1; s <= t; ++s) {
      current_statement__ = 316;
      if (logical_lt(reports[(s - 1)], 1e-8)) {
        current_statement__ = 314;
        assign(sampled_reports, cons_list(index_uni(s), nil_index_list()), 0,
          "assigning variable sampled_reports");
      } else {
        current_statement__ = 312;
        if (logical_gt(sqrt_phi, 1e4)) {
          current_statement__ = 310;
          assign(sampled_reports, cons_list(index_uni(s), nil_index_list()),
            poisson_rng(
              (logical_gt(reports[(s - 1)], 1e8) ?
                 stan::math::promote_scalar<local_scalar_t__>(1e8) :
                 stan::math::promote_scalar<local_scalar_t__>(reports[
                 (s - 1)])), base_rng__),
            "assigning variable sampled_reports");
        } else {
          current_statement__ = 308;
          assign(sampled_reports, cons_list(index_uni(s), nil_index_list()),
            neg_binomial_2_rng(
              (logical_gt(reports[(s - 1)], 1e8) ?
                 stan::math::promote_scalar<local_scalar_t__>(1e8) :
                 stan::math::promote_scalar<local_scalar_t__>(reports[
                 (s - 1)])), sqrt_phi, base_rng__),
            "assigning variable sampled_reports");
        }
      }}
    current_statement__ = 319;
    return sampled_reports;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct report_rng_functor__ {
template <typename T0__, typename T1__, typename RNG>
std::vector<int>
operator()(const T0__& reports, const std::vector<T1__>& rep_phi,
           const int& model_type, RNG& base_rng__, std::ostream* pstream__)  const 
{
return report_rng(reports, rep_phi, model_type, base_rng__, pstream__);
}
};
template <typename T0__, typename T2__, typename T3__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, T2__,
stan::value_type_t<T3__>>, -1, 1>
calculate_secondary(const T0__& reports_arg__, const std::vector<int>& obs,
                    const std::vector<T2__>& frac_obs,
                    const T3__& delay_rev_pmf_arg__, const int& cumulative,
                    const int& historic, const int& primary_hist_additive,
                    const int& current, const int& primary_current_additive,
                    const int& predict, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          T2__,
          stan::value_type_t<T3__>>;
  const auto& reports = to_ref(reports_arg__);
  const auto& delay_rev_pmf = to_ref(delay_rev_pmf_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int t;
    t = std::numeric_limits<int>::min();
    
    current_statement__ = 321;
    t = num_elements(reports);
    int obs_scale;
    obs_scale = std::numeric_limits<int>::min();
    
    current_statement__ = 322;
    obs_scale = num_elements(frac_obs);
    current_statement__ = 323;
    validate_non_negative_index("scaled_reports", "t", t);
    Eigen::Matrix<local_scalar_t__, -1, 1> scaled_reports;
    scaled_reports = Eigen::Matrix<local_scalar_t__, -1, 1>(t);
    stan::math::fill(scaled_reports, DUMMY_VAR__);
    
    current_statement__ = 325;
    validate_non_negative_index("conv_reports", "t", t);
    Eigen::Matrix<local_scalar_t__, -1, 1> conv_reports;
    conv_reports = Eigen::Matrix<local_scalar_t__, -1, 1>(t);
    stan::math::fill(conv_reports, DUMMY_VAR__);
    
    current_statement__ = 326;
    assign(conv_reports, nil_index_list(), rep_vector(1e-5, t),
      "assigning variable conv_reports");
    current_statement__ = 327;
    validate_non_negative_index("secondary_reports", "t", t);
    Eigen::Matrix<local_scalar_t__, -1, 1> secondary_reports;
    secondary_reports = Eigen::Matrix<local_scalar_t__, -1, 1>(t);
    stan::math::fill(secondary_reports, DUMMY_VAR__);
    
    current_statement__ = 328;
    assign(secondary_reports, nil_index_list(), rep_vector(0.0, t),
      "assigning variable secondary_reports");
    current_statement__ = 333;
    if (obs_scale) {
      current_statement__ = 331;
      assign(scaled_reports, nil_index_list(),
        scale_obs(reports, frac_obs[(1 - 1)], pstream__),
        "assigning variable scaled_reports");
    } else {
      current_statement__ = 329;
      assign(scaled_reports, nil_index_list(), reports,
        "assigning variable scaled_reports");
    }
    current_statement__ = 334;
    assign(conv_reports, nil_index_list(),
      add(stan::model::deep_copy(conv_reports),
        convolve_to_report(scaled_reports, delay_rev_pmf, 0, pstream__)),
      "assigning variable conv_reports");
    current_statement__ = 361;
    for (int i = 1; i <= t; ++i) {
      current_statement__ = 341;
      if ((primitive_value(cumulative) && primitive_value(logical_gt(i, 1)))) {
        current_statement__ = 339;
        if (logical_gt(i, predict)) {
          current_statement__ = 337;
          assign(secondary_reports,
            cons_list(index_uni(i), nil_index_list()),
            secondary_reports[((i - 1) - 1)],
            "assigning variable secondary_reports");
        } else {
          current_statement__ = 335;
          assign(secondary_reports,
            cons_list(index_uni(i), nil_index_list()), obs[((i - 1) - 1)],
            "assigning variable secondary_reports");
        }
      } 
      current_statement__ = 351;
      if (historic) {
        current_statement__ = 349;
        if (primary_hist_additive) {
          current_statement__ = 347;
          assign(secondary_reports,
            cons_list(index_uni(i), nil_index_list()),
            (secondary_reports[(i - 1)] + conv_reports[(i - 1)]),
            "assigning variable secondary_reports");
        } else {
          current_statement__ = 344;
          if (logical_gt(conv_reports[(i - 1)], secondary_reports[(i - 1)])) {
            current_statement__ = 342;
            assign(conv_reports, cons_list(index_uni(i), nil_index_list()),
              secondary_reports[(i - 1)], "assigning variable conv_reports");
          } 
          current_statement__ = 345;
          assign(secondary_reports,
            cons_list(index_uni(i), nil_index_list()),
            (secondary_reports[(i - 1)] - conv_reports[(i - 1)]),
            "assigning variable secondary_reports");
        }
      } 
      current_statement__ = 358;
      if (current) {
        current_statement__ = 356;
        if (primary_current_additive) {
          current_statement__ = 354;
          assign(secondary_reports,
            cons_list(index_uni(i), nil_index_list()),
            (secondary_reports[(i - 1)] + scaled_reports[(i - 1)]),
            "assigning variable secondary_reports");
        } else {
          current_statement__ = 352;
          assign(secondary_reports,
            cons_list(index_uni(i), nil_index_list()),
            (secondary_reports[(i - 1)] - scaled_reports[(i - 1)]),
            "assigning variable secondary_reports");
        }
      } 
      current_statement__ = 359;
      assign(secondary_reports, cons_list(index_uni(i), nil_index_list()),
        (1e-6 + secondary_reports[(i - 1)]),
        "assigning variable secondary_reports");}
    current_statement__ = 362;
    return secondary_reports;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct calculate_secondary_functor__ {
template <typename T0__, typename T2__, typename T3__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, T2__,
stan::value_type_t<T3__>>, -1, 1>
operator()(const T0__& reports, const std::vector<int>& obs,
           const std::vector<T2__>& frac_obs, const T3__& delay_rev_pmf,
           const int& cumulative, const int& historic,
           const int& primary_hist_additive, const int& current,
           const int& primary_current_additive, const int& predict,
           std::ostream* pstream__)  const 
{
return calculate_secondary(reports, obs, frac_obs, delay_rev_pmf, cumulative,
         historic, primary_hist_additive, current, primary_current_additive,
         predict, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_simulate_secondary final : public model_base_crtp<model_simulate_secondary> {
private:
  int n;
  int t;
  int h;
  int all_dates;
  std::vector<int> obs;
  Eigen::Matrix<double, -1, -1> primary;
  int seeding_time;
  int cumulative;
  int historic;
  int primary_hist_additive;
  int current;
  int primary_current_additive;
  int delay_n;
  int delay_n_p;
  int delay_n_np;
  std::vector<std::vector<double>> delay_mean;
  std::vector<std::vector<double>> delay_sd;
  std::vector<int> delay_max;
  std::vector<int> delay_dist;
  int delay_np_pmf_max;
  Eigen::Matrix<double, -1, 1> delay_np_pmf;
  std::vector<int> delay_np_pmf_groups;
  std::vector<int> delay_weight;
  int delay_types;
  std::vector<int> delay_types_p;
  std::vector<int> delay_types_id;
  std::vector<int> delay_types_groups;
  int delay_id;
  std::vector<int> day_of_week;
  int week_effect;
  std::vector<std::vector<double>> day_of_week_simplex;
  int obs_scale;
  std::vector<std::vector<double>> frac_obs;
  int model_type;
  std::vector<std::vector<double>> rep_phi;
  int trunc_id;
  std::vector<int> delay_type_max;
  int sim_secondary_2dim__;
 
public:
  ~model_simulate_secondary() { }
  
  inline std::string model_name() const final { return "model_simulate_secondary"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_simulate_secondary(stan::io::var_context& context__,
                           unsigned int random_seed__ = 0,
                           std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_simulate_secondary_namespace::model_simulate_secondary";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 13;
      context__.validate_dims("data initialization","n","int",
          context__.to_vec());
      n = std::numeric_limits<int>::min();
      
      current_statement__ = 13;
      n = context__.vals_i("n")[(1 - 1)];
      current_statement__ = 14;
      context__.validate_dims("data initialization","t","int",
          context__.to_vec());
      t = std::numeric_limits<int>::min();
      
      current_statement__ = 14;
      t = context__.vals_i("t")[(1 - 1)];
      current_statement__ = 15;
      context__.validate_dims("data initialization","h","int",
          context__.to_vec());
      h = std::numeric_limits<int>::min();
      
      current_statement__ = 15;
      h = context__.vals_i("h")[(1 - 1)];
      current_statement__ = 16;
      context__.validate_dims("data initialization","all_dates","int",
          context__.to_vec());
      all_dates = std::numeric_limits<int>::min();
      
      current_statement__ = 16;
      all_dates = context__.vals_i("all_dates")[(1 - 1)];
      current_statement__ = 17;
      validate_non_negative_index("obs", "t - h", (t - h));
      current_statement__ = 18;
      context__.validate_dims("data initialization","obs","int",
          context__.to_vec((t - h)));
      obs = std::vector<int>((t - h), std::numeric_limits<int>::min());
      
      current_statement__ = 18;
      assign(obs, nil_index_list(), context__.vals_i("obs"),
        "assigning variable obs");
      current_statement__ = 18;
      for (int sym1__ = 1; sym1__ <= (t - h); ++sym1__) {
        current_statement__ = 18;
        current_statement__ = 18;
        check_greater_or_equal(function__, "obs[sym1__]", obs[(sym1__ - 1)],
                               0);}
      current_statement__ = 19;
      validate_non_negative_index("primary", "n", n);
      current_statement__ = 20;
      validate_non_negative_index("primary", "t", t);
      current_statement__ = 21;
      context__.validate_dims("data initialization","primary","double",
          context__.to_vec(n, t));
      primary = Eigen::Matrix<double, -1, -1>(n, t);
      stan::math::fill(primary, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> primary_flat__;
        current_statement__ = 21;
        assign(primary_flat__, nil_index_list(), context__.vals_r("primary"),
          "assigning variable primary_flat__");
        current_statement__ = 21;
        pos__ = 1;
        current_statement__ = 21;
        for (int sym1__ = 1; sym1__ <= t; ++sym1__) {
          current_statement__ = 21;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 21;
            assign(primary,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              primary_flat__[(pos__ - 1)], "assigning variable primary");
            current_statement__ = 21;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 22;
      context__.validate_dims("data initialization","seeding_time","int",
          context__.to_vec());
      seeding_time = std::numeric_limits<int>::min();
      
      current_statement__ = 22;
      seeding_time = context__.vals_i("seeding_time")[(1 - 1)];
      current_statement__ = 23;
      context__.validate_dims("data initialization","cumulative","int",
          context__.to_vec());
      cumulative = std::numeric_limits<int>::min();
      
      current_statement__ = 23;
      cumulative = context__.vals_i("cumulative")[(1 - 1)];
      current_statement__ = 24;
      context__.validate_dims("data initialization","historic","int",
          context__.to_vec());
      historic = std::numeric_limits<int>::min();
      
      current_statement__ = 24;
      historic = context__.vals_i("historic")[(1 - 1)];
      current_statement__ = 25;
      context__.validate_dims("data initialization","primary_hist_additive",
          "int",context__.to_vec());
      primary_hist_additive = std::numeric_limits<int>::min();
      
      current_statement__ = 25;
      primary_hist_additive = context__.vals_i("primary_hist_additive")[
          (1 - 1)];
      current_statement__ = 26;
      context__.validate_dims("data initialization","current","int",
          context__.to_vec());
      current = std::numeric_limits<int>::min();
      
      current_statement__ = 26;
      current = context__.vals_i("current")[(1 - 1)];
      current_statement__ = 27;
      context__.validate_dims("data initialization",
          "primary_current_additive","int",context__.to_vec());
      primary_current_additive = std::numeric_limits<int>::min();
      
      current_statement__ = 27;
      primary_current_additive = context__.vals_i("primary_current_additive")[
          (1 - 1)];
      current_statement__ = 28;
      context__.validate_dims("data initialization","delay_n","int",
          context__.to_vec());
      delay_n = std::numeric_limits<int>::min();
      
      current_statement__ = 28;
      delay_n = context__.vals_i("delay_n")[(1 - 1)];
      current_statement__ = 28;
      current_statement__ = 28;
      check_greater_or_equal(function__, "delay_n", delay_n, 0);
      current_statement__ = 29;
      context__.validate_dims("data initialization","delay_n_p","int",
          context__.to_vec());
      delay_n_p = std::numeric_limits<int>::min();
      
      current_statement__ = 29;
      delay_n_p = context__.vals_i("delay_n_p")[(1 - 1)];
      current_statement__ = 29;
      current_statement__ = 29;
      check_greater_or_equal(function__, "delay_n_p", delay_n_p, 0);
      current_statement__ = 30;
      context__.validate_dims("data initialization","delay_n_np","int",
          context__.to_vec());
      delay_n_np = std::numeric_limits<int>::min();
      
      current_statement__ = 30;
      delay_n_np = context__.vals_i("delay_n_np")[(1 - 1)];
      current_statement__ = 30;
      current_statement__ = 30;
      check_greater_or_equal(function__, "delay_n_np", delay_n_np, 0);
      current_statement__ = 31;
      validate_non_negative_index("delay_mean", "n", n);
      current_statement__ = 32;
      validate_non_negative_index("delay_mean", "delay_n_p", delay_n_p);
      current_statement__ = 33;
      context__.validate_dims("data initialization","delay_mean","double",
          context__.to_vec(n, delay_n_p));
      delay_mean = std::vector<std::vector<double>>(n, std::vector<double>(delay_n_p, std::numeric_limits<double>::quiet_NaN()));
      
      {
        std::vector<local_scalar_t__> delay_mean_flat__;
        current_statement__ = 33;
        assign(delay_mean_flat__, nil_index_list(),
          context__.vals_r("delay_mean"),
          "assigning variable delay_mean_flat__");
        current_statement__ = 33;
        pos__ = 1;
        current_statement__ = 33;
        for (int sym1__ = 1; sym1__ <= delay_n_p; ++sym1__) {
          current_statement__ = 33;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 33;
            assign(delay_mean,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              delay_mean_flat__[(pos__ - 1)], "assigning variable delay_mean");
            current_statement__ = 33;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 34;
      validate_non_negative_index("delay_sd", "n", n);
      current_statement__ = 35;
      validate_non_negative_index("delay_sd", "delay_n_p", delay_n_p);
      current_statement__ = 36;
      context__.validate_dims("data initialization","delay_sd","double",
          context__.to_vec(n, delay_n_p));
      delay_sd = std::vector<std::vector<double>>(n, std::vector<double>(delay_n_p, std::numeric_limits<double>::quiet_NaN()));
      
      {
        std::vector<local_scalar_t__> delay_sd_flat__;
        current_statement__ = 36;
        assign(delay_sd_flat__, nil_index_list(),
          context__.vals_r("delay_sd"), "assigning variable delay_sd_flat__");
        current_statement__ = 36;
        pos__ = 1;
        current_statement__ = 36;
        for (int sym1__ = 1; sym1__ <= delay_n_p; ++sym1__) {
          current_statement__ = 36;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 36;
            assign(delay_sd,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              delay_sd_flat__[(pos__ - 1)], "assigning variable delay_sd");
            current_statement__ = 36;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 36;
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        current_statement__ = 36;
        for (int sym2__ = 1; sym2__ <= delay_n_p; ++sym2__) {
          current_statement__ = 36;
          current_statement__ = 36;
          check_greater_or_equal(function__, "delay_sd[sym1__, sym2__]",
                                 delay_sd[(sym1__ - 1)][(sym2__ - 1)], 0);}}
      current_statement__ = 37;
      validate_non_negative_index("delay_max", "delay_n_p", delay_n_p);
      current_statement__ = 38;
      context__.validate_dims("data initialization","delay_max","int",
          context__.to_vec(delay_n_p));
      delay_max = std::vector<int>(delay_n_p, std::numeric_limits<int>::min());
      
      current_statement__ = 38;
      assign(delay_max, nil_index_list(), context__.vals_i("delay_max"),
        "assigning variable delay_max");
      current_statement__ = 38;
      for (int sym1__ = 1; sym1__ <= delay_n_p; ++sym1__) {
        current_statement__ = 38;
        current_statement__ = 38;
        check_greater_or_equal(function__, "delay_max[sym1__]",
                               delay_max[(sym1__ - 1)], 1);}
      current_statement__ = 39;
      validate_non_negative_index("delay_dist", "delay_n_p", delay_n_p);
      current_statement__ = 40;
      context__.validate_dims("data initialization","delay_dist","int",
          context__.to_vec(delay_n_p));
      delay_dist = std::vector<int>(delay_n_p, std::numeric_limits<int>::min());
      
      current_statement__ = 40;
      assign(delay_dist, nil_index_list(), context__.vals_i("delay_dist"),
        "assigning variable delay_dist");
      current_statement__ = 40;
      for (int sym1__ = 1; sym1__ <= delay_n_p; ++sym1__) {
        current_statement__ = 40;
        current_statement__ = 40;
        check_greater_or_equal(function__, "delay_dist[sym1__]",
                               delay_dist[(sym1__ - 1)], 0);}
      current_statement__ = 41;
      context__.validate_dims("data initialization","delay_np_pmf_max","int",
          context__.to_vec());
      delay_np_pmf_max = std::numeric_limits<int>::min();
      
      current_statement__ = 41;
      delay_np_pmf_max = context__.vals_i("delay_np_pmf_max")[(1 - 1)];
      current_statement__ = 41;
      current_statement__ = 41;
      check_greater_or_equal(function__, "delay_np_pmf_max",
                             delay_np_pmf_max, 0);
      current_statement__ = 42;
      validate_non_negative_index("delay_np_pmf", "delay_np_pmf_max",
                                  delay_np_pmf_max);
      current_statement__ = 43;
      context__.validate_dims("data initialization","delay_np_pmf","double",
          context__.to_vec(delay_np_pmf_max));
      delay_np_pmf = Eigen::Matrix<double, -1, 1>(delay_np_pmf_max);
      stan::math::fill(delay_np_pmf, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> delay_np_pmf_flat__;
        current_statement__ = 43;
        assign(delay_np_pmf_flat__, nil_index_list(),
          context__.vals_r("delay_np_pmf"),
          "assigning variable delay_np_pmf_flat__");
        current_statement__ = 43;
        pos__ = 1;
        current_statement__ = 43;
        for (int sym1__ = 1; sym1__ <= delay_np_pmf_max; ++sym1__) {
          current_statement__ = 43;
          assign(delay_np_pmf,
            cons_list(index_uni(sym1__), nil_index_list()),
            delay_np_pmf_flat__[(pos__ - 1)],
            "assigning variable delay_np_pmf");
          current_statement__ = 43;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 43;
      for (int sym1__ = 1; sym1__ <= delay_np_pmf_max; ++sym1__) {
        current_statement__ = 43;
        current_statement__ = 43;
        check_greater_or_equal(function__, "delay_np_pmf[sym1__]",
                               delay_np_pmf[(sym1__ - 1)], 0);}
      current_statement__ = 43;
      for (int sym1__ = 1; sym1__ <= delay_np_pmf_max; ++sym1__) {
        current_statement__ = 43;
        current_statement__ = 43;
        check_less_or_equal(function__, "delay_np_pmf[sym1__]",
                            delay_np_pmf[(sym1__ - 1)], 1);}
      current_statement__ = 44;
      validate_non_negative_index("delay_np_pmf_groups", "delay_n_np + 1",
                                  (delay_n_np + 1));
      current_statement__ = 45;
      context__.validate_dims("data initialization","delay_np_pmf_groups",
          "int",context__.to_vec((delay_n_np + 1)));
      delay_np_pmf_groups = std::vector<int>((delay_n_np + 1), std::numeric_limits<int>::min());
      
      current_statement__ = 45;
      assign(delay_np_pmf_groups, nil_index_list(),
        context__.vals_i("delay_np_pmf_groups"),
        "assigning variable delay_np_pmf_groups");
      current_statement__ = 45;
      for (int sym1__ = 1; sym1__ <= (delay_n_np + 1); ++sym1__) {
        current_statement__ = 45;
        current_statement__ = 45;
        check_greater_or_equal(function__, "delay_np_pmf_groups[sym1__]",
                               delay_np_pmf_groups[(sym1__ - 1)], 1);}
      current_statement__ = 46;
      validate_non_negative_index("delay_weight", "delay_n_p", delay_n_p);
      current_statement__ = 47;
      context__.validate_dims("data initialization","delay_weight","int",
          context__.to_vec(delay_n_p));
      delay_weight = std::vector<int>(delay_n_p, std::numeric_limits<int>::min());
      
      current_statement__ = 47;
      assign(delay_weight, nil_index_list(),
        context__.vals_i("delay_weight"), "assigning variable delay_weight");
      current_statement__ = 48;
      context__.validate_dims("data initialization","delay_types","int",
          context__.to_vec());
      delay_types = std::numeric_limits<int>::min();
      
      current_statement__ = 48;
      delay_types = context__.vals_i("delay_types")[(1 - 1)];
      current_statement__ = 48;
      current_statement__ = 48;
      check_greater_or_equal(function__, "delay_types", delay_types, 0);
      current_statement__ = 49;
      validate_non_negative_index("delay_types_p", "delay_n", delay_n);
      current_statement__ = 50;
      context__.validate_dims("data initialization","delay_types_p","int",
          context__.to_vec(delay_n));
      delay_types_p = std::vector<int>(delay_n, std::numeric_limits<int>::min());
      
      current_statement__ = 50;
      assign(delay_types_p, nil_index_list(),
        context__.vals_i("delay_types_p"), "assigning variable delay_types_p");
      current_statement__ = 50;
      for (int sym1__ = 1; sym1__ <= delay_n; ++sym1__) {
        current_statement__ = 50;
        current_statement__ = 50;
        check_greater_or_equal(function__, "delay_types_p[sym1__]",
                               delay_types_p[(sym1__ - 1)], 0);}
      current_statement__ = 51;
      validate_non_negative_index("delay_types_id", "delay_n", delay_n);
      current_statement__ = 52;
      context__.validate_dims("data initialization","delay_types_id","int",
          context__.to_vec(delay_n));
      delay_types_id = std::vector<int>(delay_n, std::numeric_limits<int>::min());
      
      current_statement__ = 52;
      assign(delay_types_id, nil_index_list(),
        context__.vals_i("delay_types_id"),
        "assigning variable delay_types_id");
      current_statement__ = 52;
      for (int sym1__ = 1; sym1__ <= delay_n; ++sym1__) {
        current_statement__ = 52;
        current_statement__ = 52;
        check_greater_or_equal(function__, "delay_types_id[sym1__]",
                               delay_types_id[(sym1__ - 1)], 0);}
      current_statement__ = 53;
      validate_non_negative_index("delay_types_groups", "delay_types + 1",
                                  (delay_types + 1));
      current_statement__ = 54;
      context__.validate_dims("data initialization","delay_types_groups",
          "int",context__.to_vec((delay_types + 1)));
      delay_types_groups = std::vector<int>((delay_types + 1), std::numeric_limits<int>::min());
      
      current_statement__ = 54;
      assign(delay_types_groups, nil_index_list(),
        context__.vals_i("delay_types_groups"),
        "assigning variable delay_types_groups");
      current_statement__ = 54;
      for (int sym1__ = 1; sym1__ <= (delay_types + 1); ++sym1__) {
        current_statement__ = 54;
        current_statement__ = 54;
        check_greater_or_equal(function__, "delay_types_groups[sym1__]",
                               delay_types_groups[(sym1__ - 1)], 0);}
      current_statement__ = 55;
      context__.validate_dims("data initialization","delay_id","int",
          context__.to_vec());
      delay_id = std::numeric_limits<int>::min();
      
      current_statement__ = 55;
      delay_id = context__.vals_i("delay_id")[(1 - 1)];
      current_statement__ = 55;
      current_statement__ = 55;
      check_greater_or_equal(function__, "delay_id", delay_id, 0);
      current_statement__ = 56;
      validate_non_negative_index("day_of_week", "t - seeding_time",
                                  (t - seeding_time));
      current_statement__ = 57;
      context__.validate_dims("data initialization","day_of_week","int",
          context__.to_vec((t - seeding_time)));
      day_of_week = std::vector<int>((t - seeding_time), std::numeric_limits<int>::min());
      
      current_statement__ = 57;
      assign(day_of_week, nil_index_list(), context__.vals_i("day_of_week"),
        "assigning variable day_of_week");
      current_statement__ = 58;
      context__.validate_dims("data initialization","week_effect","int",
          context__.to_vec());
      week_effect = std::numeric_limits<int>::min();
      
      current_statement__ = 58;
      week_effect = context__.vals_i("week_effect")[(1 - 1)];
      current_statement__ = 59;
      validate_non_negative_index("day_of_week_simplex", "n", n);
      current_statement__ = 60;
      validate_non_negative_index("day_of_week_simplex", "week_effect",
                                  week_effect);
      current_statement__ = 61;
      context__.validate_dims("data initialization","day_of_week_simplex",
          "double",context__.to_vec(n, week_effect));
      day_of_week_simplex = std::vector<std::vector<double>>(n, std::vector<double>(week_effect, std::numeric_limits<double>::quiet_NaN()));
      
      {
        std::vector<local_scalar_t__> day_of_week_simplex_flat__;
        current_statement__ = 61;
        assign(day_of_week_simplex_flat__, nil_index_list(),
          context__.vals_r("day_of_week_simplex"),
          "assigning variable day_of_week_simplex_flat__");
        current_statement__ = 61;
        pos__ = 1;
        current_statement__ = 61;
        for (int sym1__ = 1; sym1__ <= week_effect; ++sym1__) {
          current_statement__ = 61;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 61;
            assign(day_of_week_simplex,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              day_of_week_simplex_flat__[(pos__ - 1)],
              "assigning variable day_of_week_simplex");
            current_statement__ = 61;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 61;
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        current_statement__ = 61;
        for (int sym2__ = 1; sym2__ <= week_effect; ++sym2__) {
          current_statement__ = 61;
          current_statement__ = 61;
          check_greater_or_equal(function__,
                                 "day_of_week_simplex[sym1__, sym2__]",
                                 day_of_week_simplex[(sym1__ - 1)][(sym2__ -
                                                                    1)], 0);}
      }
      current_statement__ = 62;
      context__.validate_dims("data initialization","obs_scale","int",
          context__.to_vec());
      obs_scale = std::numeric_limits<int>::min();
      
      current_statement__ = 62;
      obs_scale = context__.vals_i("obs_scale")[(1 - 1)];
      current_statement__ = 63;
      validate_non_negative_index("frac_obs", "n", n);
      current_statement__ = 64;
      validate_non_negative_index("frac_obs", "obs_scale", obs_scale);
      current_statement__ = 65;
      context__.validate_dims("data initialization","frac_obs","double",
          context__.to_vec(n, obs_scale));
      frac_obs = std::vector<std::vector<double>>(n, std::vector<double>(obs_scale, std::numeric_limits<double>::quiet_NaN()));
      
      {
        std::vector<local_scalar_t__> frac_obs_flat__;
        current_statement__ = 65;
        assign(frac_obs_flat__, nil_index_list(),
          context__.vals_r("frac_obs"), "assigning variable frac_obs_flat__");
        current_statement__ = 65;
        pos__ = 1;
        current_statement__ = 65;
        for (int sym1__ = 1; sym1__ <= obs_scale; ++sym1__) {
          current_statement__ = 65;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 65;
            assign(frac_obs,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              frac_obs_flat__[(pos__ - 1)], "assigning variable frac_obs");
            current_statement__ = 65;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 65;
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        current_statement__ = 65;
        for (int sym2__ = 1; sym2__ <= obs_scale; ++sym2__) {
          current_statement__ = 65;
          current_statement__ = 65;
          check_greater_or_equal(function__, "frac_obs[sym1__, sym2__]",
                                 frac_obs[(sym1__ - 1)][(sym2__ - 1)], 0);}}
      current_statement__ = 65;
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        current_statement__ = 65;
        for (int sym2__ = 1; sym2__ <= obs_scale; ++sym2__) {
          current_statement__ = 65;
          current_statement__ = 65;
          check_less_or_equal(function__, "frac_obs[sym1__, sym2__]",
                              frac_obs[(sym1__ - 1)][(sym2__ - 1)], 1);}}
      current_statement__ = 66;
      context__.validate_dims("data initialization","model_type","int",
          context__.to_vec());
      model_type = std::numeric_limits<int>::min();
      
      current_statement__ = 66;
      model_type = context__.vals_i("model_type")[(1 - 1)];
      current_statement__ = 67;
      validate_non_negative_index("rep_phi", "n", n);
      current_statement__ = 68;
      validate_non_negative_index("rep_phi", "model_type", model_type);
      current_statement__ = 69;
      context__.validate_dims("data initialization","rep_phi","double",
          context__.to_vec(n, model_type));
      rep_phi = std::vector<std::vector<double>>(n, std::vector<double>(model_type, std::numeric_limits<double>::quiet_NaN()));
      
      {
        std::vector<local_scalar_t__> rep_phi_flat__;
        current_statement__ = 69;
        assign(rep_phi_flat__, nil_index_list(), context__.vals_r("rep_phi"),
          "assigning variable rep_phi_flat__");
        current_statement__ = 69;
        pos__ = 1;
        current_statement__ = 69;
        for (int sym1__ = 1; sym1__ <= model_type; ++sym1__) {
          current_statement__ = 69;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 69;
            assign(rep_phi,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              rep_phi_flat__[(pos__ - 1)], "assigning variable rep_phi");
            current_statement__ = 69;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 69;
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        current_statement__ = 69;
        for (int sym2__ = 1; sym2__ <= model_type; ++sym2__) {
          current_statement__ = 69;
          current_statement__ = 69;
          check_greater_or_equal(function__, "rep_phi[sym1__, sym2__]",
                                 rep_phi[(sym1__ - 1)][(sym2__ - 1)], 0);}}
      current_statement__ = 70;
      context__.validate_dims("data initialization","trunc_id","int",
          context__.to_vec());
      trunc_id = std::numeric_limits<int>::min();
      
      current_statement__ = 70;
      trunc_id = context__.vals_i("trunc_id")[(1 - 1)];
      current_statement__ = 70;
      current_statement__ = 70;
      check_greater_or_equal(function__, "trunc_id", trunc_id, 0);
      current_statement__ = 71;
      validate_non_negative_index("delay_type_max", "delay_types",
                                  delay_types);
      current_statement__ = 72;
      delay_type_max = std::vector<int>(delay_types, std::numeric_limits<int>::min());
      
      current_statement__ = 72;
      assign(delay_type_max, nil_index_list(),
        get_delay_type_max(delay_types, delay_types_p, delay_types_id,
          delay_types_groups, delay_max, delay_np_pmf_groups, pstream__),
        "assigning variable delay_type_max");
      current_statement__ = 73;
      validate_non_negative_index("sim_secondary", "n", n);
      current_statement__ = 74;
      sim_secondary_2dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 74;
      sim_secondary_2dim__ = (all_dates ? t : h);
      current_statement__ = 74;
      validate_non_negative_index("sim_secondary", "all_dates ? t : h",
                                  sim_secondary_2dim__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_simulate_secondary_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_simulate_secondary_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      std::vector<std::vector<int>> sim_secondary;
      sim_secondary = std::vector<std::vector<int>>(n, std::vector<int>(sim_secondary_2dim__, std::numeric_limits<int>::min()));
      
      current_statement__ = 12;
      for (int i = 1; i <= n; ++i) {
        current_statement__ = 2;
        validate_non_negative_index("secondary", "t", t);
        Eigen::Matrix<double, -1, 1> secondary;
        secondary = Eigen::Matrix<double, -1, 1>(t);
        stan::math::fill(secondary, std::numeric_limits<double>::quiet_NaN());
        
        current_statement__ = 4;
        validate_non_negative_index("delay_rev_pmf",
                                    "delay_type_max[delay_id]",
                                    delay_type_max[(delay_id - 1)]);
        Eigen::Matrix<double, -1, 1> delay_rev_pmf;
        delay_rev_pmf = Eigen::Matrix<double, -1, 1>(delay_type_max[(delay_id
                                                                    - 1)]);
        stan::math::fill(delay_rev_pmf, std::numeric_limits<double>::quiet_NaN());
        
        current_statement__ = 5;
        assign(delay_rev_pmf, nil_index_list(),
          get_delay_rev_pmf(delay_id, delay_type_max[(delay_id - 1)],
            delay_types_p, delay_types_id, delay_types_groups, delay_max,
            delay_np_pmf, delay_np_pmf_groups, delay_mean[(i - 1)],
            delay_sd[(i - 1)], delay_dist, 0, 1, 0, pstream__),
          "assigning variable delay_rev_pmf");
        current_statement__ = 6;
        assign(secondary, nil_index_list(),
          calculate_secondary(
            to_vector(
              rvalue(primary, cons_list(index_uni(i), nil_index_list()),
                "primary")), obs, frac_obs[(i - 1)], delay_rev_pmf,
            cumulative, historic, primary_hist_additive, current,
            primary_current_additive, ((t - h) + 1), pstream__),
          "assigning variable secondary");
        current_statement__ = 9;
        if (logical_gt(week_effect, 1)) {
          current_statement__ = 7;
          assign(secondary, nil_index_list(),
            day_of_week_effect(stan::model::deep_copy(secondary),
              day_of_week,
              to_vector(day_of_week_simplex[(i - 1)]), pstream__),
            "assigning variable secondary");
        } 
        current_statement__ = 10;
        assign(sim_secondary, cons_list(index_uni(i), nil_index_list()),
          report_rng(tail(secondary, (all_dates ? t : h)), rep_phi[(i - 1)],
            model_type, base_rng__, pstream__),
          "assigning variable sim_secondary");}
      for (int sym1__ = 1; sym1__ <= sim_secondary_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
          vars__.emplace_back(sim_secondary[(sym2__ - 1)][(sym1__ - 1)]);}}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("sim_secondary");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(n),
                                             static_cast<size_t>(sim_secondary_2dim__)
                                             });
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= sim_secondary_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "sim_secondary" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= sim_secondary_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "sim_secondary" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"sim_secondary\",\"type\":{\"name\":\"array\",\"length\":" << n << ",\"element_type\":{\"name\":\"array\",\"length\":" << sim_secondary_2dim__ << ",\"element_type\":{\"name\":\"int\"}}},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"sim_secondary\",\"type\":{\"name\":\"array\",\"length\":" << n << ",\"element_type\":{\"name\":\"array\",\"length\":" << sim_secondary_2dim__ << ",\"element_type\":{\"name\":\"int\"}}},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_simulate_secondary_namespace::model_simulate_secondary;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_simulate_secondary_namespace::profiles__;
}
#endif
#endif
