% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise.R
\name{extract_CrIs}
\alias{extract_CrIs}
\title{Extract Credible Intervals Present}
\usage{
extract_CrIs(summarised)
}
\arguments{
\item{summarised}{A \verb{<data.frame>} as processed by \code{calc_CrIs}}
}
\value{
A numeric vector of credible intervals detected in
the \verb{<data.frame>}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Helper function to extract the credible intervals present in a
\verb{<data.frame>}.
}
\examples{
samples <- data.frame(value = 1:10, type = "car")
summarised <- calc_CrIs(samples,
  summarise_by = "type",
  CrIs = c(seq(0.05, 0.95, 0.05))
)
extract_CrIs(summarised)
}
