// Generated by rstantools.  Do not edit by hand.

/*
    EpiNow2 is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    EpiNow2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with EpiNow2.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_simulate_secondary_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 391> locations_array__ =
  {" (found before start of program)",
  " (in 'simulate_secondary', line 561, column 2 to column 48)",
  " (in 'simulate_secondary', line 563, column 11 to column 12)",
  " (in 'simulate_secondary', line 563, column 4 to column 24)",
  " (in 'simulate_secondary', line 564, column 11 to column 12)",
  " (in 'simulate_secondary', line 564, column 4 to column 21)",
  " (in 'simulate_secondary', line 565, column 11 to column 12)",
  " (in 'simulate_secondary', line 565, column 4 to column 46)",
  " (in 'simulate_secondary', line 569, column 6 to column 37)",
  " (in 'simulate_secondary', line 568, column 11 to line 570, column 5)",
  " (in 'simulate_secondary', line 567, column 6 to column 64)",
  " (in 'simulate_secondary', line 566, column 19 to line 568, column 5)",
  " (in 'simulate_secondary', line 566, column 4 to line 570, column 5)",
  " (in 'simulate_secondary', line 580, column 6 to column 37)",
  " (in 'simulate_secondary', line 579, column 11 to line 581, column 5)",
  " (in 'simulate_secondary', line 572, column 13 to column 41)",
  " (in 'simulate_secondary', line 572, column 6 to line 577, column 8)",
  " (in 'simulate_secondary', line 578, column 6 to column 75)",
  " (in 'simulate_secondary', line 571, column 18 to line 579, column 5)",
  " (in 'simulate_secondary', line 571, column 4 to line 581, column 5)",
  " (in 'simulate_secondary', line 583, column 4 to line 586, column 6)",
  " (in 'simulate_secondary', line 589, column 6 to column 96)",
  " (in 'simulate_secondary', line 588, column 25 to line 590, column 5)",
  " (in 'simulate_secondary', line 588, column 4 to line 590, column 5)",
  " (in 'simulate_secondary', line 593, column 13 to column 41)",
  " (in 'simulate_secondary', line 593, column 6 to line 598, column 8)",
  " (in 'simulate_secondary', line 599, column 6 to line 601, column 8)",
  " (in 'simulate_secondary', line 592, column 18 to line 602, column 5)",
  " (in 'simulate_secondary', line 592, column 4 to line 602, column 5)",
  " (in 'simulate_secondary', line 604, column 4 to line 606, column 6)",
  " (in 'simulate_secondary', line 562, column 17 to line 607, column 3)",
  " (in 'simulate_secondary', line 562, column 2 to line 607, column 3)",
  " (in 'simulate_secondary', line 507, column 2 to column 8)",
  " (in 'simulate_secondary', line 508, column 2 to column 8)",
  " (in 'simulate_secondary', line 509, column 2 to column 8)",
  " (in 'simulate_secondary', line 510, column 2 to column 16)",
  " (in 'simulate_secondary', line 512, column 8 to column 13)",
  " (in 'simulate_secondary', line 512, column 2 to column 34)",
  " (in 'simulate_secondary', line 513, column 9 to column 10)",
  " (in 'simulate_secondary', line 513, column 12 to column 13)",
  " (in 'simulate_secondary', line 513, column 2 to column 23)",
  " (in 'simulate_secondary', line 515, column 2 to column 19)",
  " (in 'simulate_secondary', line 516, column 2 to column 17)",
  " (in 'simulate_secondary', line 517, column 2 to column 15)",
  " (in 'simulate_secondary', line 518, column 2 to column 28)",
  " (in 'simulate_secondary', line 519, column 2 to column 14)",
  " (in 'simulate_secondary', line 520, column 2 to column 31)",
  " (in 'simulate_secondary', line 523, column 2 to column 25)",
  " (in 'simulate_secondary', line 524, column 2 to column 27)",
  " (in 'simulate_secondary', line 525, column 2 to column 28)",
  " (in 'simulate_secondary', line 526, column 8 to column 17)",
  " (in 'simulate_secondary', line 526, column 2 to column 44)",
  " (in 'simulate_secondary', line 527, column 8 to column 17)",
  " (in 'simulate_secondary', line 527, column 2 to column 45)",
  " (in 'simulate_secondary', line 528, column 2 to column 37)",
  " (in 'simulate_secondary', line 529, column 31 to column 50)",
  " (in 'simulate_secondary', line 529, column 2 to column 65)",
  " (in 'simulate_secondary', line 530, column 8 to column 22)",
  " (in 'simulate_secondary', line 530, column 2 to column 59)",
  " (in 'simulate_secondary', line 531, column 8 to column 17)",
  " (in 'simulate_secondary', line 531, column 2 to column 36)",
  " (in 'simulate_secondary', line 533, column 2 to column 37)",
  " (in 'simulate_secondary', line 534, column 8 to column 9)",
  " (in 'simulate_secondary', line 534, column 18 to column 37)",
  " (in 'simulate_secondary', line 534, column 2 to column 52)",
  " (in 'simulate_secondary', line 535, column 8 to column 21)",
  " (in 'simulate_secondary', line 535, column 2 to column 58)",
  " (in 'simulate_secondary', line 537, column 2 to column 29)",
  " (in 'simulate_secondary', line 538, column 8 to column 15)",
  " (in 'simulate_secondary', line 538, column 2 to column 46)",
  " (in 'simulate_secondary', line 539, column 8 to column 15)",
  " (in 'simulate_secondary', line 539, column 2 to column 47)",
  " (in 'simulate_secondary', line 540, column 8 to column 23)",
  " (in 'simulate_secondary', line 540, column 2 to column 59)",
  " (in 'simulate_secondary', line 542, column 2 to column 26)",
  " (in 'simulate_secondary', line 545, column 8 to column 24)",
  " (in 'simulate_secondary', line 545, column 2 to column 42)",
  " (in 'simulate_secondary', line 546, column 2 to column 18)",
  " (in 'simulate_secondary', line 547, column 8 to column 9)",
  " (in 'simulate_secondary', line 547, column 11 to column 22)",
  " (in 'simulate_secondary', line 547, column 2 to column 60)",
  " (in 'simulate_secondary', line 548, column 2 to column 16)",
  " (in 'simulate_secondary', line 549, column 8 to column 9)",
  " (in 'simulate_secondary', line 549, column 11 to column 20)",
  " (in 'simulate_secondary', line 549, column 2 to column 58)",
  " (in 'simulate_secondary', line 550, column 2 to column 17)",
  " (in 'simulate_secondary', line 551, column 8 to column 9)",
  " (in 'simulate_secondary', line 551, column 11 to column 21)",
  " (in 'simulate_secondary', line 551, column 2 to column 47)",
  " (in 'simulate_secondary', line 552, column 2 to column 26)",
  " (in 'simulate_secondary', line 555, column 8 to column 19)",
  " (in 'simulate_secondary', line 555, column 2 to line 558, column 4)",
  " (in 'simulate_secondary', line 561, column 8 to column 9)",
  " (in 'simulate_secondary', line 561, column 11 to column 28)",
  " (in 'simulate_secondary', line 12, column 2 to column 30)",
  " (in 'simulate_secondary', line 13, column 2 to column 41)",
  " (in 'simulate_secondary', line 14, column 2 to column 16)",
  " (in 'simulate_secondary', line 15, column 2 to column 41)",
  " (in 'simulate_secondary', line 16, column 2 to column 19)",
  " (in 'simulate_secondary', line 17, column 2 to column 42)",
  " (in 'simulate_secondary', line 11, column 62 to line 18, column 1)",
  " (in 'simulate_secondary', line 29, column 2 to column 30)",
  " (in 'simulate_secondary', line 30, column 2 to column 41)",
  " (in 'simulate_secondary', line 31, column 2 to column 19)",
  " (in 'simulate_secondary', line 32, column 2 to column 41)",
  " (in 'simulate_secondary', line 32, column 41 to column 42)",
  " (in 'simulate_secondary', line 33, column 2 to column 30)",
  " (in 'simulate_secondary', line 34, column 2 to column 42)",
  " (in 'simulate_secondary', line 28, column 61 to line 35, column 1)",
  " (in 'simulate_secondary', line 50, column 2 to column 29)",
  " (in 'simulate_secondary', line 51, column 2 to column 29)",
  " (in 'simulate_secondary', line 52, column 9 to column 12)",
  " (in 'simulate_secondary', line 52, column 2 to column 16)",
  " (in 'simulate_secondary', line 55, column 4 to column 74)",
  " (in 'simulate_secondary', line 54, column 29 to line 56, column 3)",
  " (in 'simulate_secondary', line 54, column 2 to line 56, column 3)",
  " (in 'simulate_secondary', line 59, column 4 to column 59)",
  " (in 'simulate_secondary', line 58, column 18 to line 60, column 3)",
  " (in 'simulate_secondary', line 58, column 2 to line 60, column 3)",
  " (in 'simulate_secondary', line 63, column 4 to column 65)",
  " (in 'simulate_secondary', line 64, column 4 to column 75)",
  " (in 'simulate_secondary', line 62, column 20 to line 65, column 3)",
  " (in 'simulate_secondary', line 62, column 2 to line 65, column 3)",
  " (in 'simulate_secondary', line 69, column 6 to column 66)",
  " (in 'simulate_secondary', line 70, column 6 to column 77)",
  " (in 'simulate_secondary', line 68, column 30 to line 71, column 5)",
  " (in 'simulate_secondary', line 68, column 4 to line 71, column 5)",
  " (in 'simulate_secondary', line 67, column 18 to line 72, column 3)",
  " (in 'simulate_secondary', line 67, column 2 to line 72, column 3)",
  " (in 'simulate_secondary', line 74, column 2 to column 11)",
  " (in 'simulate_secondary', line 49, column 58 to line 75, column 1)",
  " (in 'simulate_secondary', line 93, column 2 to column 35)",
  " (in 'simulate_secondary', line 94, column 2 to column 43)",
  " (in 'simulate_secondary', line 97, column 4 to column 44)",
  " (in 'simulate_secondary', line 96, column 19 to line 98, column 3)",
  " (in 'simulate_secondary', line 96, column 2 to line 98, column 3)",
  " (in 'simulate_secondary', line 100, column 9 to column 10)",
  " (in 'simulate_secondary', line 100, column 2 to column 80)",
  " (in 'simulate_secondary', line 101, column 2 to column 45)",
  " (in 'simulate_secondary', line 92, column 44 to line 102, column 1)",
  " (in 'simulate_secondary', line 109, column 9 to column 10)",
  " (in 'simulate_secondary', line 109, column 2 to column 17)",
  " (in 'simulate_secondary', line 110, column 9 to column 10)",
  " (in 'simulate_secondary', line 110, column 2 to column 23)",
  " (in 'simulate_secondary', line 120, column 4 to column 54)",
  " (in 'simulate_secondary', line 119, column 9 to line 121, column 3)",
  " (in 'simulate_secondary', line 117, column 6 to column 59)",
  " (in 'simulate_secondary', line 116, column 19 to line 118, column 5)",
  " (in 'simulate_secondary', line 116, column 4 to line 118, column 5)",
  " (in 'simulate_secondary', line 115, column 24 to line 119, column 3)",
  " (in 'simulate_secondary', line 115, column 9 to line 121, column 3)",
  " (in 'simulate_secondary', line 113, column 6 to column 63)",
  " (in 'simulate_secondary', line 112, column 19 to line 114, column 5)",
  " (in 'simulate_secondary', line 112, column 4 to line 114, column 5)",
  " (in 'simulate_secondary', line 111, column 17 to line 115, column 3)",
  " (in 'simulate_secondary', line 111, column 2 to line 121, column 3)",
  " (in 'simulate_secondary', line 132, column 4 to column 16)",
  " (in 'simulate_secondary', line 131, column 9 to line 133, column 3)",
  " (in 'simulate_secondary', line 124, column 4 to column 28)",
  " (in 'simulate_secondary', line 125, column 4 to column 28)",
  " (in 'simulate_secondary', line 127, column 6 to column 71)",
  " (in 'simulate_secondary', line 126, column 15 to line 128, column 5)",
  " (in 'simulate_secondary', line 126, column 4 to line 128, column 5)",
  " (in 'simulate_secondary', line 130, column 4 to column 53)",
  " (in 'simulate_secondary', line 123, column 13 to line 131, column 3)",
  " (in 'simulate_secondary', line 123, column 2 to line 133, column 3)",
  " (in 'simulate_secondary', line 134, column 2 to column 20)",
  " (in 'simulate_secondary', line 108, column 55 to line 135, column 1)",
  " (in 'simulate_secondary', line 141, column 8 to column 19)",
  " (in 'simulate_secondary', line 141, column 2 to column 29)",
  " (in 'simulate_secondary', line 143, column 4 to column 15)",
  " (in 'simulate_secondary', line 148, column 8 to line 149, column 53)",
  " (in 'simulate_secondary', line 147, column 13 to line 150, column 7)",
  " (in 'simulate_secondary', line 146, column 8 to column 47)",
  " (in 'simulate_secondary', line 145, column 28 to line 147, column 7)",
  " (in 'simulate_secondary', line 145, column 6 to line 150, column 7)",
  " (in 'simulate_secondary', line 144, column 69 to line 151, column 5)",
  " (in 'simulate_secondary', line 144, column 4 to line 151, column 5)",
  " (in 'simulate_secondary', line 142, column 27 to line 152, column 3)",
  " (in 'simulate_secondary', line 142, column 2 to line 152, column 3)",
  " (in 'simulate_secondary', line 153, column 2 to column 13)",
  " (in 'simulate_secondary', line 140, column 2 to line 154, column 1)",
  " (in 'simulate_secondary', line 164, column 9 to column 12)",
  " (in 'simulate_secondary', line 164, column 2 to column 39)",
  " (in 'simulate_secondary', line 165, column 2 to column 22)",
  " (in 'simulate_secondary', line 166, column 2 to column 14)",
  " (in 'simulate_secondary', line 186, column 6 to column 57)",
  " (in 'simulate_secondary', line 187, column 6 to column 63)",
  " (in 'simulate_secondary', line 188, column 6 to column 42)",
  " (in 'simulate_secondary', line 192, column 8 to line 194, column 10)",
  " (in 'simulate_secondary', line 191, column 13 to line 195, column 7)",
  " (in 'simulate_secondary', line 190, column 8 to column 49)",
  " (in 'simulate_secondary', line 189, column 28 to line 191, column 7)",
  " (in 'simulate_secondary', line 189, column 6 to line 195, column 7)",
  " (in 'simulate_secondary', line 185, column 11 to line 196, column 5)",
  " (in 'simulate_secondary', line 169, column 6 to column 57)",
  " (in 'simulate_secondary', line 170, column 6 to column 63)",
  " (in 'simulate_secondary', line 171, column 13 to column 45)",
  " (in 'simulate_secondary', line 171, column 6 to line 176, column 8)",
  " (in 'simulate_secondary', line 177, column 6 to column 59)",
  " (in 'simulate_secondary', line 181, column 8 to line 183, column 10)",
  " (in 'simulate_secondary', line 180, column 13 to line 184, column 7)",
  " (in 'simulate_secondary', line 179, column 8 to column 42)",
  " (in 'simulate_secondary', line 178, column 28 to line 180, column 7)",
  " (in 'simulate_secondary', line 178, column 6 to line 184, column 7)",
  " (in 'simulate_secondary', line 168, column 26 to line 185, column 5)",
  " (in 'simulate_secondary', line 168, column 4 to line 196, column 5)",
  " (in 'simulate_secondary', line 197, column 4 to column 26)",
  " (in 'simulate_secondary', line 167, column 81 to line 198, column 3)",
  " (in 'simulate_secondary', line 167, column 2 to line 198, column 3)",
  " (in 'simulate_secondary', line 200, column 4 to line 203, column 6)",
  " (in 'simulate_secondary', line 199, column 21 to line 204, column 3)",
  " (in 'simulate_secondary', line 199, column 2 to line 204, column 3)",
  " (in 'simulate_secondary', line 206, column 4 to column 30)",
  " (in 'simulate_secondary', line 205, column 18 to line 207, column 3)",
  " (in 'simulate_secondary', line 205, column 2 to line 207, column 3)",
  " (in 'simulate_secondary', line 209, column 4 to column 23)",
  " (in 'simulate_secondary', line 208, column 19 to line 210, column 3)",
  " (in 'simulate_secondary', line 208, column 2 to line 210, column 3)",
  " (in 'simulate_secondary', line 211, column 2 to column 13)",
  " (in 'simulate_secondary', line 162, column 2 to line 212, column 1)",
  " (in 'simulate_secondary', line 219, column 2 to column 55)",
  " (in 'simulate_secondary', line 221, column 4 to column 11)",
  " (in 'simulate_secondary', line 220, column 21 to line 222, column 3)",
  " (in 'simulate_secondary', line 220, column 2 to line 222, column 3)",
  " (in 'simulate_secondary', line 224, column 4 to column 39)",
  " (in 'simulate_secondary', line 225, column 4 to column 45)",
  " (in 'simulate_secondary', line 231, column 10 to column 77)",
  " (in 'simulate_secondary', line 230, column 14 to line 232, column 9)",
  " (in 'simulate_secondary', line 229, column 10 to column 104)",
  " (in 'simulate_secondary', line 228, column 27 to line 230, column 9)",
  " (in 'simulate_secondary', line 228, column 8 to line 232, column 9)",
  " (in 'simulate_secondary', line 227, column 34 to line 233, column 7)",
  " (in 'simulate_secondary', line 227, column 6 to line 233, column 7)",
  " (in 'simulate_secondary', line 226, column 25 to line 234, column 5)",
  " (in 'simulate_secondary', line 226, column 4 to line 234, column 5)",
  " (in 'simulate_secondary', line 223, column 24 to line 235, column 3)",
  " (in 'simulate_secondary', line 223, column 2 to line 235, column 3)",
  " (in 'simulate_secondary', line 218, column 59 to line 236, column 1)",
  " (in 'simulate_secondary', line 239, column 2 to column 29)",
  " (in 'simulate_secondary', line 240, column 9 to column 12)",
  " (in 'simulate_secondary', line 240, column 2 to column 18)",
  " (in 'simulate_secondary', line 242, column 4 to column 49)",
  " (in 'simulate_secondary', line 243, column 4 to column 31)",
  " (in 'simulate_secondary', line 244, column 4 to column 45)",
  " (in 'simulate_secondary', line 241, column 19 to line 245, column 3)",
  " (in 'simulate_secondary', line 241, column 2 to line 245, column 3)",
  " (in 'simulate_secondary', line 246, column 2 to column 13)",
  " (in 'simulate_secondary', line 238, column 57 to line 247, column 1)",
  " (in 'simulate_secondary', line 261, column 2 to column 32)",
  " (in 'simulate_secondary', line 262, column 9 to column 11)",
  " (in 'simulate_secondary', line 262, column 2 to column 41)",
  " (in 'simulate_secondary', line 263, column 2 to column 47)",
  " (in 'simulate_secondary', line 260, column 82 to line 264, column 1)",
  " (in 'simulate_secondary', line 277, column 2 to column 32)",
  " (in 'simulate_secondary', line 278, column 9 to column 10)",
  " (in 'simulate_secondary', line 278, column 2 to column 27)",
  " (in 'simulate_secondary', line 279, column 2 to column 38)",
  " (in 'simulate_secondary', line 280, column 2 to column 25)",
  " (in 'simulate_secondary', line 276, column 48 to line 281, column 1)",
  " (in 'simulate_secondary', line 295, column 2 to column 32)",
  " (in 'simulate_secondary', line 296, column 2 to column 46)",
  " (in 'simulate_secondary', line 297, column 9 to column 10)",
  " (in 'simulate_secondary', line 297, column 2 to column 36)",
  " (in 'simulate_secondary', line 299, column 2 to column 36)",
  " (in 'simulate_secondary', line 300, column 2 to column 34)",
  " (in 'simulate_secondary', line 301, column 2 to column 46)",
  " (in 'simulate_secondary', line 307, column 4 to column 70)",
  " (in 'simulate_secondary', line 306, column 9 to line 308, column 3)",
  " (in 'simulate_secondary', line 305, column 4 to column 70)",
  " (in 'simulate_secondary', line 304, column 19 to line 306, column 3)",
  " (in 'simulate_secondary', line 304, column 2 to line 308, column 3)",
  " (in 'simulate_secondary', line 309, column 2 to column 24)",
  " (in 'simulate_secondary', line 294, column 75 to line 310, column 1)",
  " (in 'simulate_secondary', line 327, column 2 to column 49)",
  " (in 'simulate_secondary', line 331, column 6 to column 63)",
  " (in 'simulate_secondary', line 329, column 30 to line 332, column 5)",
  " (in 'simulate_secondary', line 329, column 4 to line 332, column 5)",
  " (in 'simulate_secondary', line 335, column 6 to column 57)",
  " (in 'simulate_secondary', line 333, column 28 to line 336, column 5)",
  " (in 'simulate_secondary', line 333, column 4 to line 336, column 5)",
  " (in 'simulate_secondary', line 328, column 18 to line 337, column 3)",
  " (in 'simulate_secondary', line 328, column 2 to line 337, column 3)",
  " (in 'simulate_secondary', line 326, column 73 to line 338, column 1)",
  " (in 'simulate_secondary', line 358, column 2 to column 48)",
  " (in 'simulate_secondary', line 359, column 9 to column 10)",
  " (in 'simulate_secondary', line 359, column 2 to column 24)",
  " (in 'simulate_secondary', line 360, column 8 to column 9)",
  " (in 'simulate_secondary', line 360, column 2 to column 25)",
  " (in 'simulate_secondary', line 377, column 4 to column 38)",
  " (in 'simulate_secondary', line 378, column 4 to column 22)",
  " (in 'simulate_secondary', line 376, column 9 to line 379, column 3)",
  " (in 'simulate_secondary', line 362, column 4 to column 34)",
  " (in 'simulate_secondary', line 363, column 4 to column 14)",
  " (in 'simulate_secondary', line 364, column 4 to column 24)",
  " (in 'simulate_secondary', line 365, column 4 to column 35)",
  " (in 'simulate_secondary', line 368, column 8 to column 47)",
  " (in 'simulate_secondary', line 367, column 27 to line 369, column 7)",
  " (in 'simulate_secondary', line 367, column 6 to line 369, column 7)",
  " (in 'simulate_secondary', line 371, column 8 to column 25)",
  " (in 'simulate_secondary', line 370, column 44 to line 372, column 7)",
  " (in 'simulate_secondary', line 370, column 6 to line 372, column 7)",
  " (in 'simulate_secondary', line 373, column 6 to column 13)",
  " (in 'simulate_secondary', line 366, column 39 to line 374, column 5)",
  " (in 'simulate_secondary', line 366, column 4 to line 374, column 5)",
  " (in 'simulate_secondary', line 375, column 4 to column 33)",
  " (in 'simulate_secondary', line 361, column 18 to line 376, column 3)",
  " (in 'simulate_secondary', line 361, column 2 to line 379, column 3)",
  " (in 'simulate_secondary', line 396, column 6 to column 63)",
  " (in 'simulate_secondary', line 395, column 11 to line 397, column 5)",
  " (in 'simulate_secondary', line 394, column 6 to column 39)",
  " (in 'simulate_secondary', line 393, column 21 to line 395, column 5)",
  " (in 'simulate_secondary', line 393, column 4 to line 397, column 5)",
  " (in 'simulate_secondary', line 392, column 9 to line 398, column 3)",
  " (in 'simulate_secondary', line 381, column 4 to column 78)",
  " (in 'simulate_secondary', line 383, column 6 to column 59)",
  " (in 'simulate_secondary', line 383, column 55 to column 56)",
  " (in 'simulate_secondary', line 382, column 20 to line 384, column 5)",
  " (in 'simulate_secondary', line 382, column 4 to line 384, column 5)",
  " (in 'simulate_secondary', line 388, column 6 to line 390, column 17)",
  " (in 'simulate_secondary', line 387, column 11 to line 391, column 5)",
  " (in 'simulate_secondary', line 386, column 6 to column 58)",
  " (in 'simulate_secondary', line 385, column 21 to line 387, column 5)",
  " (in 'simulate_secondary', line 385, column 4 to line 391, column 5)",
  " (in 'simulate_secondary', line 380, column 18 to line 392, column 3)",
  " (in 'simulate_secondary', line 380, column 2 to line 398, column 3)",
  " (in 'simulate_secondary', line 357, column 60 to line 399, column 1)",
  " (in 'simulate_secondary', line 416, column 2 to column 32)",
  " (in 'simulate_secondary', line 417, column 9 to column 10)",
  " (in 'simulate_secondary', line 417, column 2 to column 20)",
  " (in 'simulate_secondary', line 425, column 4 to column 54)",
  " (in 'simulate_secondary', line 427, column 6 to column 83)",
  " (in 'simulate_secondary', line 426, column 19 to line 428, column 5)",
  " (in 'simulate_secondary', line 426, column 4 to line 428, column 5)",
  " (in 'simulate_secondary', line 424, column 9 to line 429, column 3)",
  " (in 'simulate_secondary', line 422, column 6 to column 64)",
  " (in 'simulate_secondary', line 421, column 19 to line 423, column 5)",
  " (in 'simulate_secondary', line 421, column 4 to line 423, column 5)",
  " (in 'simulate_secondary', line 420, column 23 to line 424, column 3)",
  " (in 'simulate_secondary', line 420, column 2 to line 429, column 3)",
  " (in 'simulate_secondary', line 430, column 2 to column 18)",
  " (in 'simulate_secondary', line 415, column 73 to line 431, column 1)",
  " (in 'simulate_secondary', line 445, column 2 to column 32)",
  " (in 'simulate_secondary', line 446, column 8 to column 9)",
  " (in 'simulate_secondary', line 446, column 2 to column 31)",
  " (in 'simulate_secondary', line 447, column 2 to column 24)",
  " (in 'simulate_secondary', line 449, column 4 to column 49)",
  " (in 'simulate_secondary', line 448, column 18 to line 450, column 3)",
  " (in 'simulate_secondary', line 448, column 2 to line 450, column 3)",
  " (in 'simulate_secondary', line 460, column 8 to column 97)",
  " (in 'simulate_secondary', line 459, column 13 to line 461, column 7)",
  " (in 'simulate_secondary', line 458, column 8 to column 78)",
  " (in 'simulate_secondary', line 457, column 28 to line 459, column 7)",
  " (in 'simulate_secondary', line 457, column 6 to line 461, column 7)",
  " (in 'simulate_secondary', line 455, column 11 to line 462, column 5)",
  " (in 'simulate_secondary', line 454, column 6 to column 29)",
  " (in 'simulate_secondary', line 453, column 27 to line 455, column 5)",
  " (in 'simulate_secondary', line 453, column 4 to line 462, column 5)",
  " (in 'simulate_secondary', line 452, column 17 to line 463, column 3)",
  " (in 'simulate_secondary', line 452, column 2 to line 463, column 3)",
  " (in 'simulate_secondary', line 464, column 2 to column 26)",
  " (in 'simulate_secondary', line 444, column 77 to line 465, column 1)",
  " (in 'simulate_secondary', line 471, column 2 to column 39)",
  " (in 'simulate_secondary', line 472, column 9 to column 10)",
  " (in 'simulate_secondary', line 472, column 2 to column 51)",
  " (in 'simulate_secondary', line 481, column 8 to column 42)",
  " (in 'simulate_secondary', line 480, column 11 to line 482, column 7)",
  " (in 'simulate_secondary', line 479, column 8 to column 56)",
  " (in 'simulate_secondary', line 478, column 23 to line 480, column 7)",
  " (in 'simulate_secondary', line 478, column 6 to line 482, column 7)",
  " (in 'simulate_secondary', line 477, column 29 to line 483, column 5)",
  " (in 'simulate_secondary', line 477, column 4 to line 483, column 5)",
  " (in 'simulate_secondary', line 489, column 8 to column 79)",
  " (in 'simulate_secondary', line 488, column 11 to line 490, column 7)",
  " (in 'simulate_secondary', line 487, column 8 to column 48)",
  " (in 'simulate_secondary', line 486, column 33 to line 488, column 7)",
  " (in 'simulate_secondary', line 486, column 6 to line 490, column 7)",
  " (in 'simulate_secondary', line 485, column 18 to line 491, column 5)",
  " (in 'simulate_secondary', line 485, column 4 to line 491, column 5)",
  " (in 'simulate_secondary', line 497, column 8 to column 50)",
  " (in 'simulate_secondary', line 496, column 11 to line 498, column 7)",
  " (in 'simulate_secondary', line 495, column 8 to column 50)",
  " (in 'simulate_secondary', line 494, column 36 to line 496, column 7)",
  " (in 'simulate_secondary', line 494, column 6 to line 498, column 7)",
  " (in 'simulate_secondary', line 493, column 17 to line 499, column 5)",
  " (in 'simulate_secondary', line 493, column 4 to line 499, column 5)",
  " (in 'simulate_secondary', line 500, column 4 to column 55)",
  " (in 'simulate_secondary', line 475, column 17 to line 501, column 3)",
  " (in 'simulate_secondary', line 475, column 2 to line 501, column 3)",
  " (in 'simulate_secondary', line 502, column 2 to column 28)",
  " (in 'simulate_secondary', line 470, column 83 to line 503, column 1)"};
std::vector<int>
calc_conv_indices_xlen(const int& s, const int& xlen, const int& ylen,
                       std::ostream* pstream__);
std::vector<int>
calc_conv_indices_len(const int& s, const int& xlen, const int& ylen,
                      std::ostream* pstream__);
template <typename T0__, typename T1__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>,
                stan::base_type_t<T1__>>,-1,1>
convolve_with_rev_pmf(const T0__& x_arg__, const T1__& y_arg__, const int&
                      len, std::ostream* pstream__);
template <typename T0__, typename T1__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>,
                stan::base_type_t<T1__>>,-1,1>
convolve_to_report(const T0__& infections_arg__, const T1__&
                   delay_rev_pmf_arg__, const int& seeding_time,
                   std::ostream* pstream__);
template <typename T0__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>>,-1,1>
discretised_pmf(const T0__& params_arg__, const int& n, const int& dist,
                std::ostream* pstream__);
std::vector<int>
get_delay_type_max(const int& delay_types, const std::vector<int>&
                   delay_types_p, const std::vector<int>& delay_types_id,
                   const std::vector<int>& delay_types_groups,
                   const std::vector<int>& delay_max, const std::vector<int>&
                   delay_np_pmf_groups, std::ostream* pstream__);
template <typename T6__, typename T8__,
          stan::require_all_t<stan::is_col_vector<T6__>,
                              stan::is_vt_not_complex<T6__>,
                              stan::is_col_vector<T8__>,
                              stan::is_vt_not_complex<T8__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T6__>,
                stan::base_type_t<T8__>>,-1,1>
get_delay_rev_pmf(const int& delay_id, const int& len,
                  const std::vector<int>& delay_types_p,
                  const std::vector<int>& delay_types_id,
                  const std::vector<int>& delay_types_groups,
                  const std::vector<int>& delay_max, const T6__&
                  delay_np_pmf_arg__, const std::vector<int>&
                  delay_np_pmf_groups, const T8__& delay_params_arg__,
                  const std::vector<int>& delay_params_groups,
                  const std::vector<int>& delay_dist, const int&
                  left_truncate, const int& reverse_pmf, const int&
                  cumulative, std::ostream* pstream__);
template <bool propto__, typename T0__, typename T1__, typename T2__,
          typename T_lp__, typename T_lp_accum__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>,
                              stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>>* = nullptr>
void
delays_lp(const T0__& delay_params_arg__, const T1__&
          delay_params_mean_arg__, const T2__& delay_params_sd_arg__,
          const std::vector<int>& delay_params_groups,
          const std::vector<int>& delay_dist, const std::vector<int>& weight,
          T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__);
template <typename T0__, typename T1__, typename T2__, typename RNG,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>,
                              stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>,
                stan::base_type_t<T1__>, stan::base_type_t<T2__>>,-1,1>
normal_lb_rng(const T0__& mu_arg__, const T1__& sigma_arg__, const T2__&
              lb_arg__, RNG& base_rng__, std::ostream* pstream__);
template <typename T0__, typename T2__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>,
                stan::base_type_t<T2__>>,-1,1>
day_of_week_effect(const T0__& reports_arg__, const std::vector<int>&
                   day_of_week, const T2__& effect_arg__, std::ostream*
                   pstream__);
template <typename T0__, typename T1__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_stan_scalar<T1__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>, T1__>,-1,1>
scale_obs(const T0__& reports_arg__, const T1__& frac_obs, std::ostream*
          pstream__);
template <typename T0__, typename T1__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>,
                stan::base_type_t<T1__>>,-1,1>
truncate_obs(const T0__& reports_arg__, const T1__& trunc_rev_cmf_arg__,
             const int& reconstruct, std::ostream* pstream__);
template <bool propto__, typename T0__, typename T1__, typename T2__,
          typename T3__, typename T4__, typename T5__, typename T_lp__,
          typename T_lp_accum__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>,
                              stan::is_stan_scalar<T3__>,
                              stan::is_stan_scalar<T4__>,
                              stan::is_stan_scalar<T5__>>* = nullptr>
void
truncation_lp(const std::vector<T0__>& truncation_mean,
              const std::vector<T1__>& truncation_sd,
              const std::vector<T2__>& trunc_mean_mean,
              const std::vector<T3__>& trunc_mean_sd,
              const std::vector<T4__>& trunc_sd_mean,
              const std::vector<T5__>& trunc_sd_sd, T_lp__& lp__,
              T_lp_accum__& lp_accum__, std::ostream* pstream__);
template <bool propto__, typename T2__, typename T3__, typename T4__,
          typename T5__, typename T7__, typename T_lp__,
          typename T_lp_accum__,
          stan::require_all_t<stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>,
                              stan::is_stan_scalar<T3__>,
                              stan::is_stan_scalar<T4__>,
                              stan::is_stan_scalar<T5__>,
                              stan::is_stan_scalar<T7__>>* = nullptr>
void
report_lp(const std::vector<int>& cases, const std::vector<int>& cases_time,
          const T2__& reports_arg__, const std::vector<T3__>& rep_phi,
          const T4__& phi_mean, const T5__& phi_sd, const int& model_type,
          const T7__& weight, const int& accumulate, T_lp__& lp__,
          T_lp_accum__& lp_accum__, std::ostream* pstream__);
template <typename T1__, typename T2__, typename T4__,
          stan::require_all_t<stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>,
                              stan::is_stan_scalar<T2__>,
                              stan::is_stan_scalar<T4__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T1__>, T2__, T4__>,-1,1>
report_log_lik(const std::vector<int>& cases, const T1__& reports_arg__,
               const std::vector<T2__>& rep_phi, const int& model_type,
               const T4__& weight, std::ostream* pstream__);
template <typename T0__, typename T1__, typename RNG,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_stan_scalar<T1__>>* = nullptr>
std::vector<int>
report_rng(const T0__& reports_arg__, const std::vector<T1__>& rep_phi,
           const int& model_type, RNG& base_rng__, std::ostream* pstream__);
template <typename T0__, typename T1__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>,
                stan::base_type_t<T1__>>,-1,1>
calculate_secondary(const T0__& scaled_reports_arg__, const T1__&
                    conv_reports_arg__, const std::vector<int>& obs,
                    const int& cumulative, const int& historic, const int&
                    primary_hist_additive, const int& current, const int&
                    primary_current_additive, const int& predict,
                    std::ostream* pstream__);
std::vector<int>
calc_conv_indices_xlen(const int& s, const int& xlen, const int& ylen,
                       std::ostream* pstream__) {
  using local_scalar_t__ = double;
  int current_statement__ = 0;
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int s_minus_ylen = std::numeric_limits<int>::min();
    current_statement__ = 94;
    s_minus_ylen = (s - ylen);
    int start_x = std::numeric_limits<int>::min();
    current_statement__ = 95;
    start_x = stan::math::max(1, (s_minus_ylen + 1));
    int end_x = std::numeric_limits<int>::min();
    current_statement__ = 96;
    end_x = s;
    int start_y = std::numeric_limits<int>::min();
    current_statement__ = 97;
    start_y = stan::math::max(1, (1 - s_minus_ylen));
    int end_y = std::numeric_limits<int>::min();
    current_statement__ = 98;
    end_y = ylen;
    current_statement__ = 99;
    return std::vector<int>{start_x, end_x, start_y, end_y};
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
std::vector<int>
calc_conv_indices_len(const int& s, const int& xlen, const int& ylen,
                      std::ostream* pstream__) {
  using local_scalar_t__ = double;
  int current_statement__ = 0;
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int s_minus_ylen = std::numeric_limits<int>::min();
    current_statement__ = 101;
    s_minus_ylen = (s - ylen);
    int start_x = std::numeric_limits<int>::min();
    current_statement__ = 102;
    start_x = stan::math::max(1, (s_minus_ylen + 1));
    int end_x = std::numeric_limits<int>::min();
    current_statement__ = 103;
    end_x = xlen;
    int start_y = std::numeric_limits<int>::min();
    current_statement__ = 104;
    start_y = stan::math::max(1, (1 - s_minus_ylen));
    ;
    int end_y = std::numeric_limits<int>::min();
    current_statement__ = 106;
    end_y = ((ylen + xlen) - s);
    current_statement__ = 107;
    return std::vector<int>{start_x, end_x, start_y, end_y};
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__, typename T1__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>,
                stan::base_type_t<T1__>>,-1,1>
convolve_with_rev_pmf(const T0__& x_arg__, const T1__& y_arg__, const int&
                      len, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>,
                             stan::base_type_t<T1__>>;
  int current_statement__ = 0;
  const auto& x = stan::math::to_ref(x_arg__);
  const auto& y = stan::math::to_ref(y_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int xlen = std::numeric_limits<int>::min();
    current_statement__ = 109;
    xlen = stan::math::num_elements(x);
    int ylen = std::numeric_limits<int>::min();
    current_statement__ = 110;
    ylen = stan::math::num_elements(y);
    current_statement__ = 111;
    stan::math::validate_non_negative_index("z", "len", len);
    Eigen::Matrix<local_scalar_t__,-1,1> z =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(len, DUMMY_VAR__);
    current_statement__ = 115;
    if (stan::math::logical_lt(((xlen + ylen) - 1), len)) {
      current_statement__ = 113;
      std::stringstream errmsg_stream__;
      stan::math::stan_print(&errmsg_stream__,
        "convolve_with_rev_pmf: len is longer than x and y convolved");
      throw std::domain_error(errmsg_stream__.str());
    }
    current_statement__ = 118;
    if (stan::math::logical_gt(xlen, len)) {
      current_statement__ = 116;
      std::stringstream errmsg_stream__;
      stan::math::stan_print(&errmsg_stream__,
        "convolve_with_rev_pmf: len is shorter than x");
      throw std::domain_error(errmsg_stream__.str());
    }
    current_statement__ = 122;
    for (int s = 1; s <= xlen; ++s) {
      std::vector<int> indices =
        std::vector<int>(4, std::numeric_limits<int>::min());
      current_statement__ = 119;
      stan::model::assign(indices,
        calc_conv_indices_xlen(s, xlen, ylen, pstream__),
        "assigning variable indices");
      current_statement__ = 120;
      stan::model::assign(z,
        stan::math::dot_product(
          stan::model::rvalue(x, "x",
            stan::model::index_min_max(
              stan::model::rvalue(indices, "indices",
                stan::model::index_uni(1)),
              stan::model::rvalue(indices, "indices",
                stan::model::index_uni(2)))),
          stan::model::rvalue(y, "y",
            stan::model::index_min_max(
              stan::model::rvalue(indices, "indices",
                stan::model::index_uni(3)),
              stan::model::rvalue(indices, "indices",
                stan::model::index_uni(4))))), "assigning variable z",
        stan::model::index_uni(s));
    }
    current_statement__ = 128;
    if (stan::math::logical_gt(len, xlen)) {
      current_statement__ = 126;
      for (int s = (xlen + 1); s <= len; ++s) {
        std::vector<int> indices =
          std::vector<int>(4, std::numeric_limits<int>::min());
        current_statement__ = 123;
        stan::model::assign(indices,
          calc_conv_indices_len(s, xlen, ylen, pstream__),
          "assigning variable indices");
        current_statement__ = 124;
        stan::model::assign(z,
          stan::math::dot_product(
            stan::model::rvalue(x, "x",
              stan::model::index_min_max(
                stan::model::rvalue(indices, "indices",
                  stan::model::index_uni(1)),
                stan::model::rvalue(indices, "indices",
                  stan::model::index_uni(2)))),
            stan::model::rvalue(y, "y",
              stan::model::index_min_max(
                stan::model::rvalue(indices, "indices",
                  stan::model::index_uni(3)),
                stan::model::rvalue(indices, "indices",
                  stan::model::index_uni(4))))), "assigning variable z",
          stan::model::index_uni(s));
      }
    }
    current_statement__ = 129;
    return z;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__, typename T1__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>,
                stan::base_type_t<T1__>>,-1,1>
convolve_to_report(const T0__& infections_arg__, const T1__&
                   delay_rev_pmf_arg__, const int& seeding_time,
                   std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>,
                             stan::base_type_t<T1__>>;
  int current_statement__ = 0;
  const auto& infections = stan::math::to_ref(infections_arg__);
  const auto& delay_rev_pmf = stan::math::to_ref(delay_rev_pmf_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int t = std::numeric_limits<int>::min();
    current_statement__ = 131;
    t = stan::math::num_elements(infections);
    int delays = std::numeric_limits<int>::min();
    current_statement__ = 132;
    delays = stan::math::num_elements(delay_rev_pmf);
    current_statement__ = 135;
    if (stan::math::logical_eq(delays, 0)) {
      current_statement__ = 133;
      return stan::model::rvalue(infections, "infections",
               stan::model::index_min_max((seeding_time + 1), t));
    }
    current_statement__ = 136;
    stan::math::validate_non_negative_index("unobs_reports", "t", t);
    Eigen::Matrix<local_scalar_t__,-1,1> unobs_reports =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(t, DUMMY_VAR__);
    current_statement__ = 137;
    stan::model::assign(unobs_reports,
      convolve_with_rev_pmf(infections, delay_rev_pmf, t, pstream__),
      "assigning variable unobs_reports");
    current_statement__ = 138;
    return stan::model::rvalue(unobs_reports, "unobs_reports",
             stan::model::index_min_max((seeding_time + 1), t));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>>,-1,1>
discretised_pmf(const T0__& params_arg__, const int& n, const int& dist,
                std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>>;
  int current_statement__ = 0;
  const auto& params = stan::math::to_ref(params_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 140;
    stan::math::validate_non_negative_index("lpmf", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,1> lpmf =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
    current_statement__ = 142;
    stan::math::validate_non_negative_index("upper_lcdf", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,1> upper_lcdf =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
    current_statement__ = 155;
    if (stan::math::logical_eq(dist, 0)) {
      current_statement__ = 153;
      for (int i = 1; i <= n; ++i) {
        current_statement__ = 151;
        stan::model::assign(upper_lcdf,
          stan::math::lognormal_lcdf(i,
            stan::model::rvalue(params, "params", stan::model::index_uni(1)),
            stan::model::rvalue(params, "params", stan::model::index_uni(2))),
          "assigning variable upper_lcdf", stan::model::index_uni(i));
      }
    } else {
      current_statement__ = 150;
      if (stan::math::logical_eq(dist, 1)) {
        current_statement__ = 148;
        for (int i = 1; i <= n; ++i) {
          current_statement__ = 146;
          stan::model::assign(upper_lcdf,
            stan::math::gamma_lcdf(i,
              stan::model::rvalue(params, "params", stan::model::index_uni(1)),
              stan::model::rvalue(params, "params", stan::model::index_uni(2))),
            "assigning variable upper_lcdf", stan::model::index_uni(i));
        }
      } else {
        current_statement__ = 144;
        std::stringstream errmsg_stream__;
        stan::math::stan_print(&errmsg_stream__,
          "Unknown distribution function provided.");
        throw std::domain_error(errmsg_stream__.str());
      }
    }
    current_statement__ = 165;
    if (stan::math::logical_gt(n, 1)) {
      current_statement__ = 158;
      stan::model::assign(lpmf,
        stan::model::rvalue(upper_lcdf, "upper_lcdf",
          stan::model::index_uni(1)), "assigning variable lpmf",
        stan::model::index_uni(1));
      current_statement__ = 159;
      stan::model::assign(lpmf,
        stan::model::rvalue(upper_lcdf, "upper_lcdf",
          stan::model::index_uni(2)), "assigning variable lpmf",
        stan::model::index_uni(2));
      current_statement__ = 162;
      if (stan::math::logical_gt(n, 2)) {
        current_statement__ = 160;
        stan::model::assign(lpmf,
          stan::math::log_diff_exp(
            stan::model::rvalue(upper_lcdf, "upper_lcdf",
              stan::model::index_min_max(3, n)),
            stan::model::rvalue(upper_lcdf, "upper_lcdf",
              stan::model::index_min_max(1, (n - 2)))),
          "assigning variable lpmf", stan::model::index_min_max(3, n));
      }
      current_statement__ = 163;
      stan::model::assign(lpmf,
        stan::math::subtract(stan::model::deep_copy(lpmf),
          stan::math::log_sum_exp(
            stan::model::rvalue(upper_lcdf, "upper_lcdf",
              stan::model::index_min_max((n - 1), n)))),
        "assigning variable lpmf");
    } else {
      current_statement__ = 156;
      stan::model::assign(lpmf, 0, "assigning variable lpmf",
        stan::model::index_uni(1));
    }
    current_statement__ = 166;
    return stan::math::exp(lpmf);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
std::vector<int>
get_delay_type_max(const int& delay_types, const std::vector<int>&
                   delay_types_p, const std::vector<int>& delay_types_id,
                   const std::vector<int>& delay_types_groups,
                   const std::vector<int>& delay_max, const std::vector<int>&
                   delay_np_pmf_groups, std::ostream* pstream__) {
  using local_scalar_t__ = double;
  int current_statement__ = 0;
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 168;
    stan::math::validate_non_negative_index("ret", "delay_types", delay_types);
    std::vector<int> ret =
      std::vector<int>(delay_types, std::numeric_limits<int>::min());
    current_statement__ = 179;
    for (int i = 1; i <= delay_types; ++i) {
      current_statement__ = 170;
      stan::model::assign(ret, 0, "assigning variable ret",
        stan::model::index_uni(i));
      current_statement__ = 177;
      for (int j =
             stan::model::rvalue(delay_types_groups, "delay_types_groups",
               stan::model::index_uni(i)); j <=
           (stan::model::rvalue(delay_types_groups, "delay_types_groups",
              stan::model::index_uni((i + 1))) - 1); ++j) {
        current_statement__ = 175;
        if (stan::model::rvalue(delay_types_p, "delay_types_p",
              stan::model::index_uni(j))) {
          current_statement__ = 173;
          stan::model::assign(ret,
            (stan::model::rvalue(ret, "ret", stan::model::index_uni(i)) +
            stan::model::rvalue(delay_max, "delay_max",
              stan::model::index_uni(
                stan::model::rvalue(delay_types_id, "delay_types_id",
                  stan::model::index_uni(j))))), "assigning variable ret",
            stan::model::index_uni(i));
        } else {
          current_statement__ = 171;
          stan::model::assign(ret,
            (stan::model::rvalue(ret, "ret", stan::model::index_uni(i)) +
            ((stan::model::rvalue(delay_np_pmf_groups, "delay_np_pmf_groups",
                stan::model::index_uni(
                  (stan::model::rvalue(delay_types_id, "delay_types_id",
                     stan::model::index_uni(j)) + 1))) -
            stan::model::rvalue(delay_np_pmf_groups, "delay_np_pmf_groups",
              stan::model::index_uni(
                stan::model::rvalue(delay_types_id, "delay_types_id",
                  stan::model::index_uni(j))))) - 1)),
            "assigning variable ret", stan::model::index_uni(i));
        }
      }
    }
    current_statement__ = 180;
    return ret;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T6__, typename T8__,
          stan::require_all_t<stan::is_col_vector<T6__>,
                              stan::is_vt_not_complex<T6__>,
                              stan::is_col_vector<T8__>,
                              stan::is_vt_not_complex<T8__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T6__>,
                stan::base_type_t<T8__>>,-1,1>
get_delay_rev_pmf(const int& delay_id, const int& len,
                  const std::vector<int>& delay_types_p,
                  const std::vector<int>& delay_types_id,
                  const std::vector<int>& delay_types_groups,
                  const std::vector<int>& delay_max, const T6__&
                  delay_np_pmf_arg__, const std::vector<int>&
                  delay_np_pmf_groups, const T8__& delay_params_arg__,
                  const std::vector<int>& delay_params_groups,
                  const std::vector<int>& delay_dist, const int&
                  left_truncate, const int& reverse_pmf, const int&
                  cumulative, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T6__>,
                             stan::base_type_t<T8__>>;
  int current_statement__ = 0;
  const auto& delay_np_pmf = stan::math::to_ref(delay_np_pmf_arg__);
  const auto& delay_params = stan::math::to_ref(delay_params_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 182;
    stan::math::validate_non_negative_index("pmf", "len", len);
    Eigen::Matrix<local_scalar_t__,-1,1> pmf =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(len, DUMMY_VAR__);
    current_statement__ = 183;
    stan::model::assign(pmf, stan::math::rep_vector(0, len),
      "assigning variable pmf");
    int current_len = std::numeric_limits<int>::min();
    current_statement__ = 184;
    current_len = 1;
    int new_len = std::numeric_limits<int>::min();
    current_statement__ = 209;
    for (int i =
           stan::model::rvalue(delay_types_groups, "delay_types_groups",
             stan::model::index_uni(delay_id)); i <=
         (stan::model::rvalue(delay_types_groups, "delay_types_groups",
            stan::model::index_uni((delay_id + 1))) - 1); ++i) {
      current_statement__ = 206;
      if (stan::model::rvalue(delay_types_p, "delay_types_p",
            stan::model::index_uni(i))) {
        int start = std::numeric_limits<int>::min();
        current_statement__ = 195;
        start = stan::model::rvalue(delay_params_groups,
                  "delay_params_groups",
                  stan::model::index_uni(
                    stan::model::rvalue(delay_types_id, "delay_types_id",
                      stan::model::index_uni(i))));
        int end = std::numeric_limits<int>::min();
        current_statement__ = 196;
        end = (stan::model::rvalue(delay_params_groups,
                 "delay_params_groups",
                 stan::model::index_uni(
                   (stan::model::rvalue(delay_types_id, "delay_types_id",
                      stan::model::index_uni(i)) + 1)))
          - 1);
        current_statement__ = 197;
        stan::math::validate_non_negative_index("new_variable_pmf",
          "delay_max[delay_types_id[i]] + 1",
          (stan::model::rvalue(delay_max, "delay_max",
             stan::model::index_uni(
               stan::model::rvalue(delay_types_id, "delay_types_id",
                 stan::model::index_uni(i)))) + 1));
        Eigen::Matrix<local_scalar_t__,-1,1> new_variable_pmf =
          Eigen::Matrix<local_scalar_t__,-1,1>::Constant((stan::model::rvalue(
                                                            delay_max,
                                                            "delay_max",
                                                            stan::model::index_uni(
                                                              stan::model::rvalue(
                                                                delay_types_id,
                                                                "delay_types_id",
                                                                stan::model::index_uni(
                                                                  i)))) + 1),
            DUMMY_VAR__);
        current_statement__ = 198;
        stan::model::assign(new_variable_pmf,
          discretised_pmf(
            stan::model::rvalue(delay_params, "delay_params",
              stan::model::index_min_max(start, end)),
            (stan::model::rvalue(delay_max, "delay_max",
               stan::model::index_uni(
                 stan::model::rvalue(delay_types_id, "delay_types_id",
                   stan::model::index_uni(i)))) + 1),
            stan::model::rvalue(delay_dist, "delay_dist",
              stan::model::index_uni(
                stan::model::rvalue(delay_types_id, "delay_types_id",
                  stan::model::index_uni(i)))), pstream__),
          "assigning variable new_variable_pmf");
        current_statement__ = 199;
        new_len = (current_len +
          stan::model::rvalue(delay_max, "delay_max",
            stan::model::index_uni(
              stan::model::rvalue(delay_types_id, "delay_types_id",
                stan::model::index_uni(i)))));
        current_statement__ = 204;
        if (stan::math::logical_eq(current_len, 1)) {
          current_statement__ = 202;
          stan::model::assign(pmf, new_variable_pmf,
            "assigning variable pmf", stan::model::index_min_max(1, new_len));
        } else {
          current_statement__ = 200;
          stan::model::assign(pmf,
            convolve_with_rev_pmf(
              stan::model::deep_copy(
                stan::model::rvalue(pmf, "pmf",
                  stan::model::index_min_max(1, current_len))),
              stan::math::reverse(new_variable_pmf), new_len, pstream__),
            "assigning variable pmf", stan::model::index_min_max(1, new_len));
        }
      } else {
        int start = std::numeric_limits<int>::min();
        current_statement__ = 186;
        start = stan::model::rvalue(delay_np_pmf_groups,
                  "delay_np_pmf_groups",
                  stan::model::index_uni(
                    stan::model::rvalue(delay_types_id, "delay_types_id",
                      stan::model::index_uni(i))));
        int end = std::numeric_limits<int>::min();
        current_statement__ = 187;
        end = (stan::model::rvalue(delay_np_pmf_groups,
                 "delay_np_pmf_groups",
                 stan::model::index_uni(
                   (stan::model::rvalue(delay_types_id, "delay_types_id",
                      stan::model::index_uni(i)) + 1)))
          - 1);
        current_statement__ = 188;
        new_len = ((current_len + end) - start);
        current_statement__ = 193;
        if (stan::math::logical_eq(current_len, 1)) {
          current_statement__ = 191;
          stan::model::assign(pmf,
            stan::model::rvalue(delay_np_pmf, "delay_np_pmf",
              stan::model::index_min_max(start, end)),
            "assigning variable pmf", stan::model::index_min_max(1, new_len));
        } else {
          current_statement__ = 189;
          stan::model::assign(pmf,
            convolve_with_rev_pmf(
              stan::model::deep_copy(
                stan::model::rvalue(pmf, "pmf",
                  stan::model::index_min_max(1, current_len))),
              stan::math::reverse(
                stan::model::rvalue(delay_np_pmf, "delay_np_pmf",
                  stan::model::index_min_max(start, end))), new_len,
              pstream__), "assigning variable pmf",
            stan::model::index_min_max(1, new_len));
        }
      }
      current_statement__ = 207;
      current_len = new_len;
    }
    current_statement__ = 212;
    if (left_truncate) {
      current_statement__ = 210;
      stan::model::assign(pmf,
        stan::math::append_row(stan::math::rep_vector(0, left_truncate),
          stan::math::divide(
            stan::model::deep_copy(
              stan::model::rvalue(pmf, "pmf",
                stan::model::index_min_max((left_truncate + 1), len))),
            stan::math::sum(
              stan::model::rvalue(pmf, "pmf",
                stan::model::index_min_max((left_truncate + 1), len))))),
        "assigning variable pmf");
    }
    current_statement__ = 215;
    if (cumulative) {
      current_statement__ = 213;
      stan::model::assign(pmf,
        stan::math::cumulative_sum(stan::model::deep_copy(pmf)),
        "assigning variable pmf");
    }
    current_statement__ = 218;
    if (reverse_pmf) {
      current_statement__ = 216;
      stan::model::assign(pmf,
        stan::math::reverse(stan::model::deep_copy(pmf)),
        "assigning variable pmf");
    }
    current_statement__ = 219;
    return pmf;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <bool propto__, typename T0__, typename T1__, typename T2__,
          typename T_lp__, typename T_lp_accum__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>,
                              stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>>*>
void
delays_lp(const T0__& delay_params_arg__, const T1__&
          delay_params_mean_arg__, const T2__& delay_params_sd_arg__,
          const std::vector<int>& delay_params_groups,
          const std::vector<int>& delay_dist, const std::vector<int>& weight,
          T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>,
                             stan::base_type_t<T1__>,
                             stan::base_type_t<T2__>>;
  int current_statement__ = 0;
  const auto& delay_params = stan::math::to_ref(delay_params_arg__);
  const auto& delay_params_mean = stan::math::to_ref(delay_params_mean_arg__);
  const auto& delay_params_sd = stan::math::to_ref(delay_params_sd_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int n_delays = std::numeric_limits<int>::min();
    current_statement__ = 221;
    n_delays = (stan::math::num_elements(delay_params_groups) - 1);
    current_statement__ = 224;
    if (stan::math::logical_eq(n_delays, 0)) {
      current_statement__ = 222;
      return ;
    }
    current_statement__ = 237;
    for (int d = 1; d <= n_delays; ++d) {
      int start = std::numeric_limits<int>::min();
      current_statement__ = 225;
      start = stan::model::rvalue(delay_params_groups, "delay_params_groups",
                stan::model::index_uni(d));
      int end = std::numeric_limits<int>::min();
      current_statement__ = 226;
      end = (stan::model::rvalue(delay_params_groups, "delay_params_groups",
               stan::model::index_uni((d + 1)))
        - 1);
      current_statement__ = 235;
      for (int s = start; s <= end; ++s) {
        current_statement__ = 233;
        if (stan::math::logical_gt(
              stan::model::rvalue(delay_params_sd, "delay_params_sd",
                stan::model::index_uni(s)), 0)) {
          current_statement__ = 231;
          if (stan::math::logical_gt(
                stan::model::rvalue(weight, "weight",
                  stan::model::index_uni(d)), 1)) {
            current_statement__ = 229;
            lp_accum__.add((stan::model::rvalue(weight, "weight",
                              stan::model::index_uni(d)) *
              stan::math::normal_lpdf<false>(
                stan::model::rvalue(delay_params, "delay_params",
                  stan::model::index_uni(s)),
                stan::model::rvalue(delay_params_mean, "delay_params_mean",
                  stan::model::index_uni(s)),
                stan::model::rvalue(delay_params_sd, "delay_params_sd",
                  stan::model::index_uni(s)))));
          } else {
            current_statement__ = 227;
            lp_accum__.add(stan::math::normal_lpdf<propto__>(
                             stan::model::rvalue(delay_params,
                               "delay_params", stan::model::index_uni(s)),
                             stan::model::rvalue(delay_params_mean,
                               "delay_params_mean", stan::model::index_uni(s)),
                             stan::model::rvalue(delay_params_sd,
                               "delay_params_sd", stan::model::index_uni(s))));
          }
        }
      }
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__, typename T1__, typename T2__, typename RNG,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>,
                              stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>,
                stan::base_type_t<T1__>, stan::base_type_t<T2__>>,-1,1>
normal_lb_rng(const T0__& mu_arg__, const T1__& sigma_arg__, const T2__&
              lb_arg__, RNG& base_rng__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>,
                             stan::base_type_t<T1__>,
                             stan::base_type_t<T2__>>;
  int current_statement__ = 0;
  const auto& mu = stan::math::to_ref(mu_arg__);
  const auto& sigma = stan::math::to_ref(sigma_arg__);
  const auto& lb = stan::math::to_ref(lb_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int len = std::numeric_limits<int>::min();
    current_statement__ = 239;
    len = stan::math::num_elements(mu);
    current_statement__ = 240;
    stan::math::validate_non_negative_index("ret", "len", len);
    Eigen::Matrix<local_scalar_t__,-1,1> ret =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(len, DUMMY_VAR__);
    current_statement__ = 246;
    for (int i = 1; i <= len; ++i) {
      local_scalar_t__ p = DUMMY_VAR__;
      current_statement__ = 242;
      p = stan::math::normal_cdf(
            stan::model::rvalue(lb, "lb", stan::model::index_uni(i)),
            stan::model::rvalue(mu, "mu", stan::model::index_uni(i)),
            stan::model::rvalue(sigma, "sigma", stan::model::index_uni(i)));
      local_scalar_t__ u = DUMMY_VAR__;
      current_statement__ = 243;
      u = stan::math::uniform_rng(p, 1, base_rng__);
      current_statement__ = 244;
      stan::model::assign(ret,
        ((stan::model::rvalue(sigma, "sigma", stan::model::index_uni(i)) *
        stan::math::inv_Phi(u)) +
        stan::model::rvalue(mu, "mu", stan::model::index_uni(i))),
        "assigning variable ret", stan::model::index_uni(i));
    }
    current_statement__ = 247;
    return ret;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__, typename T2__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>,
                stan::base_type_t<T2__>>,-1,1>
day_of_week_effect(const T0__& reports_arg__, const std::vector<int>&
                   day_of_week, const T2__& effect_arg__, std::ostream*
                   pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>,
                             stan::base_type_t<T2__>>;
  int current_statement__ = 0;
  const auto& reports = stan::math::to_ref(reports_arg__);
  const auto& effect = stan::math::to_ref(effect_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int wl = std::numeric_limits<int>::min();
    current_statement__ = 249;
    wl = stan::math::num_elements(effect);
    current_statement__ = 250;
    stan::math::validate_non_negative_index("scaled_effect", "wl", wl);
    Eigen::Matrix<local_scalar_t__,-1,1> scaled_effect =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(wl, DUMMY_VAR__);
    current_statement__ = 251;
    stan::model::assign(scaled_effect, stan::math::multiply(wl, effect),
      "assigning variable scaled_effect");
    current_statement__ = 252;
    return stan::math::elt_multiply(reports,
             stan::model::rvalue(scaled_effect, "scaled_effect",
               stan::model::index_multi(day_of_week)));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__, typename T1__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_stan_scalar<T1__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>, T1__>,-1,1>
scale_obs(const T0__& reports_arg__, const T1__& frac_obs, std::ostream*
          pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>,
                             T1__>;
  int current_statement__ = 0;
  const auto& reports = stan::math::to_ref(reports_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int t = std::numeric_limits<int>::min();
    current_statement__ = 254;
    t = stan::math::num_elements(reports);
    current_statement__ = 255;
    stan::math::validate_non_negative_index("scaled_reports", "t", t);
    Eigen::Matrix<local_scalar_t__,-1,1> scaled_reports =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(t, DUMMY_VAR__);
    current_statement__ = 257;
    stan::model::assign(scaled_reports,
      stan::math::multiply(reports, frac_obs),
      "assigning variable scaled_reports");
    current_statement__ = 258;
    return scaled_reports;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__, typename T1__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>,
                stan::base_type_t<T1__>>,-1,1>
truncate_obs(const T0__& reports_arg__, const T1__& trunc_rev_cmf_arg__,
             const int& reconstruct, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>,
                             stan::base_type_t<T1__>>;
  int current_statement__ = 0;
  const auto& reports = stan::math::to_ref(reports_arg__);
  const auto& trunc_rev_cmf = stan::math::to_ref(trunc_rev_cmf_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int t = std::numeric_limits<int>::min();
    current_statement__ = 260;
    t = stan::math::num_elements(reports);
    int trunc_max = std::numeric_limits<int>::min();
    current_statement__ = 261;
    trunc_max = stan::math::num_elements(trunc_rev_cmf);
    current_statement__ = 262;
    stan::math::validate_non_negative_index("trunc_reports", "t", t);
    Eigen::Matrix<local_scalar_t__,-1,1> trunc_reports =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(t, DUMMY_VAR__);
    current_statement__ = 263;
    stan::model::assign(trunc_reports, reports,
      "assigning variable trunc_reports");
    int joint_max = std::numeric_limits<int>::min();
    current_statement__ = 264;
    joint_max = stan::math::min(t, trunc_max);
    int first_t = std::numeric_limits<int>::min();
    current_statement__ = 265;
    first_t = ((t - joint_max) + 1);
    int first_trunc = std::numeric_limits<int>::min();
    current_statement__ = 266;
    first_trunc = ((trunc_max - joint_max) + 1);
    current_statement__ = 271;
    if (reconstruct) {
      current_statement__ = 269;
      stan::model::assign(trunc_reports,
        stan::math::elt_divide(
          stan::model::deep_copy(
            stan::model::rvalue(trunc_reports, "trunc_reports",
              stan::model::index_min_max(first_t, t))),
          stan::model::rvalue(trunc_rev_cmf, "trunc_rev_cmf",
            stan::model::index_min_max(first_trunc, trunc_max))),
        "assigning variable trunc_reports",
        stan::model::index_min_max(first_t, t));
    } else {
      current_statement__ = 267;
      stan::model::assign(trunc_reports,
        stan::math::elt_multiply(
          stan::model::deep_copy(
            stan::model::rvalue(trunc_reports, "trunc_reports",
              stan::model::index_min_max(first_t, t))),
          stan::model::rvalue(trunc_rev_cmf, "trunc_rev_cmf",
            stan::model::index_min_max(first_trunc, trunc_max))),
        "assigning variable trunc_reports",
        stan::model::index_min_max(first_t, t));
    }
    current_statement__ = 272;
    return trunc_reports;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <bool propto__, typename T0__, typename T1__, typename T2__,
          typename T3__, typename T4__, typename T5__, typename T_lp__,
          typename T_lp_accum__,
          stan::require_all_t<stan::is_stan_scalar<T0__>,
                              stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>,
                              stan::is_stan_scalar<T3__>,
                              stan::is_stan_scalar<T4__>,
                              stan::is_stan_scalar<T5__>>*>
void
truncation_lp(const std::vector<T0__>& truncation_mean,
              const std::vector<T1__>& truncation_sd,
              const std::vector<T2__>& trunc_mean_mean,
              const std::vector<T3__>& trunc_mean_sd,
              const std::vector<T4__>& trunc_sd_mean,
              const std::vector<T5__>& trunc_sd_sd, T_lp__& lp__,
              T_lp_accum__& lp_accum__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__, T2__, T3__, T4__,
                             stan::promote_args_t<T5__>>;
  int current_statement__ = 0;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int truncation = std::numeric_limits<int>::min();
    current_statement__ = 274;
    truncation = stan::math::num_elements(truncation_mean);
    current_statement__ = 282;
    if (truncation) {
      current_statement__ = 277;
      if (stan::math::logical_gt(
            stan::model::rvalue(trunc_mean_sd, "trunc_mean_sd",
              stan::model::index_uni(1)), 0)) {
        current_statement__ = 275;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(truncation_mean,
                         trunc_mean_mean, trunc_mean_sd));
      }
      current_statement__ = 280;
      if (stan::math::logical_gt(
            stan::model::rvalue(trunc_sd_sd, "trunc_sd_sd",
              stan::model::index_uni(1)), 0)) {
        current_statement__ = 278;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(truncation_sd,
                         trunc_sd_mean, trunc_sd_sd));
      }
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <bool propto__, typename T2__, typename T3__, typename T4__,
          typename T5__, typename T7__, typename T_lp__,
          typename T_lp_accum__,
          stan::require_all_t<stan::is_col_vector<T2__>,
                              stan::is_vt_not_complex<T2__>,
                              stan::is_stan_scalar<T3__>,
                              stan::is_stan_scalar<T4__>,
                              stan::is_stan_scalar<T5__>,
                              stan::is_stan_scalar<T7__>>*>
void
report_lp(const std::vector<int>& cases, const std::vector<int>& cases_time,
          const T2__& reports_arg__, const std::vector<T3__>& rep_phi,
          const T4__& phi_mean, const T5__& phi_sd, const int& model_type,
          const T7__& weight, const int& accumulate, T_lp__& lp__,
          T_lp_accum__& lp_accum__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T2__>,
                             T3__, T4__, T5__, T7__>;
  int current_statement__ = 0;
  const auto& reports = stan::math::to_ref(reports_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int n = std::numeric_limits<int>::min();
    current_statement__ = 284;
    n = (stan::math::num_elements(cases_time) - accumulate);
    current_statement__ = 285;
    stan::math::validate_non_negative_index("obs_reports", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,1> obs_reports =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n, DUMMY_VAR__);
    current_statement__ = 287;
    stan::math::validate_non_negative_index("obs_cases", "n", n);
    std::vector<int> obs_cases =
      std::vector<int>(n, std::numeric_limits<int>::min());
    current_statement__ = 307;
    if (accumulate) {
      int t = std::numeric_limits<int>::min();
      current_statement__ = 292;
      t = stan::math::num_elements(reports);
      int i = std::numeric_limits<int>::min();
      current_statement__ = 293;
      i = 0;
      int current_obs = std::numeric_limits<int>::min();
      current_statement__ = 294;
      current_obs = 0;
      current_statement__ = 295;
      stan::model::assign(obs_reports, stan::math::rep_vector(0, n),
        "assigning variable obs_reports");
      current_statement__ = 304;
      while ((stan::math::primitive_value(stan::math::logical_lte(i, t)) &&
             stan::math::primitive_value(
               stan::math::logical_lte(current_obs, n)))) {
        current_statement__ = 298;
        if (stan::math::logical_gt(current_obs, 0)) {
          current_statement__ = 296;
          stan::model::assign(obs_reports,
            (stan::model::rvalue(obs_reports, "obs_reports",
               stan::model::index_uni(current_obs)) +
            stan::model::rvalue(reports, "reports", stan::model::index_uni(i))),
            "assigning variable obs_reports",
            stan::model::index_uni(current_obs));
        }
        current_statement__ = 301;
        if (stan::math::logical_eq(i,
              stan::model::rvalue(cases_time, "cases_time",
                stan::model::index_uni((current_obs + 1))))) {
          current_statement__ = 299;
          current_obs = (current_obs + 1);
        }
        current_statement__ = 302;
        i = (i + 1);
      }
      current_statement__ = 305;
      stan::model::assign(obs_cases,
        stan::model::rvalue(cases, "cases",
          stan::model::index_min_max(2, (n + 1))),
        "assigning variable obs_cases");
    } else {
      current_statement__ = 289;
      stan::model::assign(obs_reports,
        stan::model::rvalue(reports, "reports",
          stan::model::index_multi(cases_time)),
        "assigning variable obs_reports");
      current_statement__ = 290;
      stan::model::assign(obs_cases, cases, "assigning variable obs_cases");
    }
    current_statement__ = 325;
    if (model_type) {
      local_scalar_t__ dispersion = DUMMY_VAR__;
      current_statement__ = 314;
      dispersion = stan::math::inv_square(
                     (stan::math::logical_gt(phi_sd, 0) ? stan::model::rvalue(
                                                            rep_phi,
                                                            "rep_phi",
                                                            stan::model::index_uni(
                                                              model_type)) : phi_mean));
      current_statement__ = 318;
      if (stan::math::logical_gt(phi_sd, 0)) {
        current_statement__ = 315;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(
                         stan::model::rvalue(rep_phi, "rep_phi",
                           stan::model::index_uni(model_type)), phi_mean,
                         phi_sd));
        current_statement__ = 316;
        if (stan::math::logical_lt(
              stan::model::rvalue(rep_phi, "rep_phi",
                stan::model::index_uni(model_type)), 0)) {
          current_statement__ = 316;
          lp_accum__.add(stan::math::negative_infinity());
        } else {
          current_statement__ = 316;
          lp_accum__.add(-stan::math::normal_lccdf(0, phi_mean, phi_sd));
        }
      }
      current_statement__ = 323;
      if (stan::math::logical_eq(weight, 1)) {
        current_statement__ = 321;
        lp_accum__.add(stan::math::neg_binomial_2_lpmf<propto__>(obs_cases,
                         obs_reports, dispersion));
      } else {
        current_statement__ = 319;
        lp_accum__.add((stan::math::neg_binomial_2_lpmf<false>(obs_cases,
                          obs_reports, dispersion) * weight));
      }
    } else {
      current_statement__ = 312;
      if (stan::math::logical_eq(weight, 1)) {
        current_statement__ = 310;
        lp_accum__.add(stan::math::poisson_lpmf<propto__>(obs_cases,
                         obs_reports));
      } else {
        current_statement__ = 308;
        lp_accum__.add((stan::math::poisson_lpmf<false>(obs_cases,
                          obs_reports) * weight));
      }
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T1__, typename T2__, typename T4__,
          stan::require_all_t<stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>,
                              stan::is_stan_scalar<T2__>,
                              stan::is_stan_scalar<T4__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T1__>, T2__, T4__>,-1,1>
report_log_lik(const std::vector<int>& cases, const T1__& reports_arg__,
               const std::vector<T2__>& rep_phi, const int& model_type,
               const T4__& weight, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T1__>,
                             T2__, T4__>;
  int current_statement__ = 0;
  const auto& reports = stan::math::to_ref(reports_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int t = std::numeric_limits<int>::min();
    current_statement__ = 327;
    t = stan::math::num_elements(reports);
    current_statement__ = 328;
    stan::math::validate_non_negative_index("log_lik", "t", t);
    Eigen::Matrix<local_scalar_t__,-1,1> log_lik =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(t, DUMMY_VAR__);
    current_statement__ = 339;
    if (stan::math::logical_eq(model_type, 0)) {
      current_statement__ = 337;
      for (int i = 1; i <= t; ++i) {
        current_statement__ = 335;
        stan::model::assign(log_lik,
          (stan::math::poisson_lpmf<false>(
             stan::model::rvalue(cases, "cases", stan::model::index_uni(i)),
             stan::model::rvalue(reports, "reports",
               stan::model::index_uni(i))) * weight),
          "assigning variable log_lik", stan::model::index_uni(i));
      }
    } else {
      local_scalar_t__ dispersion = DUMMY_VAR__;
      current_statement__ = 330;
      dispersion = stan::math::inv_square(
                     stan::model::rvalue(rep_phi, "rep_phi",
                       stan::model::index_uni(model_type)));
      current_statement__ = 333;
      for (int i = 1; i <= t; ++i) {
        current_statement__ = 331;
        stan::model::assign(log_lik,
          (stan::math::neg_binomial_2_lpmf<false>(
             stan::model::rvalue(cases, "cases", stan::model::index_uni(i)),
             stan::model::rvalue(reports, "reports",
               stan::model::index_uni(i)), dispersion) * weight),
          "assigning variable log_lik", stan::model::index_uni(i));
      }
    }
    current_statement__ = 340;
    return log_lik;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__, typename T1__, typename RNG,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_stan_scalar<T1__>>*>
std::vector<int>
report_rng(const T0__& reports_arg__, const std::vector<T1__>& rep_phi,
           const int& model_type, RNG& base_rng__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>,
                             T1__>;
  int current_statement__ = 0;
  const auto& reports = stan::math::to_ref(reports_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int t = std::numeric_limits<int>::min();
    current_statement__ = 342;
    t = stan::math::num_elements(reports);
    current_statement__ = 343;
    stan::math::validate_non_negative_index("sampled_reports", "t", t);
    std::vector<int> sampled_reports =
      std::vector<int>(t, std::numeric_limits<int>::min());
    local_scalar_t__ dispersion = DUMMY_VAR__;
    current_statement__ = 345;
    dispersion = 1e5;
    current_statement__ = 348;
    if (model_type) {
      current_statement__ = 346;
      dispersion = stan::math::inv_square(
                     stan::model::rvalue(rep_phi, "rep_phi",
                       stan::model::index_uni(model_type)));
    }
    current_statement__ = 359;
    for (int s = 1; s <= t; ++s) {
      current_statement__ = 357;
      if (stan::math::logical_lt(
            stan::model::rvalue(reports, "reports", stan::model::index_uni(s)),
            1e-8)) {
        current_statement__ = 355;
        stan::model::assign(sampled_reports, 0,
          "assigning variable sampled_reports", stan::model::index_uni(s));
      } else {
        current_statement__ = 353;
        if (stan::math::logical_gt(dispersion, 1e4)) {
          current_statement__ = 351;
          stan::model::assign(sampled_reports,
            stan::math::poisson_rng(
              (stan::math::logical_gt(
                 stan::model::rvalue(reports, "reports",
                   stan::model::index_uni(s)), 1e8) ? 1e8 : stan::model::rvalue(
                                                              reports,
                                                              "reports",
                                                              stan::model::index_uni(
                                                                s))),
              base_rng__), "assigning variable sampled_reports",
            stan::model::index_uni(s));
        } else {
          current_statement__ = 349;
          stan::model::assign(sampled_reports,
            stan::math::neg_binomial_2_rng(
              (stan::math::logical_gt(
                 stan::model::rvalue(reports, "reports",
                   stan::model::index_uni(s)), 1e8) ? 1e8 : stan::model::rvalue(
                                                              reports,
                                                              "reports",
                                                              stan::model::index_uni(
                                                                s))),
              dispersion, base_rng__), "assigning variable sampled_reports",
            stan::model::index_uni(s));
        }
      }
    }
    current_statement__ = 360;
    return sampled_reports;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__, typename T1__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>,
                              stan::is_col_vector<T1__>,
                              stan::is_vt_not_complex<T1__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>,
                stan::base_type_t<T1__>>,-1,1>
calculate_secondary(const T0__& scaled_reports_arg__, const T1__&
                    conv_reports_arg__, const std::vector<int>& obs,
                    const int& cumulative, const int& historic, const int&
                    primary_hist_additive, const int& current, const int&
                    primary_current_additive, const int& predict,
                    std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>,
                             stan::base_type_t<T1__>>;
  int current_statement__ = 0;
  const auto& scaled_reports = stan::math::to_ref(scaled_reports_arg__);
  const auto& conv_reports = stan::math::to_ref(conv_reports_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    int t = std::numeric_limits<int>::min();
    current_statement__ = 362;
    t = stan::math::num_elements(scaled_reports);
    current_statement__ = 363;
    stan::math::validate_non_negative_index("secondary_reports", "t", t);
    Eigen::Matrix<local_scalar_t__,-1,1> secondary_reports =
      Eigen::Matrix<local_scalar_t__,-1,1>::Constant(t, DUMMY_VAR__);
    current_statement__ = 364;
    stan::model::assign(secondary_reports, stan::math::rep_vector(0.0, t),
      "assigning variable secondary_reports");
    current_statement__ = 388;
    for (int i = 1; i <= t; ++i) {
      current_statement__ = 371;
      if ((stan::math::primitive_value(cumulative) &&
          stan::math::primitive_value(stan::math::logical_gt(i, 1)))) {
        current_statement__ = 369;
        if (stan::math::logical_gt(i, predict)) {
          current_statement__ = 367;
          stan::model::assign(secondary_reports,
            stan::model::rvalue(secondary_reports, "secondary_reports",
              stan::model::index_uni((i - 1))),
            "assigning variable secondary_reports", stan::model::index_uni(i));
        } else {
          current_statement__ = 365;
          stan::model::assign(secondary_reports,
            stan::model::rvalue(obs, "obs", stan::model::index_uni((i - 1))),
            "assigning variable secondary_reports", stan::model::index_uni(i));
        }
      }
      current_statement__ = 378;
      if (historic) {
        current_statement__ = 376;
        if (primary_hist_additive) {
          current_statement__ = 374;
          stan::model::assign(secondary_reports,
            (stan::model::rvalue(secondary_reports, "secondary_reports",
               stan::model::index_uni(i)) +
            stan::model::rvalue(conv_reports, "conv_reports",
              stan::model::index_uni(i))),
            "assigning variable secondary_reports", stan::model::index_uni(i));
        } else {
          current_statement__ = 372;
          stan::model::assign(secondary_reports,
            stan::math::fmax(0,
              (stan::model::rvalue(secondary_reports, "secondary_reports",
                 stan::model::index_uni(i)) -
              stan::model::rvalue(conv_reports, "conv_reports",
                stan::model::index_uni(i)))),
            "assigning variable secondary_reports", stan::model::index_uni(i));
        }
      }
      current_statement__ = 385;
      if (current) {
        current_statement__ = 383;
        if (primary_current_additive) {
          current_statement__ = 381;
          stan::model::assign(secondary_reports,
            (stan::model::rvalue(secondary_reports, "secondary_reports",
               stan::model::index_uni(i)) +
            stan::model::rvalue(scaled_reports, "scaled_reports",
              stan::model::index_uni(i))),
            "assigning variable secondary_reports", stan::model::index_uni(i));
        } else {
          current_statement__ = 379;
          stan::model::assign(secondary_reports,
            (stan::model::rvalue(secondary_reports, "secondary_reports",
               stan::model::index_uni(i)) -
            stan::model::rvalue(scaled_reports, "scaled_reports",
              stan::model::index_uni(i))),
            "assigning variable secondary_reports", stan::model::index_uni(i));
        }
      }
      current_statement__ = 386;
      stan::model::assign(secondary_reports, (1e-6 +
        stan::model::rvalue(secondary_reports, "secondary_reports",
          stan::model::index_uni(i))),
        "assigning variable secondary_reports", stan::model::index_uni(i));
    }
    current_statement__ = 389;
    return secondary_reports;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
#include <stan_meta_header.hpp>
class model_simulate_secondary final : public model_base_crtp<model_simulate_secondary> {
private:
  int n;
  int t;
  int h;
  int all_dates;
  std::vector<int> obs;
  Eigen::Matrix<double,-1,-1> primary_data__;
  int seeding_time;
  int cumulative;
  int historic;
  int primary_hist_additive;
  int current;
  int primary_current_additive;
  int delay_n;
  int delay_n_p;
  int delay_n_np;
  std::vector<int> delay_max;
  std::vector<int> delay_dist;
  int delay_np_pmf_length;
  Eigen::Matrix<double,-1,1> delay_np_pmf_data__;
  std::vector<int> delay_np_pmf_groups;
  std::vector<int> delay_weight;
  int delay_params_length;
  std::vector<Eigen::Matrix<double,-1,1>> delay_params;
  std::vector<int> delay_params_groups;
  int delay_types;
  std::vector<int> delay_types_p;
  std::vector<int> delay_types_id;
  std::vector<int> delay_types_groups;
  int delay_id;
  std::vector<int> day_of_week;
  int week_effect;
  std::vector<std::vector<double>> day_of_week_simplex;
  int obs_scale;
  std::vector<std::vector<double>> frac_obs;
  int model_type;
  std::vector<std::vector<double>> rep_phi;
  int trunc_id;
  std::vector<int> delay_type_max;
  int sim_secondary_2dim__;
  Eigen::Map<Eigen::Matrix<double,-1,-1>> primary{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> delay_np_pmf{nullptr, 0};
public:
  ~model_simulate_secondary() {}
  model_simulate_secondary(stan::io::var_context& context__, unsigned int
                           random_seed__ = 0, std::ostream*
                           pstream__ = nullptr) : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_simulate_secondary_namespace::model_simulate_secondary";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 32;
      context__.validate_dims("data initialization", "n", "int",
        std::vector<size_t>{});
      n = std::numeric_limits<int>::min();
      current_statement__ = 32;
      n = context__.vals_i("n")[(1 - 1)];
      current_statement__ = 33;
      context__.validate_dims("data initialization", "t", "int",
        std::vector<size_t>{});
      t = std::numeric_limits<int>::min();
      current_statement__ = 33;
      t = context__.vals_i("t")[(1 - 1)];
      current_statement__ = 34;
      context__.validate_dims("data initialization", "h", "int",
        std::vector<size_t>{});
      h = std::numeric_limits<int>::min();
      current_statement__ = 34;
      h = context__.vals_i("h")[(1 - 1)];
      current_statement__ = 35;
      context__.validate_dims("data initialization", "all_dates", "int",
        std::vector<size_t>{});
      all_dates = std::numeric_limits<int>::min();
      current_statement__ = 35;
      all_dates = context__.vals_i("all_dates")[(1 - 1)];
      current_statement__ = 36;
      stan::math::validate_non_negative_index("obs", "t - h", (t - h));
      current_statement__ = 37;
      context__.validate_dims("data initialization", "obs", "int",
        std::vector<size_t>{static_cast<size_t>((t - h))});
      obs = std::vector<int>((t - h), std::numeric_limits<int>::min());
      current_statement__ = 37;
      obs = context__.vals_i("obs");
      current_statement__ = 37;
      stan::math::check_greater_or_equal(function__, "obs", obs, 0);
      current_statement__ = 38;
      stan::math::validate_non_negative_index("primary", "n", n);
      current_statement__ = 39;
      stan::math::validate_non_negative_index("primary", "t", t);
      current_statement__ = 40;
      context__.validate_dims("data initialization", "primary", "double",
        std::vector<size_t>{static_cast<size_t>(n), static_cast<size_t>(t)});
      primary_data__ = Eigen::Matrix<double,-1,-1>::Constant(n, t,
                         std::numeric_limits<double>::quiet_NaN());
      new (&primary)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(primary_data__.data(), n, t);
      {
        std::vector<local_scalar_t__> primary_flat__;
        current_statement__ = 40;
        primary_flat__ = context__.vals_r("primary");
        current_statement__ = 40;
        pos__ = 1;
        current_statement__ = 40;
        for (int sym1__ = 1; sym1__ <= t; ++sym1__) {
          current_statement__ = 40;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 40;
            stan::model::assign(primary, primary_flat__[(pos__ - 1)],
              "assigning variable primary", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 40;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 41;
      context__.validate_dims("data initialization", "seeding_time", "int",
        std::vector<size_t>{});
      seeding_time = std::numeric_limits<int>::min();
      current_statement__ = 41;
      seeding_time = context__.vals_i("seeding_time")[(1 - 1)];
      current_statement__ = 42;
      context__.validate_dims("data initialization", "cumulative", "int",
        std::vector<size_t>{});
      cumulative = std::numeric_limits<int>::min();
      current_statement__ = 42;
      cumulative = context__.vals_i("cumulative")[(1 - 1)];
      current_statement__ = 43;
      context__.validate_dims("data initialization", "historic", "int",
        std::vector<size_t>{});
      historic = std::numeric_limits<int>::min();
      current_statement__ = 43;
      historic = context__.vals_i("historic")[(1 - 1)];
      current_statement__ = 44;
      context__.validate_dims("data initialization", "primary_hist_additive",
        "int", std::vector<size_t>{});
      primary_hist_additive = std::numeric_limits<int>::min();
      current_statement__ = 44;
      primary_hist_additive = context__.vals_i("primary_hist_additive")[(1 -
        1)];
      current_statement__ = 45;
      context__.validate_dims("data initialization", "current", "int",
        std::vector<size_t>{});
      current = std::numeric_limits<int>::min();
      current_statement__ = 45;
      current = context__.vals_i("current")[(1 - 1)];
      current_statement__ = 46;
      context__.validate_dims("data initialization",
        "primary_current_additive", "int", std::vector<size_t>{});
      primary_current_additive = std::numeric_limits<int>::min();
      current_statement__ = 46;
      primary_current_additive = context__.vals_i("primary_current_additive")[(1
        - 1)];
      current_statement__ = 47;
      context__.validate_dims("data initialization", "delay_n", "int",
        std::vector<size_t>{});
      delay_n = std::numeric_limits<int>::min();
      current_statement__ = 47;
      delay_n = context__.vals_i("delay_n")[(1 - 1)];
      current_statement__ = 47;
      stan::math::check_greater_or_equal(function__, "delay_n", delay_n, 0);
      current_statement__ = 48;
      context__.validate_dims("data initialization", "delay_n_p", "int",
        std::vector<size_t>{});
      delay_n_p = std::numeric_limits<int>::min();
      current_statement__ = 48;
      delay_n_p = context__.vals_i("delay_n_p")[(1 - 1)];
      current_statement__ = 48;
      stan::math::check_greater_or_equal(function__, "delay_n_p", delay_n_p,
        0);
      current_statement__ = 49;
      context__.validate_dims("data initialization", "delay_n_np", "int",
        std::vector<size_t>{});
      delay_n_np = std::numeric_limits<int>::min();
      current_statement__ = 49;
      delay_n_np = context__.vals_i("delay_n_np")[(1 - 1)];
      current_statement__ = 49;
      stan::math::check_greater_or_equal(function__, "delay_n_np",
        delay_n_np, 0);
      current_statement__ = 50;
      stan::math::validate_non_negative_index("delay_max", "delay_n_p",
        delay_n_p);
      current_statement__ = 51;
      context__.validate_dims("data initialization", "delay_max", "int",
        std::vector<size_t>{static_cast<size_t>(delay_n_p)});
      delay_max = std::vector<int>(delay_n_p,
                    std::numeric_limits<int>::min());
      current_statement__ = 51;
      delay_max = context__.vals_i("delay_max");
      current_statement__ = 51;
      stan::math::check_greater_or_equal(function__, "delay_max", delay_max,
        1);
      current_statement__ = 52;
      stan::math::validate_non_negative_index("delay_dist", "delay_n_p",
        delay_n_p);
      current_statement__ = 53;
      context__.validate_dims("data initialization", "delay_dist", "int",
        std::vector<size_t>{static_cast<size_t>(delay_n_p)});
      delay_dist = std::vector<int>(delay_n_p,
                     std::numeric_limits<int>::min());
      current_statement__ = 53;
      delay_dist = context__.vals_i("delay_dist");
      current_statement__ = 53;
      stan::math::check_greater_or_equal(function__, "delay_dist",
        delay_dist, 0);
      current_statement__ = 54;
      context__.validate_dims("data initialization", "delay_np_pmf_length",
        "int", std::vector<size_t>{});
      delay_np_pmf_length = std::numeric_limits<int>::min();
      current_statement__ = 54;
      delay_np_pmf_length = context__.vals_i("delay_np_pmf_length")[(1 - 1)];
      current_statement__ = 54;
      stan::math::check_greater_or_equal(function__, "delay_np_pmf_length",
        delay_np_pmf_length, 0);
      current_statement__ = 55;
      stan::math::validate_non_negative_index("delay_np_pmf",
        "delay_np_pmf_length", delay_np_pmf_length);
      current_statement__ = 56;
      context__.validate_dims("data initialization", "delay_np_pmf",
        "double",
        std::vector<size_t>{static_cast<size_t>(delay_np_pmf_length)});
      delay_np_pmf_data__ = Eigen::Matrix<double,-1,1>::Constant(delay_np_pmf_length,
                              std::numeric_limits<double>::quiet_NaN());
      new (&delay_np_pmf)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(delay_np_pmf_data__.data(),
        delay_np_pmf_length);
      {
        std::vector<local_scalar_t__> delay_np_pmf_flat__;
        current_statement__ = 56;
        delay_np_pmf_flat__ = context__.vals_r("delay_np_pmf");
        current_statement__ = 56;
        pos__ = 1;
        current_statement__ = 56;
        for (int sym1__ = 1; sym1__ <= delay_np_pmf_length; ++sym1__) {
          current_statement__ = 56;
          stan::model::assign(delay_np_pmf, delay_np_pmf_flat__[(pos__ - 1)],
            "assigning variable delay_np_pmf", stan::model::index_uni(sym1__));
          current_statement__ = 56;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 56;
      stan::math::check_greater_or_equal(function__, "delay_np_pmf",
        delay_np_pmf, 0);
      current_statement__ = 56;
      stan::math::check_less_or_equal(function__, "delay_np_pmf",
        delay_np_pmf, 1);
      current_statement__ = 57;
      stan::math::validate_non_negative_index("delay_np_pmf_groups",
        "delay_n_np + 1", (delay_n_np + 1));
      current_statement__ = 58;
      context__.validate_dims("data initialization", "delay_np_pmf_groups",
        "int", std::vector<size_t>{static_cast<size_t>((delay_n_np + 1))});
      delay_np_pmf_groups = std::vector<int>((delay_n_np + 1),
                              std::numeric_limits<int>::min());
      current_statement__ = 58;
      delay_np_pmf_groups = context__.vals_i("delay_np_pmf_groups");
      current_statement__ = 58;
      stan::math::check_greater_or_equal(function__, "delay_np_pmf_groups",
        delay_np_pmf_groups, 1);
      current_statement__ = 59;
      stan::math::validate_non_negative_index("delay_weight", "delay_n_p",
        delay_n_p);
      current_statement__ = 60;
      context__.validate_dims("data initialization", "delay_weight", "int",
        std::vector<size_t>{static_cast<size_t>(delay_n_p)});
      delay_weight = std::vector<int>(delay_n_p,
                       std::numeric_limits<int>::min());
      current_statement__ = 60;
      delay_weight = context__.vals_i("delay_weight");
      current_statement__ = 61;
      context__.validate_dims("data initialization", "delay_params_length",
        "int", std::vector<size_t>{});
      delay_params_length = std::numeric_limits<int>::min();
      current_statement__ = 61;
      delay_params_length = context__.vals_i("delay_params_length")[(1 - 1)];
      current_statement__ = 61;
      stan::math::check_greater_or_equal(function__, "delay_params_length",
        delay_params_length, 0);
      current_statement__ = 62;
      stan::math::validate_non_negative_index("delay_params", "n", n);
      current_statement__ = 63;
      stan::math::validate_non_negative_index("delay_params",
        "delay_params_length", delay_params_length);
      current_statement__ = 64;
      context__.validate_dims("data initialization", "delay_params",
        "double",
        std::vector<size_t>{static_cast<size_t>(n),
          static_cast<size_t>(delay_params_length)});
      delay_params = std::vector<Eigen::Matrix<double,-1,1>>(n,
                       Eigen::Matrix<double,-1,1>::Constant(delay_params_length,
                         std::numeric_limits<double>::quiet_NaN()));
      {
        std::vector<local_scalar_t__> delay_params_flat__;
        current_statement__ = 64;
        delay_params_flat__ = context__.vals_r("delay_params");
        current_statement__ = 64;
        pos__ = 1;
        current_statement__ = 64;
        for (int sym1__ = 1; sym1__ <= delay_params_length; ++sym1__) {
          current_statement__ = 64;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 64;
            stan::model::assign(delay_params, delay_params_flat__[(pos__ -
              1)], "assigning variable delay_params",
              stan::model::index_uni(sym2__), stan::model::index_uni(sym1__));
            current_statement__ = 64;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 65;
      stan::math::validate_non_negative_index("delay_params_groups",
        "delay_n_p + 1", (delay_n_p + 1));
      current_statement__ = 66;
      context__.validate_dims("data initialization", "delay_params_groups",
        "int", std::vector<size_t>{static_cast<size_t>((delay_n_p + 1))});
      delay_params_groups = std::vector<int>((delay_n_p + 1),
                              std::numeric_limits<int>::min());
      current_statement__ = 66;
      delay_params_groups = context__.vals_i("delay_params_groups");
      current_statement__ = 66;
      stan::math::check_greater_or_equal(function__, "delay_params_groups",
        delay_params_groups, 0);
      current_statement__ = 67;
      context__.validate_dims("data initialization", "delay_types", "int",
        std::vector<size_t>{});
      delay_types = std::numeric_limits<int>::min();
      current_statement__ = 67;
      delay_types = context__.vals_i("delay_types")[(1 - 1)];
      current_statement__ = 67;
      stan::math::check_greater_or_equal(function__, "delay_types",
        delay_types, 0);
      current_statement__ = 68;
      stan::math::validate_non_negative_index("delay_types_p", "delay_n",
        delay_n);
      current_statement__ = 69;
      context__.validate_dims("data initialization", "delay_types_p", "int",
        std::vector<size_t>{static_cast<size_t>(delay_n)});
      delay_types_p = std::vector<int>(delay_n,
                        std::numeric_limits<int>::min());
      current_statement__ = 69;
      delay_types_p = context__.vals_i("delay_types_p");
      current_statement__ = 69;
      stan::math::check_greater_or_equal(function__, "delay_types_p",
        delay_types_p, 0);
      current_statement__ = 70;
      stan::math::validate_non_negative_index("delay_types_id", "delay_n",
        delay_n);
      current_statement__ = 71;
      context__.validate_dims("data initialization", "delay_types_id", "int",
        std::vector<size_t>{static_cast<size_t>(delay_n)});
      delay_types_id = std::vector<int>(delay_n,
                         std::numeric_limits<int>::min());
      current_statement__ = 71;
      delay_types_id = context__.vals_i("delay_types_id");
      current_statement__ = 71;
      stan::math::check_greater_or_equal(function__, "delay_types_id",
        delay_types_id, 0);
      current_statement__ = 72;
      stan::math::validate_non_negative_index("delay_types_groups",
        "delay_types + 1", (delay_types + 1));
      current_statement__ = 73;
      context__.validate_dims("data initialization", "delay_types_groups",
        "int", std::vector<size_t>{static_cast<size_t>((delay_types + 1))});
      delay_types_groups = std::vector<int>((delay_types + 1),
                             std::numeric_limits<int>::min());
      current_statement__ = 73;
      delay_types_groups = context__.vals_i("delay_types_groups");
      current_statement__ = 73;
      stan::math::check_greater_or_equal(function__, "delay_types_groups",
        delay_types_groups, 0);
      current_statement__ = 74;
      context__.validate_dims("data initialization", "delay_id", "int",
        std::vector<size_t>{});
      delay_id = std::numeric_limits<int>::min();
      current_statement__ = 74;
      delay_id = context__.vals_i("delay_id")[(1 - 1)];
      current_statement__ = 74;
      stan::math::check_greater_or_equal(function__, "delay_id", delay_id, 0);
      current_statement__ = 75;
      stan::math::validate_non_negative_index("day_of_week",
        "t - seeding_time", (t - seeding_time));
      current_statement__ = 76;
      context__.validate_dims("data initialization", "day_of_week", "int",
        std::vector<size_t>{static_cast<size_t>((t - seeding_time))});
      day_of_week = std::vector<int>((t - seeding_time),
                      std::numeric_limits<int>::min());
      current_statement__ = 76;
      day_of_week = context__.vals_i("day_of_week");
      current_statement__ = 77;
      context__.validate_dims("data initialization", "week_effect", "int",
        std::vector<size_t>{});
      week_effect = std::numeric_limits<int>::min();
      current_statement__ = 77;
      week_effect = context__.vals_i("week_effect")[(1 - 1)];
      current_statement__ = 78;
      stan::math::validate_non_negative_index("day_of_week_simplex", "n", n);
      current_statement__ = 79;
      stan::math::validate_non_negative_index("day_of_week_simplex",
        "week_effect", week_effect);
      current_statement__ = 80;
      context__.validate_dims("data initialization", "day_of_week_simplex",
        "double",
        std::vector<size_t>{static_cast<size_t>(n),
          static_cast<size_t>(week_effect)});
      day_of_week_simplex = std::vector<std::vector<double>>(n,
                              std::vector<double>(week_effect,
                                std::numeric_limits<double>::quiet_NaN()));
      {
        std::vector<local_scalar_t__> day_of_week_simplex_flat__;
        current_statement__ = 80;
        day_of_week_simplex_flat__ = context__.vals_r("day_of_week_simplex");
        current_statement__ = 80;
        pos__ = 1;
        current_statement__ = 80;
        for (int sym1__ = 1; sym1__ <= week_effect; ++sym1__) {
          current_statement__ = 80;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 80;
            stan::model::assign(day_of_week_simplex,
              day_of_week_simplex_flat__[(pos__ - 1)],
              "assigning variable day_of_week_simplex",
              stan::model::index_uni(sym2__), stan::model::index_uni(sym1__));
            current_statement__ = 80;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 80;
      stan::math::check_greater_or_equal(function__, "day_of_week_simplex",
        day_of_week_simplex, 0);
      current_statement__ = 81;
      context__.validate_dims("data initialization", "obs_scale", "int",
        std::vector<size_t>{});
      obs_scale = std::numeric_limits<int>::min();
      current_statement__ = 81;
      obs_scale = context__.vals_i("obs_scale")[(1 - 1)];
      current_statement__ = 82;
      stan::math::validate_non_negative_index("frac_obs", "n", n);
      current_statement__ = 83;
      stan::math::validate_non_negative_index("frac_obs", "obs_scale",
        obs_scale);
      current_statement__ = 84;
      context__.validate_dims("data initialization", "frac_obs", "double",
        std::vector<size_t>{static_cast<size_t>(n),
          static_cast<size_t>(obs_scale)});
      frac_obs = std::vector<std::vector<double>>(n,
                   std::vector<double>(obs_scale,
                     std::numeric_limits<double>::quiet_NaN()));
      {
        std::vector<local_scalar_t__> frac_obs_flat__;
        current_statement__ = 84;
        frac_obs_flat__ = context__.vals_r("frac_obs");
        current_statement__ = 84;
        pos__ = 1;
        current_statement__ = 84;
        for (int sym1__ = 1; sym1__ <= obs_scale; ++sym1__) {
          current_statement__ = 84;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 84;
            stan::model::assign(frac_obs, frac_obs_flat__[(pos__ - 1)],
              "assigning variable frac_obs", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 84;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 84;
      stan::math::check_greater_or_equal(function__, "frac_obs", frac_obs, 0);
      current_statement__ = 84;
      stan::math::check_less_or_equal(function__, "frac_obs", frac_obs, 1);
      current_statement__ = 85;
      context__.validate_dims("data initialization", "model_type", "int",
        std::vector<size_t>{});
      model_type = std::numeric_limits<int>::min();
      current_statement__ = 85;
      model_type = context__.vals_i("model_type")[(1 - 1)];
      current_statement__ = 86;
      stan::math::validate_non_negative_index("rep_phi", "n", n);
      current_statement__ = 87;
      stan::math::validate_non_negative_index("rep_phi", "model_type",
        model_type);
      current_statement__ = 88;
      context__.validate_dims("data initialization", "rep_phi", "double",
        std::vector<size_t>{static_cast<size_t>(n),
          static_cast<size_t>(model_type)});
      rep_phi = std::vector<std::vector<double>>(n,
                  std::vector<double>(model_type,
                    std::numeric_limits<double>::quiet_NaN()));
      {
        std::vector<local_scalar_t__> rep_phi_flat__;
        current_statement__ = 88;
        rep_phi_flat__ = context__.vals_r("rep_phi");
        current_statement__ = 88;
        pos__ = 1;
        current_statement__ = 88;
        for (int sym1__ = 1; sym1__ <= model_type; ++sym1__) {
          current_statement__ = 88;
          for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
            current_statement__ = 88;
            stan::model::assign(rep_phi, rep_phi_flat__[(pos__ - 1)],
              "assigning variable rep_phi", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 88;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 88;
      stan::math::check_greater_or_equal(function__, "rep_phi", rep_phi, 0);
      current_statement__ = 89;
      context__.validate_dims("data initialization", "trunc_id", "int",
        std::vector<size_t>{});
      trunc_id = std::numeric_limits<int>::min();
      current_statement__ = 89;
      trunc_id = context__.vals_i("trunc_id")[(1 - 1)];
      current_statement__ = 89;
      stan::math::check_greater_or_equal(function__, "trunc_id", trunc_id, 0);
      current_statement__ = 90;
      stan::math::validate_non_negative_index("delay_type_max",
        "delay_types", delay_types);
      current_statement__ = 91;
      delay_type_max = std::vector<int>(delay_types,
                         std::numeric_limits<int>::min());
      current_statement__ = 91;
      stan::model::assign(delay_type_max,
        get_delay_type_max(delay_types, delay_types_p, delay_types_id,
          delay_types_groups, delay_max, delay_np_pmf_groups, pstream__),
        "assigning variable delay_type_max");
      current_statement__ = 92;
      stan::math::validate_non_negative_index("sim_secondary", "n", n);
      current_statement__ = 93;
      sim_secondary_2dim__ = std::numeric_limits<int>::min();
      current_statement__ = 93;
      sim_secondary_2dim__ = (all_dates ? t : h);
      current_statement__ = 93;
      stan::math::validate_non_negative_index("sim_secondary",
        "all_dates ? t : h", sim_secondary_2dim__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = 0U;
  }
  inline std::string model_name() const final {
    return "model_simulate_secondary";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_simulate_secondary_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_simulate_secondary_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      std::vector<std::vector<int>> sim_secondary =
        std::vector<std::vector<int>>(n,
          std::vector<int>(sim_secondary_2dim__,
            std::numeric_limits<int>::min()));
      current_statement__ = 31;
      for (int i = 1; i <= n; ++i) {
        current_statement__ = 2;
        stan::math::validate_non_negative_index("secondary", "t", t);
        Eigen::Matrix<double,-1,1> secondary =
          Eigen::Matrix<double,-1,1>::Constant(t,
            std::numeric_limits<double>::quiet_NaN());
        current_statement__ = 4;
        stan::math::validate_non_negative_index("scaled", "t", t);
        Eigen::Matrix<double,-1,1> scaled =
          Eigen::Matrix<double,-1,1>::Constant(t,
            std::numeric_limits<double>::quiet_NaN());
        current_statement__ = 6;
        stan::math::validate_non_negative_index("convolved", "t", t);
        Eigen::Matrix<double,-1,1> convolved =
          Eigen::Matrix<double,-1,1>::Constant(t,
            std::numeric_limits<double>::quiet_NaN());
        current_statement__ = 7;
        stan::model::assign(convolved, stan::math::rep_vector(1e-5, t),
          "assigning variable convolved");
        current_statement__ = 12;
        if (obs_scale) {
          current_statement__ = 10;
          stan::model::assign(scaled,
            scale_obs(
              stan::math::to_vector(
                stan::model::rvalue(primary, "primary",
                  stan::model::index_uni(i))),
              stan::model::rvalue(frac_obs, "frac_obs",
                stan::model::index_uni(i), stan::model::index_uni(1)),
              pstream__), "assigning variable scaled");
        } else {
          current_statement__ = 8;
          stan::model::assign(scaled,
            stan::math::to_vector(
              stan::model::rvalue(primary, "primary",
                stan::model::index_uni(i))), "assigning variable scaled");
        }
        current_statement__ = 19;
        if (delay_id) {
          current_statement__ = 15;
          stan::math::validate_non_negative_index("delay_rev_pmf",
            "delay_type_max[delay_id] + 1",
            (stan::model::rvalue(delay_type_max, "delay_type_max",
               stan::model::index_uni(delay_id)) + 1));
          Eigen::Matrix<double,-1,1> delay_rev_pmf =
            Eigen::Matrix<double,-1,1>::Constant((stan::model::rvalue(
                                                    delay_type_max,
                                                    "delay_type_max",
                                                    stan::model::index_uni(
                                                      delay_id)) + 1),
              std::numeric_limits<double>::quiet_NaN());
          current_statement__ = 16;
          stan::model::assign(delay_rev_pmf,
            get_delay_rev_pmf(delay_id,
              (stan::model::rvalue(delay_type_max, "delay_type_max",
                 stan::model::index_uni(delay_id)) + 1), delay_types_p,
              delay_types_id, delay_types_groups, delay_max, delay_np_pmf,
              delay_np_pmf_groups,
              stan::model::rvalue(delay_params, "delay_params",
                stan::model::index_uni(i)), delay_params_groups, delay_dist,
              0, 1, 0, pstream__), "assigning variable delay_rev_pmf");
          current_statement__ = 17;
          stan::model::assign(convolved,
            stan::math::add(stan::model::deep_copy(convolved),
              convolve_to_report(scaled, delay_rev_pmf, 0, pstream__)),
            "assigning variable convolved");
        } else {
          current_statement__ = 13;
          stan::model::assign(convolved,
            stan::math::add(stan::model::deep_copy(convolved), scaled),
            "assigning variable convolved");
        }
        current_statement__ = 20;
        stan::model::assign(secondary,
          calculate_secondary(scaled, convolved, obs, cumulative, historic,
            primary_hist_additive, current, primary_current_additive, ((t -
            h) + 1), pstream__), "assigning variable secondary");
        current_statement__ = 23;
        if (stan::math::logical_gt(week_effect, 1)) {
          current_statement__ = 21;
          stan::model::assign(secondary,
            day_of_week_effect(stan::model::deep_copy(secondary),
              day_of_week,
              stan::math::to_vector(
                stan::model::rvalue(day_of_week_simplex,
                  "day_of_week_simplex", stan::model::index_uni(i))),
              pstream__), "assigning variable secondary");
        }
        current_statement__ = 28;
        if (trunc_id) {
          current_statement__ = 24;
          stan::math::validate_non_negative_index("trunc_rev_cmf",
            "delay_type_max[trunc_id] + 1",
            (stan::model::rvalue(delay_type_max, "delay_type_max",
               stan::model::index_uni(trunc_id)) + 1));
          Eigen::Matrix<double,-1,1> trunc_rev_cmf =
            Eigen::Matrix<double,-1,1>::Constant((stan::model::rvalue(
                                                    delay_type_max,
                                                    "delay_type_max",
                                                    stan::model::index_uni(
                                                      trunc_id)) + 1),
              std::numeric_limits<double>::quiet_NaN());
          current_statement__ = 25;
          stan::model::assign(trunc_rev_cmf,
            get_delay_rev_pmf(trunc_id,
              (stan::model::rvalue(delay_type_max, "delay_type_max",
                 stan::model::index_uni(trunc_id)) + 1), delay_types_p,
              delay_types_id, delay_types_groups, delay_max, delay_np_pmf,
              delay_np_pmf_groups,
              stan::model::rvalue(delay_params, "delay_params",
                stan::model::index_uni(i)), delay_params_groups, delay_dist,
              0, 1, 1, pstream__), "assigning variable trunc_rev_cmf");
          current_statement__ = 26;
          stan::model::assign(secondary,
            truncate_obs(stan::model::deep_copy(secondary), trunc_rev_cmf, 0,
              pstream__), "assigning variable secondary");
        }
        current_statement__ = 29;
        stan::model::assign(sim_secondary,
          report_rng(stan::math::tail(secondary, (all_dates ? t : h)),
            stan::model::rvalue(rep_phi, "rep_phi", stan::model::index_uni(i)),
            model_type, base_rng__, pstream__),
          "assigning variable sim_secondary", stan::model::index_uni(i));
      }
      for (int sym1__ = 1; sym1__ <= sim_secondary_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
          out__.write(sim_secondary[(sym2__ - 1)][(sym1__ - 1)]);
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      std::vector<std::string> temp{"sim_secondary"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(n),
               static_cast<size_t>(sim_secondary_2dim__)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= sim_secondary_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
          param_names__.emplace_back(std::string() + "sim_secondary" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= sim_secondary_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= n; ++sym2__) {
          param_names__.emplace_back(std::string() + "sim_secondary" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"sim_secondary\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(n) + ",\"element_type\":{\"name\":\"array\",\"length\":" + std::to_string(sim_secondary_2dim__) + ",\"element_type\":{\"name\":\"int\"}}},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"sim_secondary\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(n) + ",\"element_type\":{\"name\":\"array\",\"length\":" + std::to_string(sim_secondary_2dim__) + ",\"element_type\":{\"name\":\"int\"}}},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = 0;
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities * ((n *
      sim_secondary_2dim__));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = 0;
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities * ((n *
      sim_secondary_2dim__));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_simulate_secondary_namespace::model_simulate_secondary;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_simulate_secondary_namespace::profiles__;
}
#endif
#endif
