% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create_clean_reported_cases}
\alias{create_clean_reported_cases}
\title{Create Clean Reported Cases}
\usage{
create_clean_reported_cases(
  data,
  filter_leading_zeros = TRUE,
  zero_threshold = Inf,
  fill = NA_integer_,
  add_breakpoints = TRUE
)
}
\arguments{
\item{data}{A \verb{<data.frame>} of disease reports (confirm) by date (date).
\code{confirm} must be numeric and \code{date} must be in date format. Optionally
this can also have a logical \code{accumulate} column which indicates whether
data should be added to the next data point. This is useful when modelling
e.g. weekly incidence data. See also the \code{\link[=fill_missing]{fill_missing()}} function which
helps add the \code{accumulate} column with the desired properties when dealing
with non-daily data. If any accumulation is done this happens after
truncation as specified by the \code{truncation} argument.}

\item{filter_leading_zeros}{Logical, defaults to TRUE. Should zeros at the
start of the time series be filtered out.}

\item{zero_threshold}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Numeric defaults
to Inf. Indicates if detected zero cases are meaningful by using a threshold
number of cases based on the 7-day average. If the average is above this
threshold then the zero is replaced using \code{fill}.}

\item{fill}{Deprecated; zero dates with  7-day averages above the
\code{zero_threshold} will be skipped in model fitting.}

\item{add_breakpoints}{Logical, defaults to TRUE. Should a breakpoint column
be added to the data frame if it does not exist.}
}
\value{
A cleaned data frame of reported cases
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Filters leading zeros, completes dates, and applies an optional threshold at
which point 0 cases are replaced with a user supplied value (defaults to
\code{NA}).
}
\examples{
\dontrun{
create_clean_reported_cases(example_confirmed, 7)
}
}
\keyword{internal}
