% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AER_seasonality_graph.R
\name{getSeason}
\alias{getSeason}
\title{Get disease-specific seasonality graph: distribution of cases by month}
\usage{
getSeason(
  x = EpiReport::DENGUE2019,
  disease = "DENGUE",
  year = 2019,
  reportParameters = EpiReport::AERparams,
  MSCode = EpiReport::MSCode,
  index = 1,
  doc
)
}
\arguments{
\item{x}{dataframe, raw disease-specific dataset (see specification of the
dataset in the package vignette with \code{browseVignettes(package = "EpiReport")})
(default \code{DENGUE2019})}

\item{disease}{character string, disease code (default \code{"DENGUE"}).
Please make sure the disease code is included in the disease-specific dataset x
in the \code{HealthTopicCode} variable.}

\item{year}{numeric, year to produce the graph for (default \code{2019}).
Please make sure the year is included in the disease-specific dataset x
in the \code{TimeCode} variable.}

\item{reportParameters}{dataframe, dataset including the required parameters
for the graph and report production (default \code{AERparams}) (see specification
of the dataset in the package vignette with \code{browseVignettes(package = "EpiReport")})}

\item{MSCode}{dataframe, correspondence table of GeoCode names and codes
(default \code{MSCode}) (see specification of the dataset in the
package vignette with \code{browseVignettes(package = "EpiReport")})}

\item{index}{integer, figure number}

\item{doc}{'Word' document (see \code{'officer'} package) in which to add the graph
at the bookmark location.
If doc is missing, \code{getSeason} returns the \code{ggplot2} object.}
}
\value{
'Word' doc or a ggplot2 object
}
\description{
Function returning the plot describing the seasonality of the disease
that will be included in the epidemiological report at the bookmark location
\code{'TS_SEASON'} of the template report. \cr
\cr
The graph includes the distribution of cases at EU/EEA level, by month,
over the past five years, with:
\itemize{
   \item{}{The number of cases by month in the reference year (green solid line)}
   \item{}{The mean number of cases by month in the four previous years (grey dashed line)}
   \item{}{The minimum number of cases by month in the four previous years (grey area)}
   \item{}{The maximum number of cases by month in the four previous years (grey area)}
}
(see ECDC reports
\url{https://www.ecdc.europa.eu/en/all-topics-z/surveillance-and-disease-data/annual-epidemiological-reports-aers})
}
\examples{

# --- Plot using the default dataset
getSeason()

# --- Plot using external dataset
# --- Please see examples in the vignette
browseVignettes(package = "EpiReport")

}
\seealso{
Global function for the full epidemilogical report: \code{\link{getAER}}  \cr
Required Packages: \code{\link{ggplot2}} \code{\link{officer}} \cr
Internal functions: \code{\link{plotSeasonality}} \cr
Default datasets: \code{\link{AERparams}} \code{\link{MSCode}}
}
