% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estim_diagnostics.R
\name{Estim_diagnost}
\alias{Estim_diagnost}
\title{Sample estimators' values for different sample sizes}
\usage{
Estim_diagnost(Nmc, s, Inference, packages = NULL)
}
\arguments{
\item{Nmc}{number of repetitions}

\item{s}{numeric vector of sample sizes}

\item{Inference}{function of s creating a sample and evaluating estimators (see details)}

\item{packages}{list of packages to pass to foreach loop}
}
\value{
data frame with estimators' values
}
\description{
For every sample size value the function creates a sample and evaluates the estimators Nmc times.
}
\examples{
Nmc=400
s<-c(1e2,1e3)

Inference<-function(s){
  rrr<-rnorm(n=s)
  list(Mn=mean(rrr), Sd=sd(rrr))
}
data <- Estim_diagnost(Nmc, s, Inference)
estims_qqplot(data)
estims_boxplot(data)

#
Inference<-function(s){
rrr<-2/0
list(Mn=mean(rrr), Sd=sd(rrr))
}
head(Estim_diagnost(Nmc, s, Inference))

#
Inference<-function(s){
rrr<-rnorm(n=s)
rrr[2]<-"dwq"
list(Mn=mean(rrr), Sd=sd(rrr))
}
head(Estim_diagnost(Nmc, s, Inference))

}
