% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freqdist.evaluate.core.R
\name{freqdist.evaluate.core}
\alias{freqdist.evaluate.core}
\title{Frequency Distribution Histogram}
\usage{
freqdist.evaluate.core(
  data,
  names,
  quantitative,
  qualitative,
  selected,
  highlight = NULL,
  include.highlight = TRUE,
  highlight.se = NULL,
  highlight.col = "red"
)
}
\arguments{
\item{data}{The data as a data frame object. The data frame should possess
one row per individual and columns with the individual names and multiple
trait/character data.}

\item{names}{Name of column with the individual names as a character string}

\item{quantitative}{Name of columns with the quantitative traits as a
character vector.}

\item{qualitative}{Name of columns with the qualitative traits as a character
vector.}

\item{selected}{Character vector with the names of individuals selected in
core collection and present in the \code{names} column.}

\item{highlight}{Individual names to be highlighted as a character vector.}

\item{include.highlight}{If \code{TRUE}, the highlighted individuals are
included in the frequency distribution histogram. Default is \code{TRUE}.}

\item{highlight.se}{Optional data frame of standard errors for the
individuals specified in \code{highlight}. It shoudl have the same column
names as in \code{data}.}

\item{highlight.col}{The colour(s) to be used to highlighting individuals in
the plot as a character vector of the same length as \code{higlight}. Must
be valid colour values in R (named colours, hexadecimal representation,
index of colours [\code{1:8}] in default R \code{palette()} etc.).}
}
\value{
A list with the \code{ggplot} objects of stacked frequency
  distribution histograms plots for each trait specified as
  \code{quantitative} and \code{qualitative}.
}
\description{
Plot stacked frequency distribution histogram to graphically compare the
probability distributions of traits between entire collection (EC) and core
set (CS).
}
\examples{

####################################
# Use data from R package ccChooser
####################################

library(ccChooser)
data("dactylis_CC")
data("dactylis_EC")

ec <- cbind(genotypes = rownames(dactylis_EC), dactylis_EC[, -1])
ec$genotypes <- as.character(ec$genotypes)
rownames(ec) <- NULL
ec[, c("X1", "X6", "X7")] <- lapply(ec[, c("X1", "X6", "X7")],
                                    function(x) cut(x, breaks = 4))
ec[, c("X1", "X6", "X7")] <- lapply(ec[, c("X1", "X6", "X7")],
                                    function(x) factor(as.numeric(x)))
head(ec)

core <- rownames(dactylis_CC)

quant <- c("X2", "X3", "X4", "X5", "X8")
qual <- c("X1", "X6", "X7")

####################################
# EvaluateCore
####################################

\donttest{
freqdist.evaluate.core(data = ec, names = "genotypes",
                       quantitative = quant, qualitative = qual,
                       selected = core)

checks <- c("D120559", "D120773")

freqdist.evaluate.core(data = ec, names = "genotypes",
                       quantitative = quant, qualitative = qual,
                       selected = core,
                       highlight = checks, highlight.col = "red")

quant.se <- data.frame(genotypes = checks, X2 = c(0.275, 0.25),
                       X3 = c(0.1, 0.081), X4 = c(0.002, 0.002),
                       X5 = c(0.093, 0.087), X8 = c(0.125, 0.074))

freqdist.evaluate.core(data = ec, names = "genotypes",
                       quantitative = quant,
                       selected = core,
                       highlight = checks, highlight.col = "red",
                       highlight.se = quant.se)
}

}
\seealso{
\code{\link[graphics]{hist}}, \code{\link[ggplot2]{geom_histogram}}
}
