% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EventStudyAPI.R
\docType{data}
\name{EventStudyAPI}
\alias{EventStudyAPI}
\title{API for \url{www.eventstudytools.com}}
\format{\code{\link[R6]{R6Class}} object.}
\usage{
EventStudyAPI
}
\description{
R interface for performing Event Studies on 
\url{www.eventstudytools.com}. Please get a free API key from our website:
\url{https://www.eventstudytools.com/api-key}.

For more details see the help vignette:
\code{vignette("introduction_eventstudy", package = "EventStudy")}
}
\section{Usage}{

For usage details see \bold{Methods, Arguments, and Examples} sections.
}

\section{Methods}{

\describe{
  \item{\code{new(apiServerUrl)}}{This method is used to create 
  object of this class with \code{apiServerUrl} as the url to the 
  EventStudyTools server.}
  \item{\code{authentication(apiKey)}}{This method is used to 
  authenticate at \code{apiServerUrl}. A valid \code{apiKey} is 
  required. You can download a free key on our website: 
  \url{www.eventstudytools.com}}
  \item{\code{performEventStudy(estParam)}}{This method starts an Event Study. 
  This method does all work for you.}
  \item{\code{performDefaultEventStudy()}}{This method starts an default 
  Event Study. It is a wrapper around \code{performEventStudy}}
  \item{\code{processTask()}}{This method starts the Event Study 
  calculation on the server (after files are uploaded.}
  \item{\code{configureTask(input)}}{This method configures the 
  Event Study. \code{input} is an \code{ApplicationInputInterface} 
  R6 object, e.g. ARC configuration class}
  \item{\code{uploadFile(fileKey, fileName)}}{This method links to the 
  file to upload. \code{fileKey} is the key of the file. Valid values 
  are: \code{request_file}, \code{firm_data}, and \code{market_data}. 
  \code{fileName} file name to upload.}
  \item{\code{commitData()}}{This method commit the data to the server.}
  \item{\code{getTaskStatus()}}{Check if calcualtion is finished.}
  \item{\code{getTaskResults(destDir = getwd())}}{Downloads the 
  result files of the Event Study to \code{destDir} (Default: current 
  working directory).}
  }
}

\section{Arguments}{

\describe{
 \item{eventstudyapi}{An \code{EventStudyAPI} object.}
 \item{apiServerUrl}{URL to the API endpoint.}
 \item{apiKey}{Key for authentication.}
 \item{input}{An \code{ApplicationInputInterface} object.}
 \item{fileKey}{Type of input file: \code{request_file}, \code{firm_data}, 
 and \code{market_data}.}
 \item{fileName}{Data filename.}
 \item{destDir}{Directory for saving result files.}
}
}

\examples{
\dontrun{
apiKey <- "{Please insert your aPI key here}"

The URL is already set by default
options(EventStudy.KEY = apiKey)

# initialize object
estSetup <- EventStudyAPI$new()

# get S&P500 example data
getSP500ExampleFiles()

# set Event Study parameters
estType <- "arc"
dataFiles <- c("request_file" = "01_RequestFile.csv", 
               "firm_data"    = "02_firmData.csv", 
               "market_data"  = "03_MarketData.csv")
resultPath <- "results"

# Perform Event Study 
estResult <- estSetup$performDefaultEventStudy(estType    = estType,
                                               dataFiles  = dataFiles, 
                                               destDir    = resultPath)
}

}
\keyword{datasets}
