% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation.R
\name{simulatePopulations}
\alias{simulatePopulations}
\title{Simulate survival data for multiple databases}
\usage{
simulatePopulations(settings = createSimulationSettings())
}
\arguments{
\item{settings}{An object of type \code{simulationSettings}, created by the
\code{\link[=createSimulationSettings]{createSimulationSettings()}} function.}
}
\value{
A object of class \code{simulation}, which is a list of populations, each a data frame with columns
\code{rowId}, \code{stratumId}, \code{x}, \code{time}, and \code{y}.
}
\description{
Simulate survival data for multiple databases
}
\examples{
settings <- createSimulationSettings(nSites = 1, hazardRatio = 2)
populations <- simulatePopulations(settings)

# Fit a Cox regression for the simulated data site:
cyclopsData <- Cyclops::createCyclopsData(Surv(time, y) ~ x + strata(stratumId),
  data = populations[[1]],
  modelType = "cox"
)
cyclopsFit <- Cyclops::fitCyclopsModel(cyclopsData)
coef(cyclopsFit)

# (Estimates in this example will vary due to the random simulation)

}
