% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CharPart.R
\name{write_partitioned_alignments}
\alias{write_partitioned_alignments}
\title{Write character partitions as separate Nexus files (for use in BEAUti)}
\usage{
write_partitioned_alignments(characters, cluster_df, file)
}
\arguments{
\item{characters}{character data matrix as matrix or data frame (with taxa as columns and characters as rows)}

\item{cluster_df}{cluster partitions as outputted by \code{make.clusters}}

\item{file}{path to save the alignments. If \code{file = "example.nex"}, alignments will be saved to files \code{"example_part1.nex"}, \code{"example_part2.nex"}, etc.}
}
\value{
no return value
}
\description{
Write character partitions as separate Nexus files (for use in BEAUti)
}
\examples{
# Load example phylogenetic data matrix
data("characters")

# Create distance matrix
Dmatrix <- get_gower_dist(characters)

# Find optimal partitioning scheme using PAM under k=3 partitions
cluster_df <- make_clusters(Dmatrix, k = 3)

# Write to Nexus files
\dontrun{write_partitioned_alignments(characters, cluster_df, "example.nex")}
}
