\name{fat3.ad.dbc}
\Rdversion{1.1}
\alias{fat3.ad.dbc}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Fatorial triplo com um tratamento adicional em DBC
}
\description{
Analisa experimentos em fatorial triplo com um tratamento adicional em Delineamento em Blocos Casualizados balanceado, considerando o modelo fixo.
}
\usage{
fat3.ad.dbc(fator1, fator2, fator3, bloco, resp, respAd, quali = c(TRUE, TRUE, TRUE), mcomp = "tukey", fac.names = c("F1", "F2", "F3"), sigT = 0.05,
 sigF = 0.05)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{fator1}{Vetor numerico ou complexo contendo os niveis do fator 1.}
  \item{fator2}{Vetor numerico ou complexo contendo os niveis do fator 2.}
  \item{fator3}{Vetor numerico ou complexo contendo os niveis do fator 3.}
  \item{bloco}{Vetor numerico ou complexo contendo os blocos.}
  \item{resp}{Vetor numerico ou complexo contendo a variavel resposta.}
  \item{respAd}{Vetor numerico ou complexo contendo a variavel resposta do tratamento adicional.}
  \item{quali}{Logico, se TRUE (default) na primeira posicao, os niveis do fator 1 sao entendidos como qualitativos, se FALSE, quantitativos; da mesma
   forma, a segunda posicao e referente aos niveis do fator 2 e a terceira aos niveis do fator 3.}
  \item{mcomp}{Permite escolher o teste de comparacao multipla; o \emph{default} e o teste de Tukey, contudo tem-se como outras opcoes: o teste LSD
  ('lsd'), o teste LSDB ('lsdb'), o teste de Duncan ('duncan'), o teste de SNK ('snk'), o teste de Scott-Knott ('sk'), o teste de comparacoes
  multiplas bootstrap ('ccboot') e o teste de Calinski \& Corsten baseado na distribuicao F ("ccf").}
  \item{fac.names}{Permite nomear os fatores 1, 2 e 3.}
  \item{sigT}{Significancia a ser adotada pelo teste de comparacao multipla de medias; o default e 5\%.}
  \item{sigF}{Significancia a ser adotada pelo teste F da ANAVA; o default e a 5\%.}
}
\details{
Os argumentos sigT e mcomp so serao utilizados quando os tratamentos forem qualitativos.
}
\value{
Sao retornados os valores da analise de variancia do DBC em questao com um tratamento adicional, o teste de normalidade de
Shapiro-Wilk para os residuos do modelo, o ajuste de modelos de regressao (caso de tratamentos quantitativos) ou os testes de
comparacao de medias (caso de tratamentos qualitativos): teste de Tukey, teste de Duncan, teste t de Student (LSD), teste t de
Bonferroni, teste de Student-Newman-Keuls (SNK), teste de Scott-Knott e teste de comparacoes multiplas bootstrap; com o desdobramento
da interacao tripla, caso esta seja significativa, ou da(s) dupla(s), caso seja(m) significativa(s).
}
\references{
HEALY, M. J. R. The analysis of a factorial experiment with additional treatments. Journal of Agricultural Science, Cambridge, v. 47, p. 205-206. 1956.
}
\author{
Denismar Alves Nogueira

Eric Batista Ferreira
   
Portya Piscitelli Cavalcanti
}
%\note{
%%  ~~further notes~~


%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
Para outros experimentos fatoriais, veja: fat2.dic, fat2.dbc, fat3.dic, fat3.dbc, fat2.ad.dic, fat2.ad.dbc e fat3.ad.dic.
}
\examples{
data(ex6)
attach(ex6)
data(respAd)
fat3.ad.dbc(fatorA, fatorB, fatorC, rep, resp, respAd, quali = c(TRUE, TRUE, TRUE), mcomp = "snk", fac.names = c("Fator A", "Fator B", "Fator C"),
 sigT = 0.05, sigF = 0.05)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
%\keyword{ ~kwd1 }
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
