% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape_file.plot.R
\name{shape_file.plot}
\alias{shape_file.plot}
\title{Plotar os objetos/parcelas do shapefile na imagem}
\usage{
shape_file.plot(im,ShapeFile,colorLines="red",colorNames="red")
}
\arguments{
\item{im}{:Este objeto deve conter uma imagem no formato do EBImage/ExpImage.}

\item{ShapeFile}{Objeto criado pela funcao shape_file.create}

\item{colorLines}{Nome da cor das linhas do grid que serao apresentadas. Default e "red".}

\item{colorNames}{Nome da cor das nomes plotados sobre cada grid. Default e "red".}
}
\description{
Esta funcao desenha as linhas dos objetos/parcelas selecionadas pela
funcao shape_file.create.
}
\examples{
\dontrun{
end=example_image(13)
im=read_image(end,plot=TRUE)
A=shape_file.create(im,rows=5,cols=5,rectangular=F,Matrix=NULL,SelectSeveral = F)
B=shape_file.BorderExtract(im,A,p.rows = .9,p.cols = .9)
shape_file.plot(im,ShapeFile = B)
shape_file.split(im =im,shapefile = B,path = getwd(),namesFile = "TEST",type = ".jpg")
}
}
\seealso{
\code{\link{shape_file.create}}, \code{\link{shape_file.split}}
}
