% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExplodeLayoutBasic.R
\name{get_explode_nodelist}
\alias{get_explode_nodelist}
\title{Explode the old coordinates using cluster membership and generate nodelist for plotting}
\usage{
get_explode_nodelist(nodelist, radius = 1)
}
\arguments{
\item{nodelist}{A nodelist is a dataframe including at least 5 columns: Label, X, Y, Cluster, Entity. Label is the node ID. They must be unique character strings. X and Y are the original coordinates. Cluster is the node clustering membership. They must be integers ranging from 1 to the number of clusters. Entity indicates which part of the bipartite network a node belongs to. (Can be either 1 or 2.)}

\item{radius}{The explode radius of the projecting circle. Default to 1.}
}
\value{
A new nodelist with exploded coordinates, which is a dataframe including 5 columns: Label, X, Y, Color, baseShape.
}
\description{
Takes the nodelist of a network and return an updated nodelist with the exploded coordinates based on radius, node color based on cluster, and node shape based on entity.
}
\examples{
exploded_nodelist=get_explode_nodelist(example_nodelist,radius=1.2)
}
