% Generated by roxygen2 (4.0.2): do not edit by hand
\name{SRTB_ab}
\alias{SRTB_ab}
\alias{dSRTB_ab}
\alias{eSRTB_ab}
\alias{lSRTB_ab}
\alias{pSRTB_ab}
\alias{qSRTB_ab}
\alias{rSRTB_ab}
\alias{sSRTB_ab}
\title{The Symmetric-Reflected Truncated Beta (SRTB)  Distribution.}
\usage{
dSRTB_ab(x, shape1 = 2, shape2 = 3, a = 0, b = 1,
  params = list(shape1, shape2, a, b))

pSRTB_ab(q, shape1 = 2, shape2 = 3, a = 0, b = 1, params = list(shape1
  = 2, shape2 = 5, a = 0, b = 1))

qSRTB_ab(p, shape1 = 2, shape2 = 3, a = 0, b = 1, params = list(shape1
  = 2, shape2 = 5, a = 0, b = 1))

rSRTB_ab(n, shape1 = 2, shape2 = 3, a = 0, b = 1,
  params = list(shape1, shape2, a, b))

eSRTB_ab(X, w, method = "numerical.MLE")

lSRTB_ab(X, w, shape1 = 2, shape2 = 3, a = 0, b = 1,
  params = list(shape1, shape2, a, b), logL = TRUE)
}
\arguments{
\item{x,q}{vector of quantiles.}

\item{shape1,shape2}{shape parameters.}

\item{a,b}{boundary parameters.}

\item{params}{a list includes all parameters}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}

\item{X}{sample observations.}

\item{w}{weights of sample.}

\item{method}{parameter estimation method.}

\item{logL}{logical; if TRUE, lSRTB_ab gives log likelihood.}

\item{...}{other parameters}
}
\value{
dSRTB_ab gives the density; pSRTB_ab gives the distribution function;
qSRTB_ab gives the quantile function; rSRTB_ab generates random variables;
eSRTB_ab estimate the parameters; sSRTB_ab gives observed scorn function
}
\description{
Density, distribution function, quantile function, random
generation function and parameter estimation function (based on weighted or
unweighted i.i.d. sample) for the Symmetric-Reflected Truncated Beta (SRTB).
}
\details{
See \href{../doc/Distributions-Four-Parameter-Beta.html}{Distributions-Four-Parameter-Beta}
}
\examples{
\donttest{
# Parameter estimation
n <- 500
a <- 1
b <- 2
shape1 <- 2
shape2 <- 10
X <- rSRTB_ab(n, shape1, shape2, a, b)
(est.par <- eSRTB_ab(X))

# Histogram and fitted density
den.x <- seq(min(X),max(X),length=100)
den.y <- dSRTB_ab(den.x,params = est.par)
hist(X, breaks=10, col="red", probability=TRUE, ylim = c(0,1.1*max(den.y)))
lines(den.x, den.y, col="blue", lwd=2)

# Q-Q plot and P-P plot
plot(qSRTB_ab((1:n-0.5)/n, params=est.par), sort(X), main="Q-Q Plot",
xlab="Theoretical Quantiles", ylab="Sample Quantiles", xlim = c(a,b), ylim = c(a,b))
abline(0,1)

plot((1:n-0.5)/n, pSRTB_ab(sort(X), params=est.par), main="P-P Plot",
xlab="Theoretical Percentile", ylab="Sample Percentile", xlim = c(0,1), ylim = c(0,1))
abline(0,1)

# A weighted parameter estimation example
n <- 10
par <- list(shape1=2, shape2=10, a= 1, b=2)
X <- rSRTB_ab(n, params=par)
w <- c(0.13, 0.06, 0.16, 0.07, 0.2, 0.01, 0.06, 0.09, 0.1, 0.12)
eSRTB_ab(X,w) # estimated parameters of weighted sample
eSRTB_ab(X) # estimated parameters of unweighted sample

# Extracting boundary and shape parameters
est.par[attributes(est.par)$par.type=="boundary"]
est.par[attributes(est.par)$par.type=="shape"]

# evaluate the performance of the parameter estimation function by simulation
eval.estimation(rdist=rSRTB_ab,edist=eSRTB_ab,n = 1000, rep.num = 1e3,
params = list(shape1=2, shape2=10, a=0, b=1), method ="numerical.MLE")

# evaluate the precision of estimation by Hessian matrix
X <- rSRTB_ab(1000, shape1, shape2, a, b)
(est.par <- eSRTB_ab(X))
H <- attributes(eSRTB_ab(X, method = "numerical.MLE"))$nll.hessian
fisher_info <- solve(H)
sqrt(diag(fisher_info))

# log-likelihood, score vector and observed information matrix
lSRTB_ab(X,param = est.par)
lSRTB_ab(X,param = est.par, logL=FALSE)
}
}
\author{
Haizhen Wu and A. Jonathan R. Godfrey
}

