% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/JohnsonSB.R
\name{JohnsonSB}
\alias{JohnsonSB}
\alias{dJohnsonSB}
\alias{dJohnsonSB_ab}
\alias{eJohnsonSB}
\alias{lJohnsonSB}
\alias{pJohnsonSB}
\alias{qJohnsonSB}
\alias{rJohnsonSB}
\title{The Johnson SB distribution.}
\usage{
dJohnsonSB(x, gamma = -0.5, delta = 2, xi = -0.5, lambda = 2,
  params = list(gamma = -0.5, delta = 2, xi = -0.5, lambda = 2), ...)

dJohnsonSB_ab(x, gamma = -0.5, delta = 2, a = -0.5, b = 1.5,
  params = list(gamma = -0.5, delta = 2, a = -0.5, b = 1.5), ...)

pJohnsonSB(q, gamma = -0.5, delta = 2, xi = -0.5, lambda = 2,
  params = list(gamma = -0.5, delta = 2, xi = -0.5, lambda = 2), ...)

qJohnsonSB(p, gamma = -0.5, delta = 2, xi = -0.5, lambda = 2,
  params = list(gamma = -0.5, delta = 2, xi = -0.5, lambda = 2), ...)

rJohnsonSB(n, gamma = -0.5, delta = 2, xi = -0.5, lambda = 2,
  params = list(gamma = -0.5, delta = 2, xi = -0.5, lambda = 2), ...)

eJohnsonSB(X, w, method = "numerical.MLE", ...)

lJohnsonSB(X, w, gamma = -0.5, delta = 2, xi = -0.5, lambda = 2,
  params = list(gamma = -0.5, delta = 2, xi = -0.5, lambda = 2),
  logL = TRUE, ...)
}
\arguments{
\item{x,q}{A vector of quantiles.}

\item{gamma,delta}{Shape parameters.}

\item{xi,lambda,a,b}{Location-scale parameters.}

\item{params}{A list that includes all named parameters.}

\item{...}{Additional parameters.}

\item{p}{A vector of probabilities.}

\item{n}{Number of observations.}

\item{X}{Sample observations.}

\item{w}{An optional vector of sample weights.}

\item{method}{Parameter estimation method.}

\item{logL}{logical, it is assumed that the log-likelihood is desired. Set to FALSE if the likelihood is wanted.}
}
\value{
dJohnsonSB gives the density, pJohnsonSB the distribution function,
qJohnsonSB gives quantile function, rJohnsonSB generates random deviates, and
eJohnsonSB estimate the parameters. lJohnsonSB provides the log-likelihood function. The dJohnsonSB_ab provides
an alternative parameterisation of the JohnsonSB distribution.
}
\description{
Density, distribution, quantile, random number
generation, and parameter estimation functions for the Johnson SB (bounded support) distribution.
Parameter estimation can be based on a weighted or unweighted i.i.d. sample and can be performed numerically.
}
\details{
The Johnson system of distributions consists of families of distributions that, through specified transformations, can be
reduced to the standard normal random variable. It provides a very flexible system for describing statistical distributions
and is defined by
\deqn{z = \gamma + \delta f(Y)}
with \eqn{Y = (X-xi)/lambda}. The Johnson SB distribution arises when \eqn{f(Y) = ln[Y/(1-Y)]}, where \eqn{0 < Y < 1}.
This is the bounded Johnson family since the range of Y is \eqn{(0,1)}, Karian & Dudewicz (2011).\cr
\cr
The \code{dJohnsonSB()}, \code{pJohnsonSB()}, \code{qJohnsonSB()},and \code{rJohnsonSB()} functions serve as wrappers of the
\code{\link[SuppDists]{dJohnson}}, \code{\link[SuppDists]{pJohnson}}, \code{\link[SuppDists]{qJohnson}}, and
\code{\link[SuppDists]{rJohnson}} functions in the \pkg{{SuppDists}} package. They allow for the parameters to be declared not only as
individual numerical values, but also as a list so parameter estimation can be carried out. \cr
\cr
The JohnsonSB distribution has probability density function
\deqn{p_X(x) = \frac{\delta lambda}{\sqrt{2\pi}(x-xi)(1- x + xi)}exp[-0.5(\gamma + \delta ln((x-xi)/(1-x+xi)))^2].}
}
\examples{
# Parameter estimation for a distribution with known shape parameters
X <- rJohnsonSB(n=500, gamma=-0.5, delta=2, xi=-0.5, lambda=2)
est.par <- eJohnsonSB(X); est.par
plot(est.par)

#  Fitted density curve and histogram
den.x <- seq(min(X),max(X),length=100)
den.y <- dJohnsonSB(den.x,params = est.par)
hist(X, breaks=10, probability=TRUE, ylim = c(0,1.2*max(den.y)))
lines(den.x, den.y, col="blue")
lines(density(X))

# Extracting location, scale and shape parameters
est.par[attributes(est.par)$par.type=="location"]
est.par[attributes(est.par)$par.type=="scale"]
est.par[attributes(est.par)$par.type=="shape"]

# Parameter Estimation for a distribution with unknown shape parameters
# Example from Karian, Z.A and Dudewicz, E.J. (2011) p.647.
# Original source of brain scan data Dudewich, E.J et.al (1989).
# Parameter estimates as given by Karian & Dudewicz using moments are:
# gamma =-0.2081, delta=0.9167, xi = 95.1280 and lambda = 21.4607 with log-likelihood = -67.03579
brain <- c(108.7, 107.0, 110.3, 110.0, 113.6, 99.2, 109.8, 104.5, 108.1, 107.2, 112.0, 115.5, 108.4,
           107.4, 113.4, 101.2, 98.4, 100.9, 100.0, 107.1, 108.7, 102.5, 103.3)
est.par <- eJohnsonSB(brain); est.par

# Estimates calculated by eJohnsonSB differ from those given by Karian & Dudewicz (2011).
# However, eJohnsonSB's parameter estimates appear to be an improvement, due to a larger
# log-likelihood of -66.35496 (as given by lJohnsonSB below).

# log-likelihood function
lJohnsonSB(brain, param = est.par)
}
\author{
Haizhen Wu and A. Jonathan R. Godfrey.\cr
Updates and bug fixes by Sarah Pirikahu.
}
\references{
Johnson, N. L., Kotz, S. and Balakrishnan, N. (1994) Continuous Univariate Distributions,
volume 1, chapter 12, Wiley, New York.\cr
\cr
Kotz, S. and van Dorp, J. R. (2004). Beyond Beta: Other Continuous
Families of Distributions with Bounded Support and Applications. Appendix B.
World Scientific: Singapore.\cr
\cr
Z. A. Karian and E. J. Dudewicz (2011) Handbook of Fitting Statistical Distributions with R, Chapman & Hall.\cr
}
\seealso{
\pkg{\link{ExtDist}} for other standard distributions.
}

