% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Normal_trunc_ab.R
\name{Normal_trunc_ab}
\alias{Normal_trunc_ab}
\alias{dNormal_trunc_ab}
\alias{eNormal_trunc_ab}
\alias{lNormal_trunc_ab}
\alias{pNormal_trunc_ab}
\alias{qNormal_trunc_ab}
\alias{rNormal_trunc_ab}
\title{The truncated normal distribution.}
\usage{
dNormal_trunc_ab(x, mu = 0, sigma = 1, a = 0, b = 1, params = list(mu,
  sigma, a, b), ...)

pNormal_trunc_ab(q, mu = 0, sigma = 1, a = 0, b = 1, params = list(mu
  = 2, sigma = 5, a = 0, b = 1), ...)

qNormal_trunc_ab(p, mu = 0, sigma = 1, a = 0, b = 1, params = list(mu
  = 2, sigma = 5, a = 0, b = 1), ...)

rNormal_trunc_ab(n, mu = 0, sigma = 1, a = 0, b = 1, params = list(mu,
  sigma, a, b), ...)

eNormal_trunc_ab(X, w, method = "numerical.MLE", ...)

lNormal_trunc_ab(X, w, mu = 0, sigma = 1, a = 0, b = 1,
  params = list(mu, sigma, a, b), logL = TRUE, ...)
}
\arguments{
\item{x,q}{A vector of quantiles.}

\item{mu,sigma}{Shape parameters.}

\item{a,b}{Boundary parameters.}

\item{params}{A list that includes all named parameters.}

\item{...}{Additional parameters.}

\item{p}{A vector of probabilities.}

\item{n}{Number of observations.}

\item{X}{Sample observations.}

\item{w}{An optional vector of sample weights.}

\item{method}{Parameter estimation method.}

\item{logL}{logical;if TRUE, lNormal_trunc_ab gives the log-likelihood, otherwise the likelihood is given.}
}
\value{
dNormal_trunc_ab gives the density, pNormal_trunc_ab the distribution function,
qNormal_trunc_ab the quantile function, rNormal_trunc_ab generates random variables, and
eNormal_trunc_ab estimates the parameters. lNormal_trunc_ab provides the log-likelihood function.
}
\description{
Density, distribution, quantile, random number
generation and parameter estimation functions for the truncated normal distribution with parameters \code{mean}, \code{sd} and
\code{a} and \code{b} which represent the lower and upper truncation points respectively.
Parameter estimation can be based on a weighted or unweighted i.i.d. sample and is performed numerically.
}
\details{
If the \code{mean}, \code{sd}, \code{a} or \code{b} are not specified they assume the default values of 0, 1, 0, 1 respectively.\cr
\cr
The \code{dNormal_trunc_ab()}, \code{pNormal_trunc_ab()}, \code{qNormal_trunc_ab()},and \code{rNormal_trunc_ab()} functions serve
 as wrappers of the \code{\link[truncdist]{dtrunc}}, \code{\link[truncdist]{ptrunc}}, \code{\link[truncdist]{qtrunc}}, and
\code{\link[truncdist]{rtrunc}} functions in the \pkg{{truncdist}} package. They allow for the parameters to be declared not only as
individual numerical values, but also as a list so parameter estimation can be carried out. \cr
\cr
The probability density function of the doubly truncated normal distribution is given by
\deqn{f(x) = \sigma^{-1} Z(x-\mu/\sigma)[\Phi(b-\mu/\sigma) - \Phi(a-\mu/\sigma)]^{-1}}
where \eqn{\infty <a \le x \le b < \infty}. The degrees of truncation are \eqn{\Phi((a-\mu)/\sigma)} from below and \eqn{1-\Phi((a-\mu)/\sigma)}
from above. If a is replaced by \eqn{-\infty}, or b by \eqn{\infty}, the distribution is singly truncated, (Johnson et.al, p.156).
The upper and lower limits of truncation \eqn{a} and \eqn{b} are normally known
parameters whereas \eqn{\mu} and \eqn{\sigma} may be unknown. Crain (1979) discusses parameter estimation for the truncated normal
distribution and the method of numerical maximum likelihood estimation is used for parameter estimation in \code{eNormal_trunc_ab}.\cr
\cr
}
\examples{
# Parameter estimation for a distribution with known shape parameters
X <- rNormal_trunc_ab(n= 500, mu= 2, sigma = 5, a = 1, b = 2)
est.par <- eNormal_trunc_ab(X); est.par
plot(est.par)

#  Fitted density curve and histogram
den.x <- seq(min(X),max(X),length=100)
den.y <- dNormal_trunc_ab(den.x,params = est.par)
hist(X, breaks=10, probability=TRUE, ylim = c(0,1.2*max(den.y)))
lines(den.x, den.y, col="blue")
lines(density(X), lty = 2)

# Extracting boundary and shape parameters
est.par[attributes(est.par)$par.type=="boundary"]
est.par[attributes(est.par)$par.type=="shape"]

# log-likelihood function
lNormal_trunc_ab(X,param = est.par)
}
\author{
Haizhen Wu and A. Jonathan R. Godfrey.\cr
Updates and bug fixes by Sarah Pirikahu.
}
\references{
Johnson, N. L., Kotz, S. and Balakrishnan, N. (1994) Continuous Univariate Distributions,
 volume 1, chapter 13, Wiley, New York.\cr
\cr
Crain, B.R (1979). Estimating the parameters of a truncated normal distribution, Applied Mathematics and Computation,
vol 4, pp. 149-156
}
\seealso{
\pkg{\link{ExtDist}} for other standard distributions.
}

