% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irf_single.R
\name{irf_single}
\alias{irf_single}
\title{Compute Impulse Response for Every Sample of MCMC}
\usage{
irf_single(i, varrlt, Lamb, Ynum, type = "orth", impvar = 1, nhor)
}
\arguments{
\item{i}{the \eqn{i}th sample in MCMC}

\item{varrlt}{estimation results for VAR equations, and it's got by \code{BayesVAR}.}

\item{Lamb}{a array with 3 dimension. and \code{Lamb[i,,]} is factor loading matrix for factor equations.}

\item{Ynum}{the \code{ncol(Y)}.}

\item{type}{\code{'orth'} is orthogonal IRF, and \code{'gen'} is generalized
IRF.}

\item{impvar}{a numeric scalar which is position of variables in VAR equation.
If it's \code{NULL} that is default, its position is the last.}

\item{nhor}{IRF horizon, default is \code{NULL}}
}
\value{
IRF matrix, the dimension is \code{ncol(Xmatrix) + ncol(Y)}x\code{nhor}.
}
\description{
Compute Impulse Response for Every Sample of MCMC
}
