% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/mlp_prune.R
\name{mlp_prune_obs}
\alias{mlp_prune_obs}
\title{Optimal Brain Surgeon pruning}
\usage{
mlp_prune_obs(net, input, output, tol_level, max_reteach_epochs, report,
  plots = FALSE, alpha = 1e-05)
}
\arguments{
\item{net}{an object of \code{mlp_net} class}

\item{input}{numeric matrix, each row corresponds to one input vector
number of columns must be equal to the number of neurons
in the network input layer}

\item{output}{numeric matrix with rows corresponding to expected outputs,
number of columns must be equal to the number of neurons
in the network output layer, number of rows must be equal to the number
of input rows}

\item{tol_level}{numeric value, error (MSE) tolerance level}

\item{max_reteach_epochs}{integer value, maximal number of epochs (iterations) allowed
when reteaching network}

\item{report}{logical value, if TRUE, information about the pruning process
will be printed on the console (FALSE by default)}

\item{plots}{logical value, if TRUE, the initial network is plotted and then
replotted every time weight or neuron is removed (FALSE by default)}

\item{alpha}{numeric value, scaling factor used for initial Hessian approximation}
}
\value{
Three-element list, the first field (\code{net}) contains the pruned network,
        the second (\code{wcount}) - the number of connections removed (inactivated),
        the third (\code{ncount}) - the number of neurons removed.
}
\description{
The Optimal Brain Surgeon algorithm is a robust (yet computationally demanding)
pruning algorithm in which candidate weight to be turned off is determined
based on information about the inverse of (approximate) Hessian matrix of the MSE.
}
\references{
B. Hassibi, D. G. Stork, and G. J. Wolff. \emph{Optimal Brain Surgeon
and General Network Pruning.} Technical Report CRC-TR-9235, RICOH California
Research Centre, 1992.
}
\keyword{pruning}

