% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FCVAR_estn.R
\name{summary.FCVAR_model}
\alias{summary.FCVAR_model}
\title{Summarize Estimation Results from the FCVAR model}
\usage{
\method{summary}{FCVAR_model}(object, ...)
}
\arguments{
\item{object}{An S3 object containing the estimation results of \code{FCVARestn}.}

\item{...}{additional arguments affecting the summary produced.}
}
\description{
\code{summary.FCVAR_model} prints a summary of the estimation results from
the output of \code{FCVARestn}.
\code{FCVARestn} estimates the Fractionally Cointegrated VAR model.
 It is the central function in the \code{FCVAR} package with several nested functions.
	It estimates the model parameters, calculates the
	standard errors and the number of free parameters, obtains the residuals
	and the roots of the characteristic polynomial.
}
\examples{
\donttest{
opt <- FCVARoptions()
opt$gridSearch   <- 0 # Disable grid search in optimization.
opt$dbMin        <- c(0.01, 0.01) # Set lower bound for d,b.
opt$dbMax        <- c(2.00, 2.00) # Set upper bound for d,b.
opt$constrained  <- 0 # Impose restriction dbMax >= d >= b >= dbMin ? 1 <- yes, 0 <- no.
x <- votingJNP2014[, c("lib", "ir_can", "un_can")]
FCVARresults <- FCVARestn(x, k = 2, r = 1, opt)
summary(object = FCVARresults)
}
}
\seealso{
\code{FCVARoptions} to set default estimation options.
\code{FCVARestn} calls this function at the start of each estimation to verify
validity of options.
\code{summary.FCVAR_model} prints a summary of the output of \code{FCVARestn} to screen.

Other FCVAR estimation functions: 
\code{\link{FCVARestn}()},
\code{\link{FCVARoptions}()}
}
\concept{FCVAR estimation functions}
