% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simfft_function.R
\name{simfft}
\alias{simfft}
\title{A wrapper for fft_function that calculates the predictive accuracy of trees for different training set sizes}
\usage{
simfft(train.cue.df = NULL, train.criterion.v = NULL, train.p = c(0.5),
  sim.n = 20, hr.weight = 0.5, rank.method = "m",
  numthresh.method = "o", stopping.rule = "exemplars", stopping.par = 0.1,
  correction = 0.25, max.levels = 4, do.lr = T, do.cart = T,
  roc.p = 0.8, verbose = T, parallel.cpus = 0)
}
\arguments{
\item{train.cue.df}{A model training dataset. An m x n dataframe containing n cue values for each of the m exemplars.}

\item{train.criterion.v}{The criterion for training. A logical vector of length m containing criterion values for exemplars in cue.df}

\item{train.p}{A vector of numbers between 0 and 1 indicating what percentage of the data to use for training.}

\item{sim.n}{Number of simulations per train.p}

\item{hr.weight}{A vector of numbers between 0 and 1 indicating how much weight to give to increasing hit rates versus avoiding false alarms. 1 means maximizing HR and ignoring FAR, while 0 does the opposite. The default of 0.5 gives equal weight to both. Different trees will be constructed for each weight in the vector.}

\item{rank.method}{A string vector indicating how to rank cues during tree construction. "m" (for marginal) means that cues will only be ranked once with the entire training dataset. "c" (conditional) means that cues will be ranked after each level in the tree with the remaining unclassified training exemplars.}

\item{numthresh.method}{A string indicating how to calculate cue splitting thresholds. "m" = median split, "o" = split that maximizes the tree criterion.}

\item{stopping.rule}{A string indicating the method to stop growing trees. "levels" means the tree grows until a certain level. "exemplars" means the tree grows until a certain number of unclassified exemplars remain. "statdelta" means the tree grows until the change in the tree.criterion statistic is less than a specified level.}

\item{stopping.par}{A number indicating the parameter for the stopping rule.}

\item{correction}{A positive number indicating how much to add to classification cells in the case that at least 1 cell is 0.}

\item{max.levels}{A number indicating the maximum number of tree levels to consder.}

\item{do.lr}{A logical value indicating whether to conduct linear regression for model comparison purposes.}

\item{do.cart}{A logical value indicating whether to conduct CART for model comparison purposes.}

\item{roc.p}{A vector of probabilities to plot in the ROC density curve}

\item{verbose}{A logical value indicating whether or not to print simulation updates}

\item{parallel.cpus}{An integer indicating how many cups to use for parallel calculations using the snowfall package. A value of 0 means no parallel. You may need to explicitly load the snowfall package with library("snowfall") for parallel calculations to work.}
}
\value{
A list of length 3. The first element "decision.df" is a dataframe with the decisions (and level of decisions) for each exemplar. The second element, "final.df" is a dataframe showing final tree accuracy statistics. The third element "level.df" shows tree accuracy statistics at each level.
}
\description{
A wrapper for fft_function that calculates the predictive accuracy of trees for different training set sizes
}

