% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fftrees_ffttowords.R
\name{fftrees_ffttowords}
\alias{fftrees_ffttowords}
\title{Describe a fast-and-frugal tree (FFT) in words}
\usage{
fftrees_ffttowords(x = NULL, mydata = "train", digits = 2)
}
\arguments{
\item{x}{An \code{FFTrees} object created with \code{\link{FFTrees}}.}

\item{mydata}{The type of data to which a tree is being applied (as character string "train" or "test").
Default: \code{mydata = "train"}.}

\item{digits}{How many digits to round numeric values (as integer)?}
}
\value{
A modified \code{FFTrees} object \code{x} with
\code{x$trees$inwords} containing a list of string vectors.
}
\description{
\code{fftrees_ffttowords} provides a verbal description
of tree definition (as defined in an \code{FFTrees} object).
Thus, \code{fftrees_ffttowords} translates an abstract FFT definition
into natural language output.

\code{fftrees_ffttowords} is the complement function to
\code{\link{fftrees_wordstofftrees}}, which parses a verbal description
of an FFT into the abstract tree definition of an \code{FFTrees} object.

The final sentence (or tree node) of the FFT's description
always predicts positive criterion values (i.e., \code{TRUE} instances) first,
before predicting negative criterion values (i.e., \code{FALSE} instances).
Note that this may require a reversal of exit directions,
if the final cue predicted \code{FALSE} instances.

Note that the cue directions and thresholds computed by \strong{FFTrees}
always predict positive criterion values (i.e., \code{TRUE} or signal,
rather than \code{FALSE} or noise).
Using these thresholds for negative exits (i.e., for predicting instances of
\code{FALSE} or noise) usually requires a reversal (e.g., negating cue direction).
}
\examples{

heart.fft <- FFTrees(diagnosis ~ .,
  data = heartdisease,
  decision.labels = c("Healthy", "Disease")
)

inwords(heart.fft)

}
\seealso{
\code{\link{fftrees_wordstofftrees}} for converting a verbal description
of an FFT into an \code{FFTrees} object;
\code{\link{fftrees_create}} for creating \code{FFTrees} objects;
\code{\link{fftrees_grow_fan}} for creating FFTs by applying algorithms to data;
\code{\link{print.FFTrees}} for printing FFTs;
\code{\link{plot.FFTrees}} for plotting FFTs;
\code{\link{summary.FFTrees}} for summarizing FFTs;
\code{\link{FFTrees}} for creating FFTs from and applying them to data.
}
