% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spClassifyRast.R
\name{spClassifyRast}
\alias{spClassifyRast}
\title{Data - Reclass raster.}
\usage{
spClassifyRast(
  rastfn,
  cutbreaks,
  bnd = NULL,
  bnd_dsn = NULL,
  bnd.filter = NULL,
  buffdist = NULL,
  savedata_opts = NULL
)
}
\arguments{
\item{rastfn}{String. Path name of raster to classify.}

\item{cutbreaks}{Integer vector. Breaks to use for classifying (e.g.,
c(0,50,75) uses function in calc: 'ifelse (A >= 0 & A < 50, 1, 
ifelse (A >= 50 & A < 75, 2, ifelse (A >= 75, 3, 255)))'}

\item{bnd}{sf R object or String. Boundary to clip raster (optional).
Can be a spatial sf object, full pathname to a shapefile, or name of
a layer within a database.}

\item{bnd_dsn}{String. Name of data source name with bnd_layer, if in a
database.}

\item{bnd.filter}{String. Optional filter of bnd_layer.}

\item{buffdist}{Number. The distance to buffer the polygon before clipping
raster, in units of raster.}

\item{savedata_opts}{List. See help(savedata_options()) for a list
of options. Only used when savedata = TRUE.}
}
\value{
Data.
}
\description{
Wrapper to reclass a raster using a vector of cut breaks.
}
\author{
Tracey S. Frescino
}
\keyword{data}
