% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GBest.pbar.R, R/MAest.pbar.R, R/PBest_pbar.R,
%   R/PBest_pbarRatio.R, R/SAest.pbar.R, R/estimation_desc.R
\name{GBest.pbar}
\alias{GBest.pbar}
\alias{MAest.ht}
\alias{MAest.ps}
\alias{MAest.greg}
\alias{MAest.ratio}
\alias{MAest.gregEN}
\alias{MAest.gregRatio}
\alias{MAest}
\alias{MAest.dom}
\alias{MAest.unit}
\alias{PBest.pbar}
\alias{PBest.pbarRatio}
\alias{SAest.unit}
\alias{SAest.area}
\alias{SAest}
\alias{SAest.dom}
\alias{SAest.large}
\alias{estimation_desc}
\title{Estimation Functions}
\usage{
GBest.pbar(
  sumyn = "CONDPROP_ADJ",
  ysum,
  sumyd = NULL,
  esttype = "AREA",
  ratiotype = "PERACRE",
  stratalut,
  uniqueid,
  unitvar,
  strvar = NULL,
  domain
)

MAest.ht(y, N, FIA = TRUE, getweights = FALSE, var_method = "LinHTSRS")

MAest.ps(
  y,
  N,
  x_sample,
  x_pop,
  FIA = TRUE,
  save4testing = FALSE,
  getweights = FALSE,
  var_method = "SRSunconditional"
)

MAest.greg(
  y,
  N,
  x_sample,
  x_pop,
  FIA = TRUE,
  save4testing = TRUE,
  modelselect = FALSE,
  getweights = FALSE,
  var_method = "LinHTSRS"
)

MAest.ratio(
  y,
  N,
  x_sample,
  x_pop,
  FIA = TRUE,
  save4testing = TRUE,
  var_method = "LinHTSRS"
)

MAest.gregEN(
  y,
  N,
  x_sample,
  x_pop,
  FIA = TRUE,
  model = "linear",
  save4testing = TRUE,
  getweights = FALSE,
  var_method = "LinHTSRS"
)

MAest.gregRatio(
  yn,
  yd,
  N,
  area,
  x_sample,
  x_pop,
  FIA = TRUE,
  save4testing = FALSE,
  modelselect = FALSE,
  getweights = FALSE,
  var_method = "LinHTSRS"
)

MAest(
  yn = "CONDPROP_ADJ",
  dat.dom,
  cuniqueid,
  unitlut = NULL,
  pltassgn,
  esttype = "ACRES",
  MAmethod,
  strvar = NULL,
  prednames = NULL,
  yd = NULL,
  ratiotype = "PERACRE",
  N,
  area,
  FIA = TRUE,
  modelselect = FALSE,
  getweights = FALSE,
  var_method = ifelse(MAmethod \%in\% c("PS"), "SRSunconditional", "LinHTSRS")
)

MAest.dom(
  dom,
  dat,
  cuniqueid,
  unitlut,
  pltassgn,
  esttype,
  MAmethod,
  strvar = NULL,
  prednames = NULL,
  domain,
  N,
  area = NULL,
  response = NULL,
  response_d = NULL,
  FIA = TRUE,
  modelselect = FALSE,
  getweights = FALSE,
  var_method = ifelse(MAmethod \%in\% c("PS"), "SRSunconditional", "LinHTSRS")
)

MAest.unit(
  unit,
  dat,
  cuniqueid,
  unitlut,
  unitvar,
  esttype,
  MAmethod = "HT",
  strvar = NULL,
  prednames = NULL,
  domain,
  response,
  response_d = NULL,
  npixels,
  unitarea = NULL,
  FIA = TRUE,
  modelselect = FALSE,
  getweights = FALSE,
  var_method = ifelse(MAmethod \%in\% c("PS"), "SRSunconditional", "LinHTSRS")
)

PBest.pbar(
  dom.prop,
  uniqueid,
  domain,
  strtype = "post",
  stratalut,
  strunitvars,
  unitvars,
  strvar
)

PBest.pbarRatio(
  dom.prop.n,
  dom.prop.d,
  uniqueid,
  domain,
  attribute,
  strtype = "post",
  stratalut,
  strunitvars,
  unitvars,
  strvar
)

SAest.unit(
  fmla.dom.unit,
  pltdat.dom,
  dunitlut.dom,
  yn,
  SApackage,
  dunitvar,
  predselect.unit,
  prior = NULL
)

SAest.area(
  fmla.dom.area,
  pltdat.area,
  dunitlut.area,
  cuniqueid,
  dunitvar = "DOMAIN",
  predselect.area,
  yn,
  SApackage,
  prior = NULL
)

SAest(
  yn = "CONDPROP_ADJ",
  dat.dom,
  cuniqueid,
  pltassgn,
  dunitlut,
  prednames = NULL,
  dunitvar = "DOMAIN",
  SAmethod = "unit",
  SApackage = "JoSAE",
  yd = NULL,
  ratiotype = "PERACRE",
  largebnd.val = NULL,
  showsteps = FALSE,
  savesteps = FALSE,
  stepfolder = NULL,
  prior = NULL,
  modelselect = TRUE,
  multest = TRUE,
  save4testing = FALSE
)

SAest.dom(
  dom,
  dat,
  cuniqueid,
  dunitlut,
  pltassgn,
  dunitvar = "DOMAIN",
  SApackage,
  SAmethod,
  prednames = NULL,
  domain,
  response = NULL,
  largebnd.val = NULL,
  showsteps = FALSE,
  savesteps = FALSE,
  stepfolder = NULL,
  prior = NULL,
  modelselect = TRUE,
  multest = TRUE
)

SAest.large(
  largebnd.val,
  dat,
  cuniqueid,
  largebnd.unique,
  dunitlut,
  dunitvar = "DOMAIN",
  SApackage = "JoSAE",
  SAmethod = "unit",
  domain,
  response,
  prednames = NULL,
  showsteps = FALSE,
  savesteps = FALSE,
  stepfolder = NULL,
  prior = NULL,
  modelselect = TRUE,
  multest = TRUE
)
}
\value{
List object containing estimates produced. If GB or PB estimation, output is
directly from FIESTAutils, while outputs for MA or SA will be list objects
from packages such as `mase`, `sae`, `hbsae`, or `JoSAE`.
}
\description{
These functions carry out direct, model-assisted, and small area estimation
through three different modules: "Green Book", "Model-Assisted", and
"Small Area".
}
\details{
These functions can carry out estimation with data from a variety of domains, 
but are designed for USFS FIA data.
}
\author{
Tracey S. Frescino, Grayson W. White
}
\keyword{internal}
