% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FLORAL.R
\name{mcv.FLORAL}
\alias{mcv.FLORAL}
\title{Summarizing selected compositional features over multiple cross validations}
\usage{
mcv.FLORAL(
  mcv = 10,
  ncore = 1,
  seed = NULL,
  x,
  y,
  ncov = 0,
  family = "gaussian",
  longitudinal = FALSE,
  id = NULL,
  tobs = NULL,
  failcode = NULL,
  length.lambda = 100,
  lambda.min.ratio = NULL,
  ncov.lambda.weight = 0,
  a = 1,
  mu = 1,
  ncv = 5,
  intercept = FALSE,
  step2 = TRUE,
  progress = TRUE,
  plot = TRUE
)
}
\arguments{
\item{mcv}{Number of random `ncv`-fold cross-validation to be performed.}

\item{ncore}{Number of cores used for parallel computation. Default is to use only 1 core.}

\item{seed}{A random seed for reproducibility of the results. By default the seed is the numeric form of \code{Sys.Date()}.}

\item{x}{Feature matrix, where rows specify subjects and columns specify features. The first \code{ncov} columns should be patient characteristics and the rest columns are microbiome absolute counts corresponding to various taxa. If \code{x} contains longitudinal data, the rows must be sorted in the same order of the subject IDs used in \code{y}.}

\item{y}{Outcome. For a continuous or binary outcome, \code{y} is a vector. For survival outcome, \code{y} is a \code{Surv} object.}

\item{ncov}{An integer indicating the number of first \code{ncov} columns in \code{x} that will not be subject to the zero-sum constraint.}

\item{family}{Available options are \code{gaussian}, \code{binomial}, \code{cox}, \code{finegray}.}

\item{longitudinal}{\code{TRUE} or \code{FALSE}, indicating whether longitudinal data matrix is specified for input \code{x}. (Still under development. Please use with caution)}

\item{id}{If \code{longitudinal} is \code{TRUE}, \code{id} specifies subject IDs corresponding to the rows of input \code{x}.}

\item{tobs}{If \code{longitudinal} is \code{TRUE}, \code{tobs} specifies time points corresponding to the rows of input \code{x}.}

\item{failcode}{If \code{family = finegray}, \code{failcode} specifies the failure type of interest. This must be a positive integer.}

\item{length.lambda}{Number of penalty parameters used in the path}

\item{lambda.min.ratio}{Ratio between the minimum and maximum choice of lambda. Default is \code{NULL}, where the ratio is chosen as 1e-2.}

\item{ncov.lambda.weight}{Weight of the penalty lambda applied to the first \code{ncov} covariates. Default is 0 such that the first \code{ncov} covariates are not penalized.}

\item{a}{A scalar between 0 and 1: \code{a} is the weight for lasso penalty while \code{1-a} is the weight for ridge penalty.}

\item{mu}{Value of penalty for the augmented Lagrangian}

\item{ncv}{Folds of cross-validation. Use \code{NULL} if cross-validation is not wanted.}

\item{intercept}{\code{TRUE} or \code{FALSE}, indicating whether an intercept should be estimated.}

\item{step2}{\code{TRUE} or \code{FALSE}, indicating whether a second-stage feature selection for specific ratios should be performed for the features selected by the main lasso algorithm. Will only be performed if cross validation is enabled.}

\item{progress}{\code{TRUE} or \code{FALSE}, indicating whether printing progress bar as the algorithm runs.}

\item{plot}{\code{TRUE} or \code{FALSE}, indicating whether returning summary plots of selection probability for taxa features.}
}
\value{
A list with relative frequencies of a certain feature being selected over \code{mcv} \code{ncv}-fold cross-validations.
}
\description{
Summarizing \code{FLORAL} outputs from multiple random k-fold cross validations
}
\examples{

set.seed(23420)

dat <- simu(n=50,p=30,model="linear")
fit <- mcv.FLORAL(mcv=2,ncore=1,x=dat$xcount,y=dat$y,ncv=2,progress=FALSE,step2=TRUE,plot=FALSE)

}
\references{
Fei T, Funnell T, Waters N, Raj SS et al. Scalable Log-ratio Lasso Regression Enhances Microbiome Feature Selection for Predictive Models. bioRxiv 2023.05.02.538599.
}
\author{
Teng Fei. Email: feit1@mskcc.org
}
