\name{mmFLknapsack}
\alias{mmFLknapsack}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
General-purpose knapsack problem solver
}
\description{
An application of the multidimensional fixed size subset sum solver on multi-objective multidimensional bounded/unbounded knapsack problem.
}
\usage{
mmFLknapsack(len, mV, lbound, ubound, viaConjugate = F, maxCore = 7L,
totalSolutionNeeded = 1L, tlimit = 60, singleTimeLimit = 10,
randomizeTargetOrder = sample(1L:(len * (nrow(mV) - len) + 1L),
len * (nrow(mV) - len) + 1L), LB = 1L:len,
UB = (nrow(mV) - len + 1L):nrow(mV))
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{len}{
An integer as the subset size. If 0, activate the general-case (unfixed subset size) solver. Looping over different subset sizes to solve the general subset sum problem is preferred than setting len to 0 if mV is relatively large. Example below and example II method 2 in FLSSS help page both showed how the solver progresses for the unfixed subset size scenario with len=0.
}
  \item{mV}{
A data frame as the multidimensional vector. Each row is a multidimensional element
}
  \item{lbound}{
A numeric vector as the required lower bound of the subset sum
}
  \item{ubound}{
A numeric vector as the required upper bound of the subset sum
}
  \item{viaConjugate}{
Please refer to the details section for function "mFLSSSpar"
}
  \item{maxCore}{
Number of threads to invoke. Better not be greater than the maximal concurrentable threads in system
}
  \item{totalSolutionNeeded}{
Number of solutions needed.
}
  \item{tlimit}{
Time limit in seconds. Default to 60s
}
 \item{singleTimeLimit}{
Please refer to details section or the package vignette for more information.
}
  \item{randomizeTargetOrder}{
Discussed in the details section.
}
  \item{LB}{
Lower bound initializer.
}
  \item{UB}{
Upper bound initializer.
}
}
\details{
In example
}
\value{
A list of integer vectors. Each vector is a solution's indexes.
}



\examples{
# PROBLEM DESCRIPTION:
# N uncorrelated assets in a portfolio
N=20
# initiate prices
# price=abs(rnorm(N)+1)*1e6 # following vector generated by this command
price=c(1305622.6,1080532.2,1245737.6,1182741.4,1148068.0,680656.4,1815259.4
,148957.1,496983.9,1509825.9,1728705.0,1067839.7,377404.0,1876344.7,1689563.4,
1569611.4,453573.7,1243951.8,2351058.0,1277857.0)

# asset still in portfolio in one week probability
# prob=runif(N)^0.2 # following vectors generated by this command
prob=c(0.9261989,0.9242555,0.5369701,0.9986413,0.9476367,0.9646240,0.9992410,
0.9576450,0.8063813,0.9448719,0.9154061,0.5568553,0.8291263,0.9012308,
0.8285262,0.8677975,0.9866419,0.9172621,0.9665702,0.7906170)

# one week return rates
# returnRate=runif(N)^3 # following vector generated by this command
returnRate=c(4.249990e-01,8.496273e-01,1.698966e-04,8.774191e-01,4.906818e-03
,1.176626e-04,6.790879e-01,7.480636e-03,1.048729e-01,5.841388e-01,4.857164e-02
,9.642615e-01,1.802129e-01,5.835278e-01,4.010622e-03,3.197286e-05,1.346220e-02
,2.310800e-01,1.785672e-01,7.112244e-01)

# one week expect values
expectVal=price*(1+returnRate)*prob

# requirement: select a portfolio (subset) from the assets such that the
# probability of all initial assets still in portfolio at the end of week no
# less than 50\%; portfolio bid price no greater than 3.5e7; objective:
# maximize the expect value in one week


# ------------------------------------------------------------------------
# SOLVING:

# Assets are uncorrelated, so probability of all assets being in portfolio
# equals the product of the probabilities for each asset. Transform
# multiplication to summation via logarithmic.

# formulate multidimensional vector. Since no restriction on subset
# size, insert N dummy elements, set the subset size N
mV=data.frame(c(rep(0,N),price),c(rep(0,N),log2(prob)),c(rep(0,N),expectVal))
# this padding idea can be applied to solve the unbounded knapsack problem
# (each item can be used multiple times)

# formulate lbound ubound
lbound=c(-Inf, log2(0.5), sum(expectVal)*0.75)
# try if a portfolio with total expect value no less than 75\% of the maximum
# can be found. Change "0.75" manually or in loop to detect the optimal

ubound=c(3.5e7, Inf, Inf)
# -Inf or Inf in bounding vectors can be replaced with NA

# singleTimeLimit and tlimit shall be changed for heavier task
rst=mmFLknapsack(N, mV, lbound, ubound, totalSolutionNeeded = 1, tlimit=10)

# exclude the dummy elements which also could lead to identical solutions
if(length(rst)>0L)rst=unique(lapply(rst, function(x)x[x>N]-N))

# exam the solutions
all(unlist(lapply(rst, function(x)
{
  c(sum(price[x])<=3.5e7, prod(prob[x])>=0.5)
})))


# ----------------------------------------------------------------------------
# EQUIVALENTLY:

rst=mmFLknapsack(0, data.frame(price, log2(prob), expectVal), lbound, ubound,
  totalSolutionNeeded = 1, tlimit=10)

all(unlist(lapply(rst, function(x)
{
  c(sum(price[x])<=3.5e7, prod(prob[x])>=0.5)
})))
}

