% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FMAT.R
\name{BERT_vocab}
\alias{BERT_vocab}
\title{Check if mask words are in the model vocabulary.}
\usage{
BERT_vocab(
  models,
  mask.words,
  add.tokens = FALSE,
  add.method = c("sum", "mean"),
  add.verbose = TRUE
)
}
\arguments{
\item{models}{A character vector of model names at
\href{https://huggingface.co/models}{HuggingFace}.}

\item{mask.words}{Option words filling in the mask.}

\item{add.tokens}{Add new tokens
(for out-of-vocabulary words or phrases)
to model vocabulary?
Defaults to \code{FALSE}.
It only temporarily adds tokens for tasks
but does not change the raw model file.}

\item{add.method}{Method used to produce the token embeddings of newly added tokens.
Can be \code{"sum"} (default) or \code{"mean"} of subword token embeddings.}

\item{add.verbose}{Print composition information of new tokens
(for out-of-vocabulary words or phrases)?
Defaults to \code{TRUE}.}
}
\value{
A data.table of model name, mask word, real token (replaced if out of vocabulary),
and token id (0~N).
}
\description{
Check if mask words are in the model vocabulary.
}
\examples{
\dontrun{
models = c("bert-base-uncased", "bert-base-cased")
BERT_info(models)

BERT_vocab(models, c("bruce", "Bruce"))

BERT_vocab(models, 2020:2025)  # some are out-of-vocabulary
BERT_vocab(models, 2020:2025, add.tokens=TRUE)  # add vocab

BERT_vocab(models,
           c("individualism", "artificial intelligence"),
           add.tokens=TRUE)
}

}
\seealso{
\code{\link{BERT_download}}

\code{\link{BERT_info}}

\code{\link{FMAT_run}}
}
