% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/basisfns.R
\name{eval_basis}
\alias{eval_basis}
\alias{eval_basis,Basis,matrix-method}
\alias{eval_basis,Basis-matrix-method}
\alias{eval_basis,Basis,SpatialPointsDataFrame-method}
\alias{eval_basis,Basis-SpatialPointsDataFrame-method}
\alias{eval_basis,Basis,SpatialPolygonsDataFrame-method}
\alias{eval_basis,Basis-SpatialPolygonsDataFrame-method}
\alias{eval_basis,Basis,STIDF-method}
\alias{eval_basis,Basis-STIDF-method}
\alias{eval_basis,TensorP_Basis,matrix-method}
\alias{eval_basis,TensorP_Basis-matrix-method}
\alias{eval_basis,TensorP_Basis,STIDF-method}
\alias{eval_basis,TensorP_Basis-STIDF-method}
\alias{eval_basis,TensorP_Basis,STFDF-method}
\alias{eval_basis,TensorP_Basis-STFDF-method}
\title{Evaluate basis functions}
\usage{
eval_basis(basis, s)

\S4method{eval_basis}{Basis,matrix}(basis, s)

\S4method{eval_basis}{Basis,SpatialPointsDataFrame}(basis, s)

\S4method{eval_basis}{Basis,SpatialPolygonsDataFrame}(basis, s)

\S4method{eval_basis}{Basis,STIDF}(basis, s)

\S4method{eval_basis}{TensorP_Basis,matrix}(basis, s)

\S4method{eval_basis}{TensorP_Basis,STIDF}(basis, s)

\S4method{eval_basis}{TensorP_Basis,STFDF}(basis, s)
}
\arguments{
\item{basis}{object of class \code{Basis}}

\item{s}{object of class \code{matrix}, \code{SpatialPointsDataFrame} or \code{SpatialPolygonsDataFrame} containing the spatial locations/footprints}
}
\description{
Evaluate basis functions at points or average functions over polygons.
}
\details{
This function evaluates the basis functions at isolated points, or averages
the basis functions over polygons, for computing the matrix \eqn{S}. The latter
operation is carried out using Monte Carlo integration with 1000 samples per polygon. When
using space-time basis functions, the object must contain a field \code{t} containing a numeric
representation of the time, for example, containing the number of seconds, hours, or days since the first
data point.
}
\examples{
library(sp)

### Create a synthetic dataset
set.seed(1)
d <- data.frame(lon = runif(n=500,min = -179, max = 179),
                lat = runif(n=500,min = -90, max = 90),
                z = rnorm(500))
coordinates(d) <- ~lon + lat
proj4string(d)=CRS("+proj=longlat")

### Now create basis functions on sphere
G <- auto_basis(manifold = sphere(),data=d,
                nres = 2,prune=15,
                type = "bisquare",
                subsamp = 20000)

### Now evaluate basis functions at origin
S <- eval_basis(G,matrix(c(0,0),1,2))
}
\seealso{
\code{\link{auto_basis}} for automatically constructing basis functions.
}
