context("Von Bertalanffy OUTPUT")
# also see test_growthFuns

test_that("vbStarts() output",{
  ## Get some data for the following attempts
  if (require(fishmethods)) {
    data(Kimura)
    ## Returns a list with proper names
    tmp <- vbStarts(length~age,data=Kimura,param="typical")
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("Linf","K","t0"))
    tmp <- vbStarts(length~age,data=Kimura,param="typical",meth0="yngAge")
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("Linf","K","t0"))
    tmp <- vbStarts(length~age,data=Kimura,param="typical",fixed=list(Linf=30))
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("Linf","K","t0"))
    expect_equal(tmp[["Linf"]],30)
    tmp <- vbStarts(length~age,data=Kimura,param="typical",fixed=list(Linf=30,K=0.3))
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("Linf","K","t0"))
    expect_equal(tmp[["Linf"]],30)
    expect_equal(tmp[["K"]],0.3)
    tmp <- vbStarts(length~age,data=Kimura,param="typical",fixed=list(Linf=30,K=0.3,t0=0))
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("Linf","K","t0"))
    expect_equal(tmp[["Linf"]],30)
    expect_equal(tmp[["K"]],0.3)
    expect_equal(tmp[["t0"]],0)
    tmp <- vbStarts(length~age,data=Kimura,param="BevertonHolt")
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("Linf","K","t0"))
    tmp <- vbStarts(length~age,data=Kimura,param="BevertonHolt",meth0="yngAge")
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("Linf","K","t0"))
    tmp <- vbStarts(length~age,data=Kimura,param="original")
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("Linf","K","L0"))
    tmp <- vbStarts(length~age,data=Kimura,param="original",meth0="yngAge")
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("Linf","K","L0"))
    tmp <- vbStarts(length~age,data=Kimura,param="original",fixed=list(Linf=30,K=0.3,L0=2))
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("Linf","K","L0"))
    expect_equal(tmp[["Linf"]],30)
    expect_equal(tmp[["K"]],0.3)
    expect_equal(tmp[["L0"]],2)
    tmp <- vbStarts(length~age,data=Kimura,param="vonBertalanffy")
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("Linf","K","L0"))
    tmp <- vbStarts(length~age,data=Kimura,param="vonBertalanffy",meth0="yngAge")
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("Linf","K","L0"))
    tmp <- vbStarts(length~age,data=Kimura,param="GQ")
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("omega","K","t0"))
    tmp <- vbStarts(length~age,data=Kimura,param="GQ",meth0="yngAge")
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("omega","K","t0"))
    tmp <- vbStarts(length~age,data=Kimura,param="GQ",fixed=list(omega=20,K=0.3,t0=0))
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("omega","K","t0"))
    expect_equal(tmp[["omega"]],20)
    expect_equal(tmp[["K"]],0.3)
    expect_equal(tmp[["t0"]],0)
    tmp <- vbStarts(length~age,data=Kimura,param="GallucciQuinn")
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("omega","K","t0"))
    tmp <- vbStarts(length~age,data=Kimura,param="GallucciQuinn",meth0="yngAge")
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("omega","K","t0"))
    tmp <- vbStarts(length~age,data=Kimura,param="Mooij")
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("Linf","L0","omega"))
    tmp <- vbStarts(length~age,data=Kimura,param="Mooij",meth0="yngAge")
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("Linf","L0","omega"))
    tmp <- vbStarts(length~age,data=Kimura,param="Mooij",fixed=list(Linf=30,L0=2,omega=20))
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("Linf","L0","omega"))
    expect_equal(tmp[["Linf"]],30)
    expect_equal(tmp[["L0"]],2)
    expect_equal(tmp[["omega"]],20)
    tmp <- vbStarts(length~age,data=Kimura,param="Weisberg")
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("Linf","t50","t0"))
    tmp <- vbStarts(length~age,data=Kimura,param="Weisberg",meth0="yngAge")
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("Linf","t50","t0"))
    tmp <- vbStarts(length~age,data=Kimura,param="Weisberg",fixed=list(Linf=30,t50=2,t0=0))
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("Linf","t50","t0"))
    expect_equal(tmp[["Linf"]],30)
    expect_equal(tmp[["t50"]],2)
    expect_equal(tmp[["t0"]],0)
    tmp <- vbStarts(length~age,data=Kimura,param="Schnute",ages2use=c(1,10))
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("L1","L3","K"))
    tmp <- vbStarts(length~age,data=Kimura,param="Schnute",ages2use=c(1,10),methEV="means")
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("L1","L3","K"))
    tmp <- vbStarts(length~age,data=Kimura,param="Schnute",ages2use=c(1,10),
                    fixed=list(L1=15,L3=60,K=0.3))
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("L1","L3","K"))
    expect_equal(tmp[["L1"]],15)
    expect_equal(tmp[["L3"]],60)
    expect_equal(tmp[["K"]],0.3)
    tmp <- vbStarts(length~age,data=Kimura,param="Francis",ages2use=c(1,10))
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("L1","L2","L3"))
    tmp <- vbStarts(length~age,data=Kimura,param="Francis",ages2use=c(1,10),methEV="means")
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("L1","L2","L3"))
    tmp <- vbStarts(length~age,data=Kimura,param="Francis",ages2use=c(1,10),
                    fixed=list(L1=15,L2=40,L3=60))
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("L1","L2","L3"))
    expect_equal(tmp[["L1"]],15)
    expect_equal(tmp[["L2"]],40)
    expect_equal(tmp[["L3"]],60)
    tmp <- vbStarts(length~age,data=Kimura,param="Somers")
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("Linf","K","t0","C","ts"))
    tmp <- vbStarts(length~age,data=Kimura,param="Somers",meth0="yngAge")
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("Linf","K","t0","C","ts"))
    tmp <- vbStarts(length~age,data=Kimura,param="Somers",
                    fixed=list(Linf=30,K=0.3,t0=0,C=0.3,ts=0.5))
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("Linf","K","t0","C","ts"))
    expect_equal(tmp[["Linf"]],30)
    expect_equal(tmp[["K"]],0.3)
    expect_equal(tmp[["t0"]],0)
    expect_equal(tmp[["C"]],0.3)
    expect_equal(tmp[["ts"]],0.5)
    tmp <- vbStarts(length~age,data=Kimura,param="Somers2")
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("Linf","K","t0","C","WP"))
    tmp <- vbStarts(length~age,data=Kimura,param="Somers2",meth0="yngAge")
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("Linf","K","t0","C","WP"))
    tmp <- vbStarts(length~age,data=Kimura,param="Somers2",
                    fixed=list(Linf=30,K=0.3,t0=0,C=0.3,WP=0.5))
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("Linf","K","t0","C","WP"))
    expect_equal(tmp[["Linf"]],30)
    expect_equal(tmp[["K"]],0.3)
    expect_equal(tmp[["t0"]],0)
    expect_equal(tmp[["C"]],0.3)
    expect_equal(tmp[["WP"]],0.5)
    tmp <- vbStarts(length~age,data=Kimura,param="Pauly")
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("Linf","Kpr","t0","ts","NGT"))
    tmp <- vbStarts(length~age,data=Kimura,param="Pauly",meth0="yngAge")
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("Linf","Kpr","t0","ts","NGT"))
    tmp <- vbStarts(length~age,data=Kimura,param="Pauly",
                    fixed=list(Linf=30,Kpr=0.3,t0=0,ts=0.5,NGT=0.2))
    expect_is(tmp,"list")
    expect_equal(names(tmp),c("Linf","Kpr","t0","ts","NGT"))
    expect_equal(tmp[["Linf"]],30)
    expect_equal(tmp[["Kpr"]],0.3)
    expect_equal(tmp[["t0"]],0)
    expect_equal(tmp[["ts"]],0.5)
    expect_equal(tmp[["NGT"]],0.2)
  }  
})
