context("mrOpen() OUTPUT")
source("EXS_mrOpen.R")

test_that("mrOpen() returns",{
  # non-Manly type
  expect_is(cutt,"mrOpen")
  expect_equal(mode(cutt),"list")
  tmp <- summary(cutt)
  expect_is(tmp,"data.frame")
  expect_equal(ncol(tmp),8)
  expect_equal(names(tmp),c("M","M.se","N","N.se","phi","phi.se","B","B.se"))
  tmp <- summary(cutt,parm="N")
  expect_is(tmp,"data.frame")
  expect_equal(ncol(tmp),2)
  expect_equal(names(tmp),c("N","N.se"))
  tmp <- summary(cutt,parm=c("N","phi"))
  expect_is(tmp,"data.frame")
  expect_equal(ncol(tmp),4)
  expect_equal(names(tmp),c("N","N.se","phi","phi.se"))
  tmp <- confint(cutt)
  expect_is(tmp,"data.frame")
  expect_equal(ncol(tmp),6)
  expect_equal(names(tmp),c("N.lci","N.uci","phi.lci","phi.uci","B.lci","B.uci"))
  tmp <- confint(cutt,parm="N")
  expect_is(tmp,"data.frame")
  expect_equal(ncol(tmp),2)
  expect_equal(names(tmp),c("N.lci","N.uci"))
  tmp <- confint(cutt,parm=c("N","phi"))
  expect_is(tmp,"data.frame")
  expect_equal(ncol(tmp),4)
  expect_equal(names(tmp),c("N.lci","N.uci","phi.lci","phi.uci"))
  
  # Manly type
  expect_is(cutt2,"mrOpen")
  expect_equal(mode(cutt2),"list")
  tmp <- summary(cutt2)
  expect_is(tmp,"data.frame")
  expect_equal(ncol(tmp),4)
  expect_equal(names(tmp),c("M","N","phi","B"))
  tmp <- summary(cutt2,parm="N")
  expect_is(tmp,"data.frame")
  expect_equal(ncol(tmp),1)
  expect_equal(names(tmp),"N")
  tmp <- summary(cutt2,parm=c("N","phi"))
  expect_is(tmp,"data.frame")
  expect_equal(ncol(tmp),2)
  expect_equal(names(tmp),c("N","phi"))
  tmp <- suppressMessages(confint(cutt2))
  expect_is(tmp,"data.frame")
  expect_equal(ncol(tmp),4)
  expect_equal(names(tmp),c("N.lci","N.uci","phi.lci","phi.uci"))
  tmp <- confint(cutt2,parm="N")
  expect_is(tmp,"data.frame")
  expect_equal(ncol(tmp),2)
  expect_equal(names(tmp),c("N.lci","N.uci"))
  tmp <- confint(cutt2,parm=c("N","phi"))
  expect_is(tmp,"data.frame")
  expect_equal(ncol(tmp),4)
  expect_equal(names(tmp),c("N.lci","N.uci","phi.lci","phi.uci"))
})

test_that("Does mrOpen() match jolly()",{
  expect_equal(jollyres,jolly(jolly.top,jolly.bot))
})
