#' @title Capture histories (2 sample) of Rainbow Trout.
#' 
#' @description Capture histories for Rainbow Trout (\emph{Oncorhynchus mykiss}) in Upper Niagara Springs pond.
#' 
#' @name RBTroutUNSP
#' 
#' @docType data
#' 
#' @format A data frame with 173 observations on the following 2 variables:
#'  \describe{
#'    \item{first}{Indicator variable for the first sample (1=captured)}
#'    \item{second}{Indicator variable for the second sample (1=captured)}
#'  }
#'  
#' @section Topic(s):
#'  \itemize{
#'    \item Population Size
#'    \item Abundance
#'    \item Mark-Recapture
#'    \item Capture-Recapture 
#'    \item Petersen
#'    \item Capture History 
#'  }
#'  
#' @concept Abundance
#' @concept Population Size
#' @concept Mark-Recapture
#' @concept Capture-Recapture
#' @concept Petersen
#' @concept Capture History
#' 
#' @source Simulated from Table 10 in of Warren, C.D., K.A. Frank, and F.E. Partridge. 2004. Federal Aid in Fish Restoration - 2000 job performance report. Idaho Department of Fish and Game. \href{https://raw.githubusercontent.com/fishR-Core-Team/FSAdata/main/data-raw/RBTroutUNSP.csv}{CSV file}
#' 
#' @keywords datasets
#' 
#' @examples
#' data(RBTroutUNSP)
#' str(RBTroutUNSP)
#' head(RBTroutUNSP)
#' 
NULL