% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectIndividualFeatures.R
\name{selectThreshold}
\alias{selectThreshold}
\title{Select threshold}
\usage{
selectThreshold(threshold = 0.1)
}
\arguments{
\item{threshold}{\itemize{
\item Number between 0 and 1
}}
}
\value{
Returns a direct search function that is used in the feature selection process.
}
\description{
Generates a direct search function that selects the features whose evaluation is over/under a user given threshold (It depends on the method that generates the evaluation measure. For example: under for regression methods, over for classification methods, etc.)(The features evaluation is individual). Features that do not satisfy the threshold, will be removed. This function is called internally within the \code{\link{directSearchAlgorithm}} function.
}
\examples{
\dontrun{ 

## The direct application of this function is an advanced use that consists of using this 
# function directly and performing a direct search process
## Classification problem


# Generates the filter evaluation function
filter_evaluator <- filterEvaluator('determinationCoefficient')

# Generates the direct search function with threshold
st_direct_search <- selectThreshold()
# Performs the direct search process directly (parameters: dataset, target variable and evaluator)
st_direct_search(iris, 'Species', filter_evaluator) 
}
}
\author{
Adan M. Rodriguez

Francisco Aragón Royón
}
