\name{run.strong.peaks}
\alias{run.strong.peaks}
\title{Locate Peaks that are "Large" in All Samples}

\description{
Takes the file generated by \code{\link{run.peaks}}, extracts all peaks that are 
\dQuote{large} in all samples, and writes the results to a file.
}

\usage{
run.strong.peaks(cor.thresh = 0.8, isotope.dist = 7, pre.align = FALSE,
                 align.method = c("PL", "spline", "affine", "none"),
                 align.fcn = NA, root.dir = ".", lrg.dir, 
                 lrg.file = "lrg_peaks.RData", overwrite = FALSE, 
                 use.par.file = FALSE, par.file = "parameters.RData")
}

\arguments{
    \item{cor.thresh}{threshold correlation for declaring isotopes}
    \item{isotope.dist}{maximum distance for declaring isotopes}
    \item{pre.align}{either \code{FALSE}, or a numeric vector of shifts to apply to spectra, or a three-component list (of the form described in the \code{Note} section below) to be used before identifying peaks from different spectra}
    \item{align.method}{alignment algorithm for peaks}
    \item{align.fcn}{function (and inverse) to apply to masses before (and after) applying \code{align.method}; see below}
    \item{root.dir}{directory for parameters file and raw data}
    \item{lrg.dir}{directory for large peaks file; default is \code{paste(root.dir, "/Large_Peaks", sep = "")}}
    \item{lrg.file}{name of file to store large peaks in}
    \item{overwrite}{logical; whether to replace existing files with new ones}
    \item{use.par.file}{logical; if \code{TRUE}, then parameters are read from \code{par.file} in directory \code{root.dir}}
    \item{par.file}{string containing name of parameters file}
}

\details{
Reads in information from file created by \code{\link{run.lrg.peaks}}, locates
peaks which appear in all samples, and overwrites the file \code{lrg.file} in
\code{lrg.dir}.  The resulting file contains variables
\tabular{ll}{ \tab \cr
    \code{amps} \tab data frame of amplitudes of non-isotope peaks that occur in all samples \cr
    \code{centers} \tab data frame of centers of non-isotope peaks that occur in all samples \cr
    \code{lrg.peaks} \tab the data frame of significant peaks created by \code{\link{run.lrg.peaks}} \cr
}
and is ready to be used by \code{\link{run.cluster.matrix}}.
}

\value{
No value returned; the file is simply created.
}

\references{
Barkauskas, D.A. and D.M. Rocke.  (2009a) \dQuote{A general-purpose baseline 
estimation algorithm for spectroscopic data}.  to appear in \emph{Analytica 
Chimica Acta}.  doi:10.1016/j.aca.2009.10.043   

Barkauskas, D.A. \emph{et al}. (2009b) \dQuote{Analysis of MALDI FT-ICR mass 
spectrometry data: A time series approach}.  \emph{Analytica Chimica Acta}, 
\bold{648}:2, 207--214.

Barkauskas, D.A. \emph{et al}. (2009c) \dQuote{Detecting glycan cancer 
biomarkers in serum samples using MALDI FT-ICR mass spectrometry data}.  
\emph{Bioinformatics}, \bold{25}:2, 251--257.

Zhang, L.-K. \emph{et al}. (2005) \dQuote{Accurate mass measurements by Fourier 
transform mass spectrometry}.  \emph{Mass Spectrom Rev}, \bold{24}:2, 286--309.
}

\author{Don Barkauskas (\email{barkda@wald.ucdavis.edu})}

\note{
If \code{use.par.file == TRUE} and other parameters are entered into the function
call, then the parameters entered in the function call overwrite those read in
from the file.  Note that this is opposite from the behavior for
\pkg{\link{FTICRMS}} versions 0.7 and earlier.

If \code{align.fcn} is not \code{NA}, then it should consist of a list with components
\code{fcn} and \code{inv}, each of class \code{function}.  \code{align.fcn$fcn} should
take a vector of masses as its argument and return a vector of transformed masses.
(Typically, this will be transforming to the frequency domain; see Zhang (2005).)
\code{align.fcn$inv} should be the inverse function of \code{align.fcn$fcn}.
If \code{align.method == "leastsq"}, it is strongly recommended that you supply a
value for \code{align.fcn} that makes the masses (approximately) equally-spaced.

\code{align.method} can be abbreviated.  If \code{align.method == "spline"}, 
then alignment consists of making the transformed masses of the strong peaks all
agree exactly with their means, then shifting the rest of the transformed masses
via a cubic interpolation spline generated using
\code{\link[splines]{interpSpline}}.  If \code{align.method == "PL"}, then the
same is done but interpolation is piecewise linear between the strong peaks.  If
\code{align.method == "leastsq"}, then the transformed masses of the strong peaks
are aligned to their means using a least-squares affine fit for each spectrum.
In any of these cases, if there are no strong peaks, \code{align.method} is
changed to \code{"none"} with a warning.  If there is exactly one strong peak,
then alignment is by a simple shift in each spectrum on the transformed masses.
If there are exactly two strong peaks, then the alignment is by a simple affine
transformation on the transformed masses in each spectrum.  If
\code{align.method == "spline"} and there are exactly three strong peaks, then
alignment is piecewise affine on the transformed masses (i.e., identical to
using \code{align.method = "PL"}).

\code{pre.align = FALSE} is used if the spectra have already been aligned by the
mass spectroscopists.  If it is not \code{FALSE}, it can either be a vector of
additive shifts to be applied to the spectra, or a list with components
\code{targets}, \code{actual}, and \code{align.method}.  In the last case,
\code{targets} is a vector of target masses, and \code{actual} is a matrix with
\code{length(targets)} columns and a row for each spectrum, \code{actual[i,j]}
being the mass in spectrum \code{i} that should be matched exactly to
\code{target[j]}, with \code{NA} being a valid entry in \code{actual}.  The
alignment is then done row-by-row as in the description in the above paragraph,
depending on the number of non-missing values in row \code{i}).
}

\seealso{
\code{\link{run.lrg.peaks}}, \code{\link{run.cluster.matrix}}, 
\code{\link[splines]{interpSpline}}
}

\examples{}
