% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmo.R
\name{kmo}
\alias{kmo}
\title{Calculates the Kayser-Meyer-Olkin (KMO)}
\usage{
kmo(x, squared = TRUE)
}
\arguments{
\item{x}{a matrix or dataframe}

\item{squared}{TRUE if matrix is squared (such as adjacency matrices), FALSE otherwise}
}
\value{
A list with \enumerate{
\item \code{overall} - Overall KMO value
\item \code{individual} - Individual KMO's dataframe
\item \code{AIS} - Anti-image Covariance Matrix
\item \code{AIR} - Anti-image Correlation Matrix
}
}
\description{
\code{kmo()} handles both positive definite and not-positive definite matrix by employing the \emph{Moore-Penrose} inverse (pseudoinverse)
}
\examples{
set.seed(123)
df <- as.data.frame(matrix(rnorm(100*10, 1, .5), ncol=10))
kmo(df, squared = FALSE)
}
