% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FarmTest.R
\name{summary.farm.test}
\alias{summary.farm.test}
\title{Summary function of FarmTest}
\usage{
\method{summary}{farm.test}(object, ...)
}
\arguments{
\item{object}{A \code{farm.test} object.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
A data frame including the estimated means, p-values, adjusted p-values and significance for all the features will be presented.
}
\description{
This is the summary function of S3 objects with class "\code{farm.test}".
}
\details{
For two-sample FarmTest, the first column is the difference: estimated means of sample \code{X} - estimated means of sample \code{Y}.
}
\examples{
n = 50
p = 100
K = 3
muX = rep(0, p)
muX[1:5] = 2
epsilonX = matrix(rnorm(p * n, 0, 1), nrow = n)
BX = matrix(runif(p * K, -2, 2), nrow = p)
fX = matrix(rnorm(K * n, 0, 1), nrow = n)
X = rep(1, n) \%*\% t(muX) + fX \%*\% t(BX) + epsilonX
output = farm.test(X)
summary(output)
}
\seealso{
\code{\link{farm.test}}, \code{\link{print.farm.test}} and \code{\link{plot.farm.test}}.
}
