% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ITRDB_FUNCTIONS.R
\name{get_itrdb}
\alias{get_itrdb}
\title{Download the latest version of the ITRDB, and extract given parameters.}
\usage{
get_itrdb(template = NULL, label = NULL, recon.years = NULL,
  calib.years = NULL, species = NULL, measurement.type = NULL,
  chronology.type = NULL, makeSpatial = F, raw.dir = "./RAW/ITRDB/",
  extraction.dir = "./EXTRACTIONS/ITRDB/", force.redo = FALSE)
}
\arguments{
\item{template}{A Raster* or Spatial* object to serve 
as a template for selecting chronologies. If missing, 
all available global chronologies are returned.}

\item{label}{A character string naming the study area.}

\item{recon.years}{A numeric vector of years over which reconstructions are needed; 
if missing, the union of all years in the available chronologies are given.}

\item{calib.years}{A numeric vector of all required years---chronologies without these years will be discarded; 
if missing, all available chronologies are given.}

\item{species}{A character vector of 4-letter tree species identifiers; 
if missing, all available chronologies are given.}

\item{measurement.type}{A character vector of measurement type identifiers. Options include:
\itemize{
\item "Total Ring Density"
\item "Earlywood Width"
\item "Earlywood Density"
\item "Latewood Width"
\item "Minimum Density"
\item "Ring Width"
\item "Latewood Density"
\item "Maximum Density"
\item "Latewood Percent"
}
if missing, all available chronologies are given.}

\item{chronology.type}{A character vector of chronology type identifiers. Options include:
\itemize{
\item "ARSTND"
\item "Low Pass Filter"
\item "Residual"
\item "Standard"
\item "Re-Whitened Residual"
\item "Measurements Only"
}
if missing, all available chronologies are given.}

\item{makeSpatial}{Should the metadata be presented as a SpatialPointsDataFrame? Defaults to FALSE.}

\item{raw.dir}{A character string indicating where raw downloaded files should be put.
The directory will be created if missing. Defaults to "./RAW/ITRDB/".}

\item{extraction.dir}{A character string indicating where the extracted and cropped ITRDB dataset should be put.
The directory will be created if missing. Defaults to "./EXTRACTIONS/ITRDB/".}

\item{force.redo}{If an extraction already exists, should a new one be created? Defaults to FALSE.}
}
\value{
A named list containing the "metadata", "widths", and "depths" data.
}
\description{
\code{get_itrdb} returns a named list of length 3: 
\enumerate{
\item "metadata": A data.table or \code{SpatialPointsDataFrame} (if \code{makeSpatial==TRUE}) of the locations 
and names of extracted ITRDB chrononlogies,
\item "widths": A matrix of tree-ring widths/densities given user selection, and
\item "depths": A matrix of tree-ring sample depths.
}
}
\examples{
\dontrun{
# Extract data for the Village Ecodynamics Project "VEPIIN" study area:
# http://village.anth.wsu.edu
vepPolygon <- polygon_from_extent(raster::extent(672800,740000,4102000,4170000), 
     proj4string="+proj=utm +datum=NAD83 +zone=12")

# Get the ITRDB records
ITRDB <- get_itrdb(template=vepPolygon, label="VEPIIN", makeSpatial=T)

# Plot the VEP polygon
plot(vepPolygon)

# Map the locations of the tree ring chronologies
plot(ITRDB$metadata, pch=1, add=T)
legend('bottomleft', pch=1, legend="ITRDB chronologies")
}
}

