% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ITRDB_FUNCTIONS.R
\name{get_itrdb}
\alias{get_itrdb}
\title{Download the latest version of the ITRDB, and extract given parameters.}
\usage{
get_itrdb(
  template = NULL,
  label = NULL,
  recon.years = NULL,
  calib.years = NULL,
  species = NULL,
  measurement.type = NULL,
  chronology.type = NULL,
  raw.dir = paste0(tempdir(), "/FedData/raw/itrdb"),
  extraction.dir = ifelse(!is.null(label), paste0(tempdir(),
    "/FedData/extractions/itrdb/", label, "/"), paste0(tempdir(),
    "/FedData/extractions/itrdb")),
  force.redo = FALSE
)
}
\arguments{
\item{template}{An \code{\link[sf:sf]{Simple Feature}}
or \code{\link[terra:SpatRaster-class]{SpatRaster}} object to serve as a template for cropping.
If missing,
all available global chronologies are returned.}

\item{label}{A character string naming the study area.}

\item{recon.years}{A numeric vector of years over which reconstructions are needed;
if missing, the union of all years in the available chronologies are given.}

\item{calib.years}{A numeric vector of all required years---chronologies without these years will be discarded;
if missing, all available chronologies are given.}

\item{species}{A character vector of 4-letter tree species identifiers;
if missing, all available chronologies are given.}

\item{measurement.type}{A character vector of measurement type identifiers. Options include:
\itemize{
\item 'Total Ring Density'
\item 'Earlywood Width'
\item 'Earlywood Density'
\item 'Latewood Width'
\item 'Minimum Density'
\item 'Ring Width'
\item 'Latewood Density'
\item 'Maximum Density'
\item 'Latewood Percent'
}
if missing, all available chronologies are given.}

\item{chronology.type}{A character vector of chronology type identifiers. Options include:
\itemize{
\item 'ARSTND'
\item 'Low Pass Filter'
\item 'Residual'
\item 'Standard'
\item 'Re-Whitened Residual'
\item 'Measurements Only'
}
if missing, all available chronologies are given.}

\item{raw.dir}{A character string indicating where raw downloaded files should be put.
The directory will be created if missing.}

\item{extraction.dir}{A character string indicating where the extracted and cropped ITRDB dataset should be put.
The directory will be created if missing.}

\item{force.redo}{If an extraction already exists, should a new one be created? Defaults to FALSE.}
}
\value{
A named list containing the 'metadata', 'widths', and 'depths' data.
}
\description{
\code{get_itrdb} returns a named list of length 3:
\enumerate{
\item 'metadata': A data frame or \code{\link[sf:sf]{Simple Feature}} (if \code{makeSpatial==TRUE}) of the locations
and names of extracted ITRDB chronologies,
\item 'widths': A matrix of tree-ring widths/densities given user selection, and
\item 'depths': A matrix of tree-ring sample depths.
}
}
\examples{
\donttest{
# Get the ITRDB records
ITRDB <- get_itrdb(template = FedData::meve, 
label = "meve")

# Plot the VEP polygon
plot(meve)

# Map the locations of the tree ring chronologies
plot(ITRDB$metadata$geometry, pch = 1, add = TRUE)
legend("bottomleft", pch = 1, legend = "ITRDB chronologies")
}
}
