% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_split_families.R
\name{split_families}
\alias{split_families}
\title{Split a population of genotypes randomly into several locations.}
\usage{
split_families(l = NULL, data = NULL)
}
\arguments{
\item{l}{Number of locations.}

\item{data}{Data frame with the entry (ENTRY) and the labels of each treatment (NAME)
and number of individuals per family group (FAMILY).}
}
\value{
A list with two elements.
\itemize{
  \item \code{rowsEachlist} is a table with a summary of cases.
  \item \code{data_locations} is a data frame with the entries for each location
}
}
\description{
Split a population of genotypes randomly into several locations, with the
aim of having approximatelly the same number of replicates of each genotype, line or
treatment per location.
}
\examples{
# Example 1: Split a population of 3000 and 200 families into 8 locations. 
# Original dataset is been simulated.
set.seed(77)
N <- 2000; families <- 100
ENTRY <- 1:N
NAME <- paste0("SB-", 1:N)
FAMILY <- vector(mode = "numeric", length = N)
x <- 1:N
for (i in x) { FAMILY[i] <- sample(1:families, size = 1, replace = TRUE) }
gen.list <- data.frame(list(ENTRY = ENTRY, NAME = NAME, FAMILY = FAMILY))
head(gen.list)
# Now we are going to use the split_families() function.
split_population <- split_families(l = 8, data = gen.list)
print(split_population)
summary(split_population)
head(split_population$data_locations,12)

}
\author{
Didier Murillo [aut],
        Salvador Gezan [aut],
        Ana Heilman [ctb],
        Thomas Walk [ctb], 
        Johan Aparicio [ctb], 
        Richard Horsley [ctb]
}
