#' @title density_plots
#'
#' @description Function plots a density plot set for phi/psi angle distributions, Fi-score and normalised B-factor. As well as 3D visualisation of angle distribution for every residue. The plots can be used for a quick assessment of the overall parameters.
#'
#' @param pdb_df Requires a PDB data frame generated by PDB_prepare
#' @param model_report Optional parameter to include data from cluster_ID
#' @return  multiple plots
#' @ImportFrom lattice cloud
#' @ImportFrom lattice densityplot
#' @ImportFrom  methods show
#' @ImportFrom  dplyr rename
#' @export
#' @examples
#' path_to_processed_PDB<- system.file("extdata", "pdb_df.tabular", package="Fiscore")
#' # basic usage of density_plots
#' pdb_df<-read.table(path_to_processed_PDB)
#' density_plots(pdb_df)

density_plots<-function(pdb_df, model_report){

  #plot structures

  #rename
  pdb_df<-dplyr::rename(pdb_df,   "aa_number"="df_resno")

  p1<-lattice::cloud(aa_number~phi*psi, data=pdb_df, group = pdb_df$"Type",            auto.key = TRUE)
  methods::show(p1)

  p2<-lattice::densityplot(~ phi, groups = pdb_df$"Type", data = pdb_df,
              plot.points = FALSE, auto.key = TRUE)
  methods::show(p2)

  p3<-lattice::densityplot(~ psi, groups = pdb_df$"Type", data = pdb_df,
              plot.points = FALSE, auto.key = TRUE)
  methods::show(p3)

  p4<-lattice::densityplot(~ B_normalised, groups = pdb_df$"Type", data = pdb_df,
              plot.points = FALSE, auto.key = TRUE)
  methods::show(p4)

  p5<-lattice::densityplot(~ Fi_score, groups = pdb_df$"Type", data = pdb_df, plot.points = FALSE, auto.key = TRUE)
  methods::show(p5)

  if(!missing(model_report))
  {p6<-lattice::densityplot(~ Cluster, groups = pdb_df$"Type", data = model_report, plot.points = FALSE, auto.key = TRUE)
  methods::show(p6)
    }


}
