% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.data.R
\name{prepare.data}
\alias{prepare.data}
\title{Prepare Raw Respirometry Data}
\usage{
prepare.data(import.file, export.file,
             date.format = c("DMY", "MDY", "YMD"),
             DO.low = NA, DO.high = NA,
             Temp.low = NA, Temp.high = NA)
}
\arguments{
\item{import.file}{the name of a file with raw respirometry data which should be imported for raw data preparation}

\item{export.file}{the name of a file with results of raw data preparation}

\item{date.format}{string: date format (DMY, MDY or YMD), where D = day, M = month, Y - year.}

\item{DO.low}{numeric: the low threshold defining a minimum accepted value for dissolved oxygen (DO)}

\item{DO.high}{numeric: the high threshold defining a maximum accepted value for dissolved oxygen (DO)}

\item{Temp.low}{numeric: the low threshold defining a minimum accepted value for water temperature (Temp)}

\item{Temp.high}{numeric: the high threshold defining a maximum accepted value for water temperature (Temp)}
}
\value{
The function exports a data file with one second interval between measurement points and excluded data beyond the defined threshold(s)
}
\description{
This function is used for preparation of raw data in the FishResp format before the actual respirometry analysis. As namely, the function will create measurement points for each second (the required FishResp format) if the time interval between two measurement points is more than one second. In addition, low and high thresold for both dissolved oxygen and water temperature might be applied here. The measurement points beyond the threshold(s) will be transformed to NA (be careful if use the 'parallel' method for background respiration correction as it might transform DO or Temp to NA as well).
}
\examples{
\dontrun{
amphipod.path = system.file("extdata/amphipod/amphipod.txt",
                 package = "FishResp")

prepare.data(import.file = amphipod.path,
             export.file = "amphipod_corrected.txt",
             date.format = "DMY",
             DO.low = 0.5,
             DO.high = 12)
}
}
