% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densities.R
\name{dBeta_mu}
\alias{dBeta_mu}
\title{Beta probability density function}
\usage{
dBeta_mu(x, mu, phi)
}
\arguments{
\item{x}{a vector of quantiles.}

\item{mu}{the mean parameter. It must lie in (0, 1).}

\item{phi}{the precision parameter. It must be a positive real value.}
}
\value{
A vector with the same length as \code{x}.
}
\description{
The function computes the probability density function of the beta distribution with a mean-precision parameterization.
}
\details{
The beta distribution has density
\deqn{\frac{\Gamma{(\phi)}}{\Gamma{(\mu\phi)}\Gamma{((1-\mu)\phi)}}x^{\mu\phi-1}(1-x)^{(1-\mu)\phi-1}}
for \eqn{0<x<1}, where \eqn{0<\mu<1} identifies the mean and \eqn{\phi>0} is the precision parameter.
}
\examples{
dBeta_mu(x = c(.5,.7,.8), mu = 0.3, phi = 20)

}
\references{
{
Ferrari, S.L.P., and Cribari-Neto, F. (2004). Beta Regression for Modeling Rates and Proportions. Journal of Applied Statistics, \bold{31}(7), 799--815. doi:10.1080/0266476042000214501
}
}
