// Generated by rstantools.  Do not edit by hand.

/*
    FlexReg is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    FlexReg is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with FlexReg.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_VIB1_phi_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 20, column 1 to column 16)",
                                                      " (in 'string', line 21, column 1 to column 19)",
                                                      " (in 'string', line 22, column 1 to column 15)",
                                                      " (in 'string', line 23, column 1 to column 25)",
                                                      " (in 'string', line 24, column 1 to column 25)",
                                                      " (in 'string', line 27, column 1 to column 32)",
                                                      " (in 'string', line 28, column 1 to column 25)",
                                                      " (in 'string', line 29, column 1 to column 23)",
                                                      " (in 'string', line 30, column 1 to column 23)",
                                                      " (in 'string', line 31, column 1 to column 23)",
                                                      " (in 'string', line 32, column 1 to column 23)",
                                                      " (in 'string', line 33, column 1 to column 32)",
                                                      " (in 'string', line 34, column 1 to column 28)",
                                                      " (in 'string', line 43, column 2 to column 27)",
                                                      " (in 'string', line 42, column 6 to line 43, column 27)",
                                                      " (in 'string', line 41, column 2 to column 29)",
                                                      " (in 'string', line 40, column 6 to line 43, column 27)",
                                                      " (in 'string', line 39, column 2 to column 21)",
                                                      " (in 'string', line 38, column 6 to line 43, column 27)",
                                                      " (in 'string', line 37, column 2 to column 27)",
                                                      " (in 'string', line 36, column 1 to line 43, column 27)",
                                                      " (in 'string', line 47, column 2 to column 24)",
                                                      " (in 'string', line 46, column 6 to line 47, column 24)",
                                                      " (in 'string', line 45, column 2 to column 21)",
                                                      " (in 'string', line 44, column 1 to line 47, column 24)",
                                                      " (in 'string', line 50, column 1 to column 28)",
                                                      " (in 'string', line 51, column 1 to column 24)",
                                                      " (in 'string', line 53, column 1 to column 28)",
                                                      " (in 'string', line 54, column 1 to column 24)",
                                                      " (in 'string', line 48, column 15 to line 55, column 2)",
                                                      " (in 'string', line 48, column 1 to line 55, column 2)",
                                                      " (in 'string', line 87, column 1 to column 19)",
                                                      " (in 'string', line 92, column 2 to column 102)",
                                                      " (in 'string', line 90, column 2 to column 25)",
                                                      " (in 'string', line 89, column 0 to line 92, column 102)",
                                                      " (in 'string', line 88, column 14 to line 93, column 2)",
                                                      " (in 'string', line 88, column 1 to line 93, column 2)",
                                                      " (in 'string', line 63, column 2 to column 39)",
                                                      " (in 'string', line 62, column 6 to line 63, column 39)",
                                                      " (in 'string', line 61, column 2 to column 39)",
                                                      " (in 'string', line 60, column 1 to line 63, column 39)",
                                                      " (in 'string', line 59, column 16 to line 64, column 2)",
                                                      " (in 'string', line 59, column 1 to line 64, column 2)",
                                                      " (in 'string', line 69, column 2 to column 37)",
                                                      " (in 'string', line 68, column 6 to line 69, column 37)",
                                                      " (in 'string', line 67, column 2 to column 37)",
                                                      " (in 'string', line 66, column 1 to line 69, column 37)",
                                                      " (in 'string', line 65, column 16 to line 70, column 2)",
                                                      " (in 'string', line 65, column 1 to line 70, column 2)",
                                                      " (in 'string', line 75, column 2 to column 43)",
                                                      " (in 'string', line 74, column 6 to line 75, column 43)",
                                                      " (in 'string', line 73, column 2 to column 43)",
                                                      " (in 'string', line 72, column 1 to line 75, column 43)",
                                                      " (in 'string', line 71, column 17 to line 76, column 2)",
                                                      " (in 'string', line 71, column 1 to line 76, column 2)",
                                                      " (in 'string', line 82, column 1 to line 83, column 57)",
                                                      " (in 'string', line 80, column 2 to column 23)",
                                                      " (in 'string', line 79, column 1 to line 83, column 57)",
                                                      " (in 'string', line 78, column 14 to line 84, column 1)",
                                                      " (in 'string', line 78, column 1 to line 84, column 1)",
                                                      " (in 'string', line 2, column 1 to column 16)",
                                                      " (in 'string', line 3, column 8 to column 9)",
                                                      " (in 'string', line 3, column 1 to column 16)",
                                                      " (in 'string', line 4, column 1 to column 16)",
                                                      " (in 'string', line 5, column 1 to column 17)",
                                                      " (in 'string', line 6, column 1 to column 16)",
                                                      " (in 'string', line 7, column 8 to column 9)",
                                                      " (in 'string', line 7, column 10 to column 11)",
                                                      " (in 'string', line 7, column 1 to column 18)",
                                                      " (in 'string', line 8, column 8 to column 9)",
                                                      " (in 'string', line 8, column 10 to column 12)",
                                                      " (in 'string', line 8, column 1 to column 20)",
                                                      " (in 'string', line 9, column 8 to column 9)",
                                                      " (in 'string', line 9, column 10 to column 11)",
                                                      " (in 'string', line 9, column 1 to column 18)",
                                                      " (in 'string', line 10, column 1 to column 27)",
                                                      " (in 'string', line 11, column 1 to column 30)",
                                                      " (in 'string', line 12, column 1 to column 32)",
                                                      " (in 'string', line 13, column 1 to column 22)",
                                                      " (in 'string', line 14, column 1 to column 24)",
                                                      " (in 'string', line 15, column 1 to column 28)",
                                                      " (in 'string', line 16, column 1 to column 29)",
                                                      " (in 'string', line 17, column 1 to column 21)",
                                                      " (in 'string', line 20, column 8 to column 9)",
                                                      " (in 'string', line 21, column 8 to column 10)",
                                                      " (in 'string', line 22, column 8 to column 9)",
                                                      " (in 'string', line 27, column 25 to column 26)",
                                                      " (in 'string', line 28, column 17 to column 18)",
                                                      " (in 'string', line 29, column 17 to column 18)",
                                                      " (in 'string', line 30, column 17 to column 18)",
                                                      " (in 'string', line 31, column 17 to column 18)",
                                                      " (in 'string', line 32, column 17 to column 18)",
                                                      " (in 'string', line 33, column 26 to column 27)",
                                                      " (in 'string', line 87, column 8 to column 9)"};
#include <stan_meta_header.hpp>
class model_VIB1_phi final : public model_base_crtp<model_VIB1_phi> {
private:
  int N;
  Eigen::Matrix<double, -1, 1> y;
  int K;
  int K1;
  int H;
  Eigen::Matrix<double, -1, -1> X;
  Eigen::Matrix<double, -1, -1> X1;
  Eigen::Matrix<double, -1, -1> Z;
  int link_code_mu;
  int link_prior_beta;
  int link_prior_omega1;
  double hyperprior_beta;
  double hyperprior_omega1;
  int link_code_phi;
  int link_prior_psi;
  double hyperprior_psi;
 
public:
  ~model_VIB1_phi() { }
  
  inline std::string model_name() const final { return "model_VIB1_phi"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_VIB1_phi(stan::io::var_context& context__,
                 unsigned int random_seed__ = 0,
                 std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_VIB1_phi_namespace::model_VIB1_phi";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 61;
      context__.validate_dims("data initialization","N","int",
          context__.to_vec());
      N = std::numeric_limits<int>::min();
      
      current_statement__ = 61;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 61;
      current_statement__ = 61;
      check_greater_or_equal(function__, "N", N, 1);
      current_statement__ = 62;
      validate_non_negative_index("y", "N", N);
      current_statement__ = 63;
      context__.validate_dims("data initialization","y","double",
          context__.to_vec(N));
      y = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(y, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> y_flat__;
        current_statement__ = 63;
        assign(y_flat__, nil_index_list(), context__.vals_r("y"),
          "assigning variable y_flat__");
        current_statement__ = 63;
        pos__ = 1;
        current_statement__ = 63;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 63;
          assign(y, cons_list(index_uni(sym1__), nil_index_list()),
            y_flat__[(pos__ - 1)], "assigning variable y");
          current_statement__ = 63;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 64;
      context__.validate_dims("data initialization","K","int",
          context__.to_vec());
      K = std::numeric_limits<int>::min();
      
      current_statement__ = 64;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 64;
      current_statement__ = 64;
      check_greater_or_equal(function__, "K", K, 1);
      current_statement__ = 65;
      context__.validate_dims("data initialization","K1","int",
          context__.to_vec());
      K1 = std::numeric_limits<int>::min();
      
      current_statement__ = 65;
      K1 = context__.vals_i("K1")[(1 - 1)];
      current_statement__ = 65;
      current_statement__ = 65;
      check_greater_or_equal(function__, "K1", K1, 1);
      current_statement__ = 66;
      context__.validate_dims("data initialization","H","int",
          context__.to_vec());
      H = std::numeric_limits<int>::min();
      
      current_statement__ = 66;
      H = context__.vals_i("H")[(1 - 1)];
      current_statement__ = 66;
      current_statement__ = 66;
      check_greater_or_equal(function__, "H", H, 1);
      current_statement__ = 67;
      validate_non_negative_index("X", "N", N);
      current_statement__ = 68;
      validate_non_negative_index("X", "K", K);
      current_statement__ = 69;
      context__.validate_dims("data initialization","X","double",
          context__.to_vec(N, K));
      X = Eigen::Matrix<double, -1, -1>(N, K);
      stan::math::fill(X, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 69;
        assign(X_flat__, nil_index_list(), context__.vals_r("X"),
          "assigning variable X_flat__");
        current_statement__ = 69;
        pos__ = 1;
        current_statement__ = 69;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 69;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 69;
            assign(X,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              X_flat__[(pos__ - 1)], "assigning variable X");
            current_statement__ = 69;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 70;
      validate_non_negative_index("X1", "N", N);
      current_statement__ = 71;
      validate_non_negative_index("X1", "K1", K1);
      current_statement__ = 72;
      context__.validate_dims("data initialization","X1","double",
          context__.to_vec(N, K1));
      X1 = Eigen::Matrix<double, -1, -1>(N, K1);
      stan::math::fill(X1, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> X1_flat__;
        current_statement__ = 72;
        assign(X1_flat__, nil_index_list(), context__.vals_r("X1"),
          "assigning variable X1_flat__");
        current_statement__ = 72;
        pos__ = 1;
        current_statement__ = 72;
        for (int sym1__ = 1; sym1__ <= K1; ++sym1__) {
          current_statement__ = 72;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 72;
            assign(X1,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              X1_flat__[(pos__ - 1)], "assigning variable X1");
            current_statement__ = 72;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 73;
      validate_non_negative_index("Z", "N", N);
      current_statement__ = 74;
      validate_non_negative_index("Z", "H", H);
      current_statement__ = 75;
      context__.validate_dims("data initialization","Z","double",
          context__.to_vec(N, H));
      Z = Eigen::Matrix<double, -1, -1>(N, H);
      stan::math::fill(Z, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> Z_flat__;
        current_statement__ = 75;
        assign(Z_flat__, nil_index_list(), context__.vals_r("Z"),
          "assigning variable Z_flat__");
        current_statement__ = 75;
        pos__ = 1;
        current_statement__ = 75;
        for (int sym1__ = 1; sym1__ <= H; ++sym1__) {
          current_statement__ = 75;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 75;
            assign(Z,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              Z_flat__[(pos__ - 1)], "assigning variable Z");
            current_statement__ = 75;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 76;
      context__.validate_dims("data initialization","link_code_mu","int",
          context__.to_vec());
      link_code_mu = std::numeric_limits<int>::min();
      
      current_statement__ = 76;
      link_code_mu = context__.vals_i("link_code_mu")[(1 - 1)];
      current_statement__ = 76;
      current_statement__ = 76;
      check_greater_or_equal(function__, "link_code_mu", link_code_mu, 1);
      current_statement__ = 77;
      context__.validate_dims("data initialization","link_prior_beta","int",
          context__.to_vec());
      link_prior_beta = std::numeric_limits<int>::min();
      
      current_statement__ = 77;
      link_prior_beta = context__.vals_i("link_prior_beta")[(1 - 1)];
      current_statement__ = 77;
      current_statement__ = 77;
      check_greater_or_equal(function__, "link_prior_beta", link_prior_beta,
                             1);
      current_statement__ = 78;
      context__.validate_dims("data initialization","link_prior_omega1",
          "int",context__.to_vec());
      link_prior_omega1 = std::numeric_limits<int>::min();
      
      current_statement__ = 78;
      link_prior_omega1 = context__.vals_i("link_prior_omega1")[(1 - 1)];
      current_statement__ = 78;
      current_statement__ = 78;
      check_greater_or_equal(function__, "link_prior_omega1",
                             link_prior_omega1, 1);
      current_statement__ = 79;
      context__.validate_dims("data initialization","hyperprior_beta",
          "double",context__.to_vec());
      hyperprior_beta = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 79;
      hyperprior_beta = context__.vals_r("hyperprior_beta")[(1 - 1)];
      current_statement__ = 80;
      context__.validate_dims("data initialization","hyperprior_omega1",
          "double",context__.to_vec());
      hyperprior_omega1 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 80;
      hyperprior_omega1 = context__.vals_r("hyperprior_omega1")[(1 - 1)];
      current_statement__ = 81;
      context__.validate_dims("data initialization","link_code_phi","int",
          context__.to_vec());
      link_code_phi = std::numeric_limits<int>::min();
      
      current_statement__ = 81;
      link_code_phi = context__.vals_i("link_code_phi")[(1 - 1)];
      current_statement__ = 81;
      current_statement__ = 81;
      check_greater_or_equal(function__, "link_code_phi", link_code_phi, 2);
      current_statement__ = 82;
      context__.validate_dims("data initialization","link_prior_psi","int",
          context__.to_vec());
      link_prior_psi = std::numeric_limits<int>::min();
      
      current_statement__ = 82;
      link_prior_psi = context__.vals_i("link_prior_psi")[(1 - 1)];
      current_statement__ = 82;
      current_statement__ = 82;
      check_greater_or_equal(function__, "link_prior_psi", link_prior_psi, 1);
      current_statement__ = 83;
      context__.validate_dims("data initialization","hyperprior_psi",
          "double",context__.to_vec());
      hyperprior_psi = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 83;
      hyperprior_psi = context__.vals_r("hyperprior_psi")[(1 - 1)];
      current_statement__ = 84;
      validate_non_negative_index("beta", "K", K);
      current_statement__ = 85;
      validate_non_negative_index("omega1", "K1", K1);
      current_statement__ = 86;
      validate_non_negative_index("psi", "H", H);
      current_statement__ = 87;
      validate_non_negative_index("mu", "N", N);
      current_statement__ = 88;
      validate_non_negative_index("phi", "N", N);
      current_statement__ = 89;
      validate_non_negative_index("b1", "N", N);
      current_statement__ = 90;
      validate_non_negative_index("b2", "N", N);
      current_statement__ = 91;
      validate_non_negative_index("a1", "N", N);
      current_statement__ = 92;
      validate_non_negative_index("a2", "N", N);
      current_statement__ = 93;
      validate_non_negative_index("q1", "N", N);
      current_statement__ = 94;
      validate_non_negative_index("log_lik", "N", N);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += K;
      num_params_r__ += K1;
      num_params_r__ += H;
      num_params_r__ += 1;
      num_params_r__ += 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_VIB1_phi_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> beta;
      beta = Eigen::Matrix<local_scalar_t__, -1, 1>(K);
      stan::math::fill(beta, DUMMY_VAR__);
      
      current_statement__ = 1;
      beta = in__.vector(K);
      Eigen::Matrix<local_scalar_t__, -1, 1> omega1;
      omega1 = Eigen::Matrix<local_scalar_t__, -1, 1>(K1);
      stan::math::fill(omega1, DUMMY_VAR__);
      
      current_statement__ = 2;
      omega1 = in__.vector(K1);
      Eigen::Matrix<local_scalar_t__, -1, 1> psi;
      psi = Eigen::Matrix<local_scalar_t__, -1, 1>(H);
      stan::math::fill(psi, DUMMY_VAR__);
      
      current_statement__ = 3;
      psi = in__.vector(H);
      local_scalar_t__ k;
      k = DUMMY_VAR__;
      
      current_statement__ = 4;
      k = in__.scalar();
      current_statement__ = 4;
      if (jacobian__) {
        current_statement__ = 4;
        k = stan::math::lub_constrain(k, 0, 1, lp__);
      } else {
        current_statement__ = 4;
        k = stan::math::lub_constrain(k, 0, 1);
      }
      local_scalar_t__ p;
      p = DUMMY_VAR__;
      
      current_statement__ = 5;
      p = in__.scalar();
      current_statement__ = 5;
      if (jacobian__) {
        current_statement__ = 5;
        p = stan::math::lub_constrain(p, 0, 1, lp__);
      } else {
        current_statement__ = 5;
        p = stan::math::lub_constrain(p, 0, 1);
      }
      Eigen::Matrix<local_scalar_t__, -1, 1> mu;
      mu = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(mu, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> phi;
      phi = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(phi, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> b1;
      b1 = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(b1, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> b2;
      b2 = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(b2, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> a1;
      a1 = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(a1, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> a2;
      a2 = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(a2, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> q1;
      q1 = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(q1, DUMMY_VAR__);
      
      current_statement__ = 13;
      assign(q1, nil_index_list(), inv_logit(multiply(X1, omega1)),
        "assigning variable q1");
      current_statement__ = 21;
      if (logical_eq(link_code_mu, 1)) {
        current_statement__ = 20;
        assign(mu, nil_index_list(), inv_logit(multiply(X, beta)),
          "assigning variable mu");
      } else {
        current_statement__ = 19;
        if (logical_eq(link_code_mu, 2)) {
          current_statement__ = 18;
          assign(mu, nil_index_list(), Phi(multiply(X, beta)),
            "assigning variable mu");
        } else {
          current_statement__ = 17;
          if (logical_eq(link_code_mu, 3)) {
            current_statement__ = 16;
            assign(mu, nil_index_list(), inv_cloglog(multiply(X, beta)),
              "assigning variable mu");
          } else {
            current_statement__ = 15;
            if (logical_eq(link_code_mu, 4)) {
              current_statement__ = 14;
              assign(mu, nil_index_list(),
                stan::math::exp(minus(stan::math::exp(multiply(X, beta)))),
                "assigning variable mu");
            } 
          }
        }
      }
      current_statement__ = 25;
      if (logical_eq(link_code_phi, 2)) {
        current_statement__ = 24;
        assign(phi, nil_index_list(), stan::math::exp(multiply(Z, psi)),
          "assigning variable phi");
      } else {
        current_statement__ = 23;
        if (logical_eq(link_code_phi, 3)) {
          current_statement__ = 22;
          assign(phi, nil_index_list(), square(multiply(Z, psi)),
            "assigning variable phi");
        } 
      }
      current_statement__ = 31;
      for (int i = 1; i <= N; ++i) {
        current_statement__ = 26;
        assign(b2, cons_list(index_uni(i), nil_index_list()),
          (((1 - mu[(i - 1)]) * phi[(i - 1)]) * k), "assigning variable b2");
        current_statement__ = 27;
        assign(a2, cons_list(index_uni(i), nil_index_list()),
          ((mu[(i - 1)] * phi[(i - 1)]) * k), "assigning variable a2");
        current_statement__ = 28;
        assign(b1, cons_list(index_uni(i), nil_index_list()),
          (((1 - mu[(i - 1)]) * phi[(i - 1)]) * k), "assigning variable b1");
        current_statement__ = 29;
        assign(a1, cons_list(index_uni(i), nil_index_list()),
          ((mu[(i - 1)] * phi[(i - 1)]) * k), "assigning variable a1");}
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 6;
        current_statement__ = 6;
        check_greater_or_equal(function__, "mu[sym1__]", mu[(sym1__ - 1)], 0);
      }
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 6;
        current_statement__ = 6;
        check_less_or_equal(function__, "mu[sym1__]", mu[(sym1__ - 1)], 1);}
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 7;
        current_statement__ = 7;
        check_greater_or_equal(function__, "phi[sym1__]", phi[(sym1__ - 1)],
                               0);}
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 8;
        current_statement__ = 8;
        check_greater_or_equal(function__, "b1[sym1__]", b1[(sym1__ - 1)], 0);
      }
      current_statement__ = 9;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 9;
        current_statement__ = 9;
        check_greater_or_equal(function__, "b2[sym1__]", b2[(sym1__ - 1)], 0);
      }
      current_statement__ = 10;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 10;
        current_statement__ = 10;
        check_greater_or_equal(function__, "a1[sym1__]", a1[(sym1__ - 1)], 0);
      }
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 11;
        current_statement__ = 11;
        check_greater_or_equal(function__, "a2[sym1__]", a2[(sym1__ - 1)], 0);
      }
      current_statement__ = 12;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 12;
        current_statement__ = 12;
        check_greater_or_equal(function__, "q1[sym1__]", q1[(sym1__ - 1)], 0);
      }
      current_statement__ = 12;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 12;
        current_statement__ = 12;
        check_less_or_equal(function__, "q1[sym1__]", q1[(sym1__ - 1)], 1);}
      {
        current_statement__ = 43;
        for (int l = 1; l <= K; ++l) {
          current_statement__ = 41;
          if (logical_eq(link_prior_beta, 1)) {
            current_statement__ = 40;
            lp_accum__.add(
              normal_lpdf<propto__>(beta[(l - 1)], 0, hyperprior_beta));
          } else {
            current_statement__ = 39;
            if (logical_eq(link_prior_beta, 2)) {
              current_statement__ = 38;
              lp_accum__.add(
                cauchy_lpdf<propto__>(beta[(l - 1)], 0, hyperprior_beta));
            } 
          }}
        current_statement__ = 49;
        for (int l = 1; l <= H; ++l) {
          current_statement__ = 47;
          if (logical_eq(link_prior_psi, 1)) {
            current_statement__ = 46;
            lp_accum__.add(
              normal_lpdf<propto__>(psi[(l - 1)], 0, hyperprior_psi));
          } else {
            current_statement__ = 45;
            if (logical_eq(link_prior_psi, 2)) {
              current_statement__ = 44;
              lp_accum__.add(
                cauchy_lpdf<propto__>(psi[(l - 1)], 0, hyperprior_psi));
            } 
          }}
        current_statement__ = 55;
        for (int l = 1; l <= K1; ++l) {
          current_statement__ = 53;
          if (logical_eq(link_prior_omega1, 1)) {
            current_statement__ = 52;
            lp_accum__.add(
              normal_lpdf<propto__>(omega1[(l - 1)], 0, hyperprior_omega1));
          } else {
            current_statement__ = 51;
            if (logical_eq(link_prior_omega1, 2)) {
              current_statement__ = 50;
              lp_accum__.add(
                cauchy_lpdf<propto__>(omega1[(l - 1)], 0, hyperprior_omega1));
            } 
          }}
        current_statement__ = 60;
        for (int i = 1; i <= N; ++i) {
          current_statement__ = 58;
          if (logical_eq(y[(i - 1)], 1)) {
            current_statement__ = 57;
            lp_accum__.add(stan::math::log(q1[(i - 1)]));
          } else {
            current_statement__ = 56;
            lp_accum__.add(
              (log1m(q1[(i - 1)]) +
                log_mix(p,
                  beta_lpdf<false>(y[(i - 1)], a2[(i - 1)], b2[(i - 1)]),
                  beta_lpdf<false>(y[(i - 1)], a1[(i - 1)], b1[(i - 1)]))));
          }}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_VIB1_phi_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      beta = in__.vector(K);
      Eigen::Matrix<double, -1, 1> omega1;
      omega1 = Eigen::Matrix<double, -1, 1>(K1);
      stan::math::fill(omega1, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      omega1 = in__.vector(K1);
      Eigen::Matrix<double, -1, 1> psi;
      psi = Eigen::Matrix<double, -1, 1>(H);
      stan::math::fill(psi, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      psi = in__.vector(H);
      double k;
      k = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      k = in__.scalar();
      current_statement__ = 4;
      k = stan::math::lub_constrain(k, 0, 1);
      double p;
      p = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      p = in__.scalar();
      current_statement__ = 5;
      p = stan::math::lub_constrain(p, 0, 1);
      Eigen::Matrix<double, -1, 1> mu;
      mu = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(mu, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> phi;
      phi = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(phi, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> b1;
      b1 = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(b1, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> b2;
      b2 = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(b2, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> a1;
      a1 = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(a1, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> a2;
      a2 = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(a2, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> q1;
      q1 = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(q1, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K1; ++sym1__) {
        vars__.emplace_back(omega1[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= H; ++sym1__) {
        vars__.emplace_back(psi[(sym1__ - 1)]);}
      vars__.emplace_back(k);
      vars__.emplace_back(p);
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 13;
      assign(q1, nil_index_list(), inv_logit(multiply(X1, omega1)),
        "assigning variable q1");
      current_statement__ = 21;
      if (logical_eq(link_code_mu, 1)) {
        current_statement__ = 20;
        assign(mu, nil_index_list(), inv_logit(multiply(X, beta)),
          "assigning variable mu");
      } else {
        current_statement__ = 19;
        if (logical_eq(link_code_mu, 2)) {
          current_statement__ = 18;
          assign(mu, nil_index_list(), Phi(multiply(X, beta)),
            "assigning variable mu");
        } else {
          current_statement__ = 17;
          if (logical_eq(link_code_mu, 3)) {
            current_statement__ = 16;
            assign(mu, nil_index_list(), inv_cloglog(multiply(X, beta)),
              "assigning variable mu");
          } else {
            current_statement__ = 15;
            if (logical_eq(link_code_mu, 4)) {
              current_statement__ = 14;
              assign(mu, nil_index_list(),
                stan::math::exp(minus(stan::math::exp(multiply(X, beta)))),
                "assigning variable mu");
            } 
          }
        }
      }
      current_statement__ = 25;
      if (logical_eq(link_code_phi, 2)) {
        current_statement__ = 24;
        assign(phi, nil_index_list(), stan::math::exp(multiply(Z, psi)),
          "assigning variable phi");
      } else {
        current_statement__ = 23;
        if (logical_eq(link_code_phi, 3)) {
          current_statement__ = 22;
          assign(phi, nil_index_list(), square(multiply(Z, psi)),
            "assigning variable phi");
        } 
      }
      current_statement__ = 31;
      for (int i = 1; i <= N; ++i) {
        current_statement__ = 26;
        assign(b2, cons_list(index_uni(i), nil_index_list()),
          (((1 - mu[(i - 1)]) * phi[(i - 1)]) * k), "assigning variable b2");
        current_statement__ = 27;
        assign(a2, cons_list(index_uni(i), nil_index_list()),
          ((mu[(i - 1)] * phi[(i - 1)]) * k), "assigning variable a2");
        current_statement__ = 28;
        assign(b1, cons_list(index_uni(i), nil_index_list()),
          (((1 - mu[(i - 1)]) * phi[(i - 1)]) * k), "assigning variable b1");
        current_statement__ = 29;
        assign(a1, cons_list(index_uni(i), nil_index_list()),
          ((mu[(i - 1)] * phi[(i - 1)]) * k), "assigning variable a1");}
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 6;
        current_statement__ = 6;
        check_greater_or_equal(function__, "mu[sym1__]", mu[(sym1__ - 1)], 0);
      }
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 6;
        current_statement__ = 6;
        check_less_or_equal(function__, "mu[sym1__]", mu[(sym1__ - 1)], 1);}
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 7;
        current_statement__ = 7;
        check_greater_or_equal(function__, "phi[sym1__]", phi[(sym1__ - 1)],
                               0);}
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 8;
        current_statement__ = 8;
        check_greater_or_equal(function__, "b1[sym1__]", b1[(sym1__ - 1)], 0);
      }
      current_statement__ = 9;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 9;
        current_statement__ = 9;
        check_greater_or_equal(function__, "b2[sym1__]", b2[(sym1__ - 1)], 0);
      }
      current_statement__ = 10;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 10;
        current_statement__ = 10;
        check_greater_or_equal(function__, "a1[sym1__]", a1[(sym1__ - 1)], 0);
      }
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 11;
        current_statement__ = 11;
        check_greater_or_equal(function__, "a2[sym1__]", a2[(sym1__ - 1)], 0);
      }
      current_statement__ = 12;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 12;
        current_statement__ = 12;
        check_greater_or_equal(function__, "q1[sym1__]", q1[(sym1__ - 1)], 0);
      }
      current_statement__ = 12;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 12;
        current_statement__ = 12;
        check_less_or_equal(function__, "q1[sym1__]", q1[(sym1__ - 1)], 1);}
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(mu[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(phi[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(b1[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(b2[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(a1[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(a2[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(q1[(sym1__ - 1)]);}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      Eigen::Matrix<double, -1, 1> log_lik;
      log_lik = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(log_lik, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 37;
      for (int i = 1; i <= N; ++i) {
        current_statement__ = 35;
        if (logical_eq(y[(i - 1)], 1)) {
          current_statement__ = 34;
          assign(log_lik, cons_list(index_uni(i), nil_index_list()),
            stan::math::log(q1[(i - 1)]), "assigning variable log_lik");
        } else {
          current_statement__ = 33;
          assign(log_lik, cons_list(index_uni(i), nil_index_list()),
            (log1m(q1[(i - 1)]) +
              log_mix(p,
                beta_lpdf<false>(y[(i - 1)], a2[(i - 1)], b2[(i - 1)]),
                beta_lpdf<false>(y[(i - 1)], a1[(i - 1)], b1[(i - 1)]))),
            "assigning variable log_lik");
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        vars__.emplace_back(log_lik[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 1;
        assign(beta_flat__, nil_index_list(), context__.vals_r("beta"),
          "assigning variable beta_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 1;
          assign(beta, cons_list(index_uni(sym1__), nil_index_list()),
            beta_flat__[(pos__ - 1)], "assigning variable beta");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> omega1;
      omega1 = Eigen::Matrix<double, -1, 1>(K1);
      stan::math::fill(omega1, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> omega1_flat__;
        current_statement__ = 2;
        assign(omega1_flat__, nil_index_list(), context__.vals_r("omega1"),
          "assigning variable omega1_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= K1; ++sym1__) {
          current_statement__ = 2;
          assign(omega1, cons_list(index_uni(sym1__), nil_index_list()),
            omega1_flat__[(pos__ - 1)], "assigning variable omega1");
          current_statement__ = 2;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> psi;
      psi = Eigen::Matrix<double, -1, 1>(H);
      stan::math::fill(psi, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> psi_flat__;
        current_statement__ = 3;
        assign(psi_flat__, nil_index_list(), context__.vals_r("psi"),
          "assigning variable psi_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= H; ++sym1__) {
          current_statement__ = 3;
          assign(psi, cons_list(index_uni(sym1__), nil_index_list()),
            psi_flat__[(pos__ - 1)], "assigning variable psi");
          current_statement__ = 3;
          pos__ = (pos__ + 1);}
      }
      double k;
      k = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      k = context__.vals_r("k")[(1 - 1)];
      double k_free__;
      k_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      k_free__ = stan::math::lub_free(k, 0, 1);
      double p;
      p = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      p = context__.vals_r("p")[(1 - 1)];
      double p_free__;
      p_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      p_free__ = stan::math::lub_free(p, 0, 1);
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K1; ++sym1__) {
        vars__.emplace_back(omega1[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= H; ++sym1__) {
        vars__.emplace_back(psi[(sym1__ - 1)]);}
      vars__.emplace_back(k_free__);
      vars__.emplace_back(p_free__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("beta");
    names__.emplace_back("omega1");
    names__.emplace_back("psi");
    names__.emplace_back("k");
    names__.emplace_back("p");
    names__.emplace_back("mu");
    names__.emplace_back("phi");
    names__.emplace_back("b1");
    names__.emplace_back("b2");
    names__.emplace_back("a1");
    names__.emplace_back("a2");
    names__.emplace_back("q1");
    names__.emplace_back("log_lik");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K1)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(H)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K1; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "omega1" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= H; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "psi" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "k");
    param_names__.emplace_back(std::string() + "p");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "phi" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "b1" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "b2" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "a1" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "a2" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "q1" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K1; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "omega1" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= H; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "psi" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "k");
    param_names__.emplace_back(std::string() + "p");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "phi" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "b1" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "b2" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "a1" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "a2" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "q1" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"omega1\",\"type\":{\"name\":\"vector\",\"length\":" << K1 << "},\"block\":\"parameters\"},{\"name\":\"psi\",\"type\":{\"name\":\"vector\",\"length\":" << H << "},\"block\":\"parameters\"},{\"name\":\"k\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"p\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"b1\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"b2\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"a1\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"a2\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"q1\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"omega1\",\"type\":{\"name\":\"vector\",\"length\":" << K1 << "},\"block\":\"parameters\"},{\"name\":\"psi\",\"type\":{\"name\":\"vector\",\"length\":" << H << "},\"block\":\"parameters\"},{\"name\":\"k\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"p\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"b1\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"b2\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"a1\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"a2\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"q1\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_VIB1_phi_namespace::model_VIB1_phi;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_VIB1_phi_namespace::profiles__;
}
#endif
#endif
