% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pks.R
\name{pks}
\alias{pks}
\title{Get the flow peaks over a threshold}
\usage{
pks(TS, Dur = 5, Qmax = 0.95)
}
\arguments{
\item{TS}{output from \code{\link{create.ts}} containing a data.frame of flow
time series}

\item{Dur}{numeric value of the minimum number of days between peaks}

\item{Qmax}{numeric value for peaks over threshold quantile.
Default is 0.95.}
}
\value{
Returns a numeric vector of peaks of threshold values in m3/s. The "times"
  attribute contains the date by calendar year, and the "names" attribute contains
  the hydrologic year and hydrologic day of year, e.g., 2012 55.
}
\description{
This function finds the flow peaks over a user defined threshold and declusters to remove
dependent peaks.
}
\details{
Peaks Over Threshold values are calcuated as mean daily streamflow (m3/s)
  minus the threshold streamflow value (m3/s) defined by the 
  input quantile (Qmax). Peaks are identified with \code{\link[evir]{pot}} and 
  the minimum inter-event duration (Dur) is applied by 
  \code{\link[evir]{decluster}}.
}
\examples{
data(cania.sub.ts)
res <- pks(cania.sub.ts)
res2 <- screen.metric(res, "Peak Over Threshold (m3/s)")
}
\author{
Jennifer Dierauer
}
