% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pooled.R
\name{pooled}
\alias{pooled}
\title{Get pooled effect estimates from metaFluMoDL object}
\usage{
pooled(m)
}
\arguments{
\item{m}{An object of class \code{\link{metaFluMoDL}}, holding the results of a
random-effects multivariate meta-analysis of \code{\link{summary.FluMoDL}}
first-stage model summaries}
}
\value{
An object of class \code{\link{summary.FluMoDL}}, holding the pooled
  coefficients and variance-covariance matrices for the three influenza incidence
  proxies (four if \code{\link[=hasRSV]{hasRSV(m)}} is \code{TRUE}). The returned
  object contains the string "pooled" in its \code{$type} element,
  to distinguish it from \code{\link[=summary.FluMoDL]{first-stage model summaries}}
  or \code{\link[=metaFluMoDL]{BLUP summaries}} (Best Linear Unbiased Predictor).
  The returned \code{\link{summary.FluMoDL}} object also has no \code{$pred} element,
  as it is not associated with a particular dataset and cross-basis matrices
  (which is a prerequisite to create \code{\link[dlnm]{crosspred}} objects).
}
\description{
This function returns the pooled effect estimates for all incidence proxy terms
(three for influenza, and optionally for RSV) from a \code{\link{metaFluMoDL}}
object. It returns a \code{\link{summary.FluMoDL}} object that can be
further used in analyses.
}
\references{
\itemize{
 \item Gasparrini A, Armstrong B, Kenward MG. Multivariate meta-analysis for non-linear
  and other multi-parameter associations.
  \href{https://onlinelibrary.wiley.com/doi/full/10.1002/sim.5471}{Stat Med} 2012;31(29):3821–39.
}
}
\seealso{
\code{\link{summary.FluMoDL}}, \code{\link{metaFluMoDL}}
}
