% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_migration_from_trajectories.R
\name{estimate_migration_from_trajectories}
\alias{estimate_migration_from_trajectories}
\title{Estimates migration parameters using trajectories.}
\usage{
estimate_migration_from_trajectories(
  migr,
  trajectories,
  estimate_transitions = TRUE,
  estimate_sojourns = TRUE,
  sojourn_domain = NULL,
  min_prob = 0
)
}
\arguments{
\item{migr}{A migration structure. Required migration fields are: 
site_name, link_knowledge, flight_duration, initial_state, horizon, 
death_probability, observations. Field \emph{transition_law_param} is also required 
if the attribute estimate_transitions is set to FALSE or the 
start_transitions argument is set to NULL. Field 
\emph{sojourn_law_param} is also required if the argument estimate_sojourns 
contains boolean values set to FALSE or if start_sojourns is set to NULL.}

\item{trajectories}{A matrix of birds trajectories.}

\item{estimate_transitions}{If TRUE, transitions probabilities are estimated.
Default value is TRUE.}

\item{estimate_sojourns}{Vector of bool, identifies states for which 
sojourn mean times must be estimated. Default value is TRUE transformed in 
TRUE for every site except for the last one.}

\item{sojourn_domain}{Range (min and max) of the sojourn mean time parameters.
Possible values:
 (i) NULL, all intervals are set to [0, migr$horizon],
 (ii) vector of 2 values min and max then all domains are [min, max] interval,
 (iii) list of interval for each site.
Note that are taken into account only intervals for sites with TRUE in estimate_sojourn arguments.
Default value is  NULL.}

\item{min_prob}{A threshold on the minimal value of the transition 
probabilities. Used, for example, in MCEM to avoid degeneracy. Default is 0.}
}
\value{
The migration structure given with a new attribute 
\emph{estimation_method} which is a structure with 3 attributes:

              . \emph{name} = "from_trajectories",

              . \emph{settings}, a structure with attributes:
                  estimate_transitions,
                  estimate_sojourns, 

              . \emph{output}, a structure with attributes:
              
                    - transition_law_param: estimated transition parameters,
                    
                    - sojourn_law_param: estimated sojourn parameters.
}
\description{
Estimates migration parameters using trajectories.
}
\examples{
migr <- generate_toy_migration()
traj <- generate_trajectories( migr )
estimated_migr <- estimate_migration_from_trajectories( migr, traj ) 
print( estimated_migr$estimation_method$output$transition_law_param )
}
