% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FoReco-package.R
\docType{package}
\name{FoReco-package}
\alias{FoReco-package}
\title{FoReco: point forecast reconciliation}
\description{
An R package offering classical (bottom-up), optimal and heuristic combination
forecast reconciliation procedures for cross-sectional, temporal, and cross-temporal
linearly constrained time series.
}
\details{
The \code{FoReco} package is designed for point forecast reconciliation, a
post-forecasting process aimed to improve the quality of the base
forecasts for a system of linearly constrained (e.g. hierarchical/grouped) time series.
The main functions are:

\describe{
  \item{\code{\link[FoReco]{htsrec}():}}{cross-sectional (contemporaneous) forecast reconciliation.}
  \item{\code{\link[FoReco]{thfrec}():}}{forecast reconciliation for a single time series through temporal hierarchies.}
  \item{\code{\link[FoReco]{tcsrec}():}}{heuristic first-temporal-then-cross-sectional cross-temporal forecast reconciliation.}
  \item{\code{\link[FoReco]{cstrec}():}}{heuristic first-cross-sectional-then-temporal cross-temporal forecast reconciliation.}
  \item{\code{\link[FoReco]{iterec}():}}{heuristic iterative cross-temporal forecast reconciliation.}
  \item{\code{\link[FoReco]{octrec}():}}{optimal combination cross-temporal forecast reconciliation.}
}
}
\references{
Di Fonzo, T., Girolimetto, D. (2020), Cross-Temporal Forecast Reconciliation:
Optimal Combination Method and Heuristic Alternatives, Department of Statistical
Sciences, University of Padua, \href{https://arxiv.org/abs/2006.08570}{arXiv:2006.08570}.
}
\author{
Tommaso Di Fonzo and Daniele Girolimetto, Department of Statistical Sciences, University of Padua (Italy).
}
\keyword{package}
