% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complete_controls.R
\name{complete-controls}
\alias{complete-controls}
\alias{complete_algorithm_control}
\alias{complete_entropy_control}
\alias{complete_spectrum_control}
\title{Completes several control settings}
\usage{
complete_algorithm_control(
  algorithm.control = list(max.iter = 50, num.starts = 10, tol = 0.001, type = "EM")
)

complete_entropy_control(
  entropy.control = list(base = NULL, method = "MLE", prior.probs = NULL, prior.weight
    = 0.001, threshold = 0),
  num.outcomes
)

complete_spectrum_control(
  spectrum.control = list(kernel = NULL, method = c("wosa", "direct", "multitaper",
    "mvspec", "ar", "pgram"), smoothing = FALSE)
)
}
\arguments{
\item{algorithm.control}{list; control parameters for any \emph{iterative} ForeCA 
algorithm.}

\item{entropy.control}{list; control settings for entropy estimation.}

\item{num.outcomes}{positive integer; number of outcomes for the discrete probability
distribution. Must be specified (no default value).}

\item{spectrum.control}{list; control settings for spectrum estimation.}
}
\value{
A list with fully specified algorithm, entropy, or spectrum controls. 
Default values are only added if the input \code{{spectrum,entropy,algorithm}.control} 
list does not already set this value.

\code{complete_algorithm_control} returns a list containing:

\item{max.iter}{maximum number of iterations; default: \code{50}.}
\item{num.starts}{number of random starts to avoid local optima; default: \code{10}.}
\item{tol}{tolerance for when convergence is reached in any \emph{iterative} 
ForeCA algorithm;  default: \code{1e-03}.}
\item{type}{string; type of algorithm. Default: \code{'EM'}.}

\code{complete_entropy_control} returns a list with:

\item{base}{logarithm base for the entropy.}
\item{method}{string; method to estimate entropy; default: \code{"MLE"}.}
\item{prior.probs}{prior distribution; default: uniform 
\code{rep(1 / num.outcomes, num.outcomes)}.}
\item{prior.weight}{weight of the prior distribution; default: \code{1e-3}.}
\item{threshold}{non-negative float; set probabilities below threshold to 
zero;  default: \code{0}.}

\code{complete_spectrum_control} returns a list containing:

\item{kernel}{R function; function to weigh each Fourier frequency \eqn{\lambda}; 
default: \code{NULL} (no re-weighting).}
\item{method}{string; method to estimate the spectrum; default: 
\code{'wosa'} if \pkg{sapa} is installed, \code{'mvspec'} 
if only \pkg{astsa} is installed, and \code{'pgram'} if
neither is installed.}
\item{smoothing}{logical; default: \code{FALSE}.}

Available methods for spectrum estimation are (alphabetical order)

\item{"ar"}{ autoregressive spectrum fit via \code{\link[stats]{spec.ar}}; 
only for univariate time series.}
\item{"direct"}{ raw periodogram using \code{\link[sapa]{SDF}}.}
\item{"multitaper"}{ tapering the periodogram using \code{\link[sapa]{SDF}}.}
\item{"mvspec"}{ smoothed estimate using \code{\link[astsa]{mvspec}}; many tuning parameters
are available -- they can be passed as additional arguments (\code{...}) 
to \code{mvspectrum}.}
\item{"pgram"}{ uses \code{\link{mvpgram}}; is the same as the 
\code{'direct'} method, but does not rely on the \code{\link[sapa]{SDF}} 
package.}
\item{"wosa"}{ Welch overlapping segment averaging (WOSA) using \code{\link[sapa]{SDF}}.}

Setting \code{smoothing  = TRUE} will smooth the estimated spectrum
(again); this option is only available for univariate time series/spectra.
}
\description{
Completes algorithm, entropy, and spectrum control lists.
}
\seealso{
\code{\link{mvspectrum}}, \code{\link{discrete_entropy}}, 
\code{\link{continuous_entropy}}
}
\keyword{utils}
