% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cs_dispersion.R
\name{cs_dispersion}
\alias{cs_dispersion}
\title{Compute Cross-Sectional Dispersion}
\usage{
cs_dispersion(x, measure = "SD", plot = FALSE)
}
\arguments{
\item{x}{An object of class \code{foreccomb}. Contains training set (actual values + matrix of model forecasts) and optionally a test set.}

\item{measure}{Cross-sectional dispersion measure, one of: \code{"SD"} = standard deviation (default); \code{"IQR"} = interquartile range; or \code{"Range"} = range.}

\item{plot}{logical. If \code{TRUE}, evolution of cross-sectional forecast dispersion is plotted as \code{ggplot}.}
}
\value{
Returns a vector of the evolution of cross-sectional dispersion over the sample period (using the selected dispersion measure)
}
\description{
Computes (time-varying) dispersion measures for the cross section of individual model forecasts that are the input of forecast combination.
}
\details{
The available measures of scale are defined as in Davison (2003). Let \eqn{y_{(i)}}{y_(i)} denote the i-th order statistic of the sample, then:

\deqn{Range_t = y_{(n), t} - y_{(1), t}}

\deqn{IQR_t = y_{(3n/4),t} - y_{(n/4),t}}

\deqn{SD_t = \sqrt{\frac{1}{n-1} \Sigma_{i=1}^n \left(y_{i,t} - \bar{y}_t \right)}}{SD_t = sqrt(1/(n-1) \Sigma_{i=1}^n (y_{i,t} - \bar{y}_t))}

Previous research in the forecast combination literature has documented that regression-based combination methods tend to have relative advantage when one or more individual model forecasts are better than the rest, while eigenvector-based methods tend to have relative advantage when individual model forecasts are in the same ball park.
}
\examples{
obs <- rnorm(100)
preds <- matrix(rnorm(1000, 1), 100, 10)
train_o<-obs[1:80]
train_p<-preds[1:80,]
test_o<-obs[81:100]
test_p<-preds[81:100,]

data<-foreccomb(train_o, train_p, test_o, test_p)
cs_dispersion(data, measure = "IQR")

}
\references{
Davison, A. C. (2003). Statistical Models. \emph{Cambridge University Press}.

Hsiao, C., and Wan, S. K. (2014). Is There An Optimal Forecast Combination? \emph{Journal of Econometrics}, \bold{178(2)}, 294--309.
}
\seealso{
\code{\link{foreccomb}},
\code{\link[stats]{sd}},
\code{\link[stats]{IQR}},
\code{\link[base]{range}}
}
\keyword{ts}

