% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.foreccomb_res.R
\name{predict.foreccomb_res}
\alias{predict.foreccomb_res}
\title{Prediction function for Forecast Combinations}
\usage{
\method{predict}{foreccomb_res}(object, newpreds, newobs = NULL,
  simplify = TRUE, byrow = FALSE, ...)
}
\arguments{
\item{object}{An object of class 'foreccomb'. Contains training set (actual values + matrix of model forecasts) and optionally a test set.}

\item{newpreds}{A matrix or multivariate time series; contains individual model forecasts if a test set is used (optional). Does not
require specification of \code{newobs} -- in the case in which a forecaster only wants to train the forecast combination method
with a training set and apply it to future individual model forecasts, only \code{newpreds} is required, not \code{newobs}.}

\item{newobs}{A vector or univariate time series; contains \sQuote{actual values} if a test set is used (optional).}

\item{simplify}{logical. The default (\code{TRUE}) returns the predictions separately. If set to (\code{FALSE}) the predictions are incorporated
into the foreccomb_res object, that is, the object is equal to the one that would have been obtained, if the new prediction set would have
been provided when the forecast combination method was trained originally.}

\item{byrow}{logical. The default (\code{FALSE}) assumes that each column of the forecast matrices (\code{prediction_matrix} and -- if
specified -- \code{newpreds}) contains forecasts from one forecast model; if each row of the matrices contains forecasts from
one forecast model, set to \code{TRUE}.}

\item{...}{potential further arguments (require by generic)}
}
\description{
\code{prediction} method for class \sQuote{foreccomb_res}. Uses the previously created forecast combination
result to predict the combination for a newly provided prediction dataset.
}
\examples{
obs <- rnorm(100)
preds <- matrix(rnorm(1000, 1), 100, 10)
train_o<-obs[1:80]
train_p<-preds[1:80,]
test_o<-obs[81:100]
test_p<-preds[81:100,]

data<-foreccomb(train_o, train_p)
fit<-comb_BG(data)
predict(fit, test_p)

}
\author{
Christoph E. Weiss and Gernot R. Roetzer
}
\seealso{
\code{\link[ForecastComb]{foreccomb}},
}

